/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations.distance;

import org.cicirello.permutations.Permutation;
import org.cicirello.permutations.distance.AbstractPermutationDistanceMeasurer;

public final class SquaredDeviationDistance
extends AbstractPermutationDistanceMeasurer {
    @Override
    public int distance(Permutation p1, Permutation p2) {
        int distancePoints = 0;
        int L1 = p1.length();
        int[] invP2 = p2.getInverse();
        for (int i = 0; i < L1; ++i) {
            int dev = invP2[p1.get(i)] - i;
            distancePoints += dev * dev;
        }
        return distancePoints;
    }

    @Override
    public int max(int length) {
        if (length <= 1) {
            return 0;
        }
        return (length * length * length - length) / 3;
    }
}

