/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.rand;

import java.util.Random;
import java.util.SplittableRandom;
import java.util.concurrent.ThreadLocalRandom;
import org.cicirello.math.rand.BTPE;

public final class RandomVariates {
    private RandomVariates() {
    }

    public static int nextBinomial(int n, double p) {
        return BTPE.nextBinomial(n, p, ThreadLocalRandom.current());
    }

    public static int nextBinomial(int n, double p, Random r) {
        return BTPE.nextBinomial(n, p, r);
    }

    public static int nextBinomial(int n, double p, SplittableRandom r) {
        return BTPE.nextBinomial(n, p, r);
    }

    public static double nextCauchy(double median, double scale) {
        double u = ThreadLocalRandom.current().nextDouble();
        if (u == 0.5 && ThreadLocalRandom.current().nextBoolean()) {
            u = -0.5;
        }
        return median + scale * StrictMath.tan(Math.PI * u);
    }

    public static double nextCauchy(double scale) {
        double u = ThreadLocalRandom.current().nextDouble();
        if (u == 0.5 && ThreadLocalRandom.current().nextBoolean()) {
            u = -0.5;
        }
        return scale * StrictMath.tan(Math.PI * u);
    }

    public static double nextCauchy(double median, double scale, Random r) {
        double u = r.nextDouble();
        if (u == 0.5 && r.nextBoolean()) {
            u = -0.5;
        }
        return median + scale * StrictMath.tan(Math.PI * u);
    }

    public static double nextCauchy(double scale, Random r) {
        double u = r.nextDouble();
        if (u == 0.5 && r.nextBoolean()) {
            u = -0.5;
        }
        return scale * StrictMath.tan(Math.PI * u);
    }

    public static double nextCauchy(double median, double scale, SplittableRandom r) {
        double u = r.nextDouble();
        if (u == 0.5 && r.nextBoolean()) {
            u = -0.5;
        }
        return median + scale * StrictMath.tan(Math.PI * u);
    }

    public static double nextCauchy(double scale, SplittableRandom r) {
        double u = r.nextDouble();
        if (u == 0.5 && r.nextBoolean()) {
            u = -0.5;
        }
        return scale * StrictMath.tan(Math.PI * u);
    }
}

