/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations.distance;

import org.cicirello.permutations.Permutation;
import org.cicirello.permutations.distance.AbstractPermutationDistanceMeasurer;

public final class InterchangeDistance
extends AbstractPermutationDistanceMeasurer {
    @Override
    public int distance(Permutation p1, Permutation p2) {
        if (p1.length() != p2.length()) {
            throw new IllegalArgumentException("Permutations must be the same length");
        }
        int numSwaps = 0;
        int length = p1.length();
        boolean[] used = new boolean[length];
        for (int k = 0; k < length; ++k) {
            if (p1.get(k) != p2.get(k)) continue;
            used[p1.get((int)k)] = true;
        }
        int i = 0;
        for (i = 0; i < used.length && used[p1.get(i)]; ++i) {
        }
        if (i >= used.length) {
            return 0;
        }
        int iLast = i;
        int[] invP1 = p1.getInverse();
        boolean done = true;
        do {
            done = true;
            int cycleSize = 0;
            int j = p1.get(i);
            while (!used[j]) {
                used[j] = true;
                ++cycleSize;
                j = p2.get(i);
                i = invP1[j];
            }
            numSwaps += cycleSize - 1;
            for (i = iLast + 1; i < used.length; ++i) {
                if (used[p1.get(i)]) continue;
                done = false;
                break;
            }
            iLast = i;
        } while (!done);
        return numSwaps;
    }

    @Override
    public int max(int length) {
        if (length <= 1) {
            return 0;
        }
        return length - 1;
    }
}

