/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations.distance;

import org.cicirello.permutations.Permutation;
import org.cicirello.permutations.distance.AbstractPermutationDistanceMeasurer;

public final class ReinsertionDistance
extends AbstractPermutationDistanceMeasurer {
    @Override
    public int distance(Permutation p1, Permutation p2) {
        if (p1.length() != p2.length()) {
            throw new IllegalArgumentException("Permutations must be the same length");
        }
        return p1.length() - this.lcs(p1, p2);
    }

    @Override
    public int max(int length) {
        if (length <= 1) {
            return 0;
        }
        return length - 1;
    }

    private int lcs(Permutation p1, Permutation p2) {
        int n = p1.length();
        int[] inv = p2.getInverse();
        int[] match = new int[n];
        int[] thresh = new int[n + 1];
        thresh[0] = -1;
        for (int i = 0; i < n; ++i) {
            match[i] = inv[p1.get(i)];
            thresh[i + 1] = n;
        }
        int maxK = 0;
        for (int i = 0; i < n; ++i) {
            int j = match[i];
            int k = this.binSearch(thresh, j, 0, maxK + 1);
            if (j >= thresh[k]) continue;
            thresh[k] = j;
            if (k <= maxK) continue;
            maxK = k;
        }
        return maxK;
    }

    private int binSearch(int[] array, int value, int low, int high) {
        if (high == low) {
            return low;
        }
        int mid = high + low >> 1;
        if (value <= array[mid] && value > array[mid - 1]) {
            return mid;
        }
        if (value > array[mid]) {
            return this.binSearch(array, value, mid + 1, high);
        }
        return this.binSearch(array, value, low, mid - 1);
    }
}

