/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations.distance;

import org.cicirello.permutations.Permutation;
import org.cicirello.permutations.distance.NormalizedPermutationDistanceMeasurer;

public final class DeviationDistance
implements NormalizedPermutationDistanceMeasurer {
    @Override
    public int distance(Permutation p1, Permutation p2) {
        if (p1.length() != p2.length()) {
            throw new IllegalArgumentException("Permutations must be the same length");
        }
        int distancePoints = 0;
        int[] invP2 = p2.getInverse();
        for (int i = 0; i < invP2.length; ++i) {
            distancePoints += Math.abs(invP2[p1.get(i)] - i);
        }
        return distancePoints;
    }

    @Override
    public int max(int length) {
        if (length <= 1) {
            return 0;
        }
        return length * length - (length & 1) >> 1;
    }
}

