/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations.distance;

import org.cicirello.permutations.Permutation;
import org.cicirello.permutations.distance.NormalizedPermutationDistanceMeasurer;

public final class RTypeDistance
implements NormalizedPermutationDistanceMeasurer {
    @Override
    public int distance(Permutation p1, Permutation p2) {
        int i;
        if (p1.length() != p2.length()) {
            throw new IllegalArgumentException("Permutations must be the same length");
        }
        int countNonSharedEdges = 0;
        if (p2.length() == 0) {
            return 0;
        }
        int[] successors2 = new int[p2.length()];
        for (i = 0; i < successors2.length - 1; ++i) {
            successors2[p2.get((int)i)] = p2.get(i + 1);
        }
        successors2[p2.get((int)(successors2.length - 1))] = -1;
        for (i = 0; i < successors2.length - 1; ++i) {
            if (p1.get(i + 1) == successors2[p1.get(i)]) continue;
            ++countNonSharedEdges;
        }
        return countNonSharedEdges;
    }

    @Override
    public int max(int length) {
        if (length <= 1) {
            return 0;
        }
        return length - 1;
    }
}

