/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.stats;

public final class Statistics {
    private Statistics() {
    }

    public static double mean(int[] data) {
        int sum = 0;
        for (int e : data) {
            sum += e;
        }
        return (double)sum / (double)data.length;
    }

    public static double mean(double[] data) {
        double mean = 0.0;
        for (double e : data) {
            mean += e;
        }
        return mean /= (double)data.length;
    }

    public static double variance(int[] data) {
        if (data.length < 2) {
            return 0.0;
        }
        double mean = Statistics.mean(data);
        double sumSquares = 0.0;
        double sum = 0.0;
        for (int e : data) {
            sumSquares += ((double)e - mean) * ((double)e - mean);
            sum += (double)e - mean;
        }
        return (sumSquares - sum * sum / (double)data.length) / (double)data.length;
    }

    public static double variance(double[] data) {
        if (data.length < 2) {
            return 0.0;
        }
        double mean = Statistics.mean(data);
        double sumSquares = 0.0;
        double sum = 0.0;
        for (double e : data) {
            sumSquares += (e - mean) * (e - mean);
            sum += e - mean;
        }
        return (sumSquares - sum * sum / (double)data.length) / (double)data.length;
    }

    public static double varianceSample(int[] data) {
        if (data.length < 2) {
            return 0.0;
        }
        double mean = Statistics.mean(data);
        double sumSquares = 0.0;
        double sum = 0.0;
        for (int e : data) {
            sumSquares += ((double)e - mean) * ((double)e - mean);
            sum += (double)e - mean;
        }
        return (sumSquares - sum * sum / (double)data.length) / ((double)data.length - 1.0);
    }

    public static double varianceSample(double[] data) {
        if (data.length < 2) {
            return 0.0;
        }
        double mean = Statistics.mean(data);
        double sumSquares = 0.0;
        double sum = 0.0;
        for (double e : data) {
            sumSquares += (e - mean) * (e - mean);
            sum += e - mean;
        }
        return (sumSquares - sum * sum / (double)data.length) / ((double)data.length - 1.0);
    }

    public static double stdev(int[] data) {
        return Math.sqrt(Statistics.varianceSample(data));
    }

    public static double stdev(double[] data) {
        return Math.sqrt(Statistics.varianceSample(data));
    }

    public static double covariance(int[] X, int[] Y) {
        if (X.length < 2) {
            return 0.0;
        }
        if (X.length != Y.length) {
            throw new IllegalArgumentException("Arrays must have same length!");
        }
        double meanX = Statistics.mean(X);
        double meanY = Statistics.mean(Y);
        double sumX = 0.0;
        double sumY = 0.0;
        double sumProduct = 0.0;
        for (int i = 0; i < X.length; ++i) {
            sumX += (double)X[i] - meanX;
            sumY += (double)Y[i] - meanY;
            sumProduct += ((double)X[i] - meanX) * ((double)Y[i] - meanY);
        }
        return (sumProduct - sumX * sumY / (double)X.length) / (double)X.length;
    }

    public static double covariance(double[] X, double[] Y) {
        if (X.length < 2) {
            return 0.0;
        }
        if (X.length != Y.length) {
            throw new IllegalArgumentException("Arrays must have same length!");
        }
        double meanX = Statistics.mean(X);
        double meanY = Statistics.mean(Y);
        double sumX = 0.0;
        double sumY = 0.0;
        double sumProduct = 0.0;
        for (int i = 0; i < X.length; ++i) {
            sumX += X[i] - meanX;
            sumY += Y[i] - meanY;
            sumProduct += (X[i] - meanX) * (Y[i] - meanY);
        }
        return (sumProduct - sumX * sumY / (double)X.length) / (double)X.length;
    }

    public static double correlation(int[] X, int[] Y) {
        double varX = Statistics.variance(X);
        if (varX == 0.0) {
            return 0.0;
        }
        double varY = Statistics.variance(Y);
        if (varY == 0.0) {
            return 0.0;
        }
        double covar = Statistics.covariance(X, Y);
        if (covar == 0.0) {
            return 0.0;
        }
        boolean negate = false;
        if (covar < 0.0) {
            negate = true;
            covar = -covar;
        }
        double logCovar = Math.log(covar);
        double logVarX = Math.log(varX);
        double logVarY = Math.log(varY);
        double corr = Math.exp(logCovar - 0.5 * logVarX - 0.5 * logVarY);
        if (negate) {
            corr = -corr;
        }
        return corr;
    }

    public static double correlation(double[] X, double[] Y) {
        double varX = Statistics.variance(X);
        if (varX == 0.0) {
            return 0.0;
        }
        double varY = Statistics.variance(Y);
        if (varY == 0.0) {
            return 0.0;
        }
        double covar = Statistics.covariance(X, Y);
        if (covar == 0.0) {
            return 0.0;
        }
        boolean negate = false;
        if (covar < 0.0) {
            negate = true;
            covar = -covar;
        }
        double logCovar = Math.log(covar);
        double logVarX = Math.log(varX);
        double logVarY = Math.log(varY);
        double corr = Math.exp(logCovar - 0.5 * logVarX - 0.5 * logVarY);
        if (negate) {
            corr = -corr;
        }
        return corr;
    }

    public static double[][] correlationMatrix(int[][] data) {
        double[][] corr = new double[data.length][data.length];
        for (int i = 0; i < data.length; ++i) {
            corr[i][i] = 1.0;
            for (int j = i + 1; j < data.length; ++j) {
                double d = Statistics.correlation(data[i], data[j]);
                corr[j][i] = d;
                corr[i][j] = d;
            }
        }
        return corr;
    }

    public static double[][] correlationMatrix(double[][] data) {
        double[][] corr = new double[data.length][data.length];
        for (int i = 0; i < data.length; ++i) {
            corr[i][i] = 1.0;
            for (int j = i + 1; j < data.length; ++j) {
                double d = Statistics.correlation(data[i], data[j]);
                corr[j][i] = d;
                corr[i][j] = d;
            }
        }
        return corr;
    }

    public static double tTestUnequalVariances(double[] data1, double[] data2) {
        return (Statistics.mean(data1) - Statistics.mean(data2)) / Math.sqrt(Statistics.varianceSample(data1) / (double)data1.length + Statistics.varianceSample(data2) / (double)data2.length);
    }

    public static double tTestUnequalVariances(int[] data1, int[] data2) {
        return (Statistics.mean(data1) - Statistics.mean(data2)) / Math.sqrt(Statistics.varianceSample(data1) / (double)data1.length + Statistics.varianceSample(data2) / (double)data2.length);
    }

    public static Number[] tTestWelch(double[] data1, double[] data2) {
        Number[] result = new Number[2];
        double term1 = Statistics.varianceSample(data1) / (double)data1.length;
        double term2 = Statistics.varianceSample(data2) / (double)data2.length;
        double termSum = term1 + term2;
        double vDenom = term1 * term1 / (double)(data1.length - 1) + term2 * term2 / (double)(data2.length - 1);
        double v = termSum * termSum / vDenom;
        Double d = (Statistics.mean(data1) - Statistics.mean(data2)) / Math.sqrt(termSum);
        result[0] = d;
        Integer i = (int)v;
        result[1] = i;
        return result;
    }

    public static Number[] tTestWelch(int[] data1, int[] data2) {
        Number[] result = new Number[2];
        double term1 = Statistics.varianceSample(data1) / (double)data1.length;
        double term2 = Statistics.varianceSample(data2) / (double)data2.length;
        double termSum = term1 + term2;
        double vDenom = term1 * term1 / (double)(data1.length - 1) + term2 * term2 / (double)(data2.length - 1);
        double v = termSum * termSum / vDenom;
        Double d = (Statistics.mean(data1) - Statistics.mean(data2)) / Math.sqrt(termSum);
        result[0] = d;
        Integer i = (int)v;
        result[1] = i;
        return result;
    }
}

