/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.la;

public final class MatrixOps {
    private MatrixOps() {
    }

    public static int[][] transposeSquareMatrixInline(int[][] matrix) {
        if (matrix.length > 0 && matrix.length != matrix[0].length) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = i + 1; j < matrix.length; ++j) {
                int temp = matrix[i][j];
                matrix[i][j] = matrix[j][i];
                matrix[j][i] = temp;
            }
        }
        return matrix;
    }

    public static double[][] transposeSquareMatrixInline(double[][] matrix) {
        if (matrix.length > 0 && matrix.length != matrix[0].length) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = i + 1; j < matrix.length; ++j) {
                double temp = matrix[i][j];
                matrix[i][j] = matrix[j][i];
                matrix[j][i] = temp;
            }
        }
        return matrix;
    }

    public static int[][] sum(int[][] A, int[][] B, int[][] C) {
        if (A.length != B.length) {
            throw new IllegalArgumentException("Number of rows of A and B must be equal.");
        }
        if (A.length == 0) {
            if (C == null) {
                return new int[0][0];
            }
            if (C.length == 0) {
                return C;
            }
            throw new IllegalArgumentException("Number of rows of A, B, and C must be equal.");
        }
        if (A[0].length != B[0].length) {
            throw new IllegalArgumentException("Number of columns of A and B must be equal.");
        }
        if (C == null) {
            C = new int[A.length][A[0].length];
        } else {
            if (C.length != B.length) {
                throw new IllegalArgumentException("Number of rows of A, B, and C must be equal.");
            }
            if (C[0].length != B[0].length) {
                throw new IllegalArgumentException("Number of columns of A, B, and C must be equal.");
            }
        }
        for (int i = 0; i < C.length; ++i) {
            for (int j = 0; j < C[i].length; ++j) {
                C[i][j] = A[i][j] + B[i][j];
            }
        }
        return C;
    }

    public static double[][] sum(double[][] A, double[][] B, double[][] C) {
        if (A.length != B.length) {
            throw new IllegalArgumentException("Number of rows of A and B must be equal.");
        }
        if (A.length == 0) {
            if (C == null) {
                return new double[0][0];
            }
            if (C.length == 0) {
                return C;
            }
            throw new IllegalArgumentException("Number of rows of A, B, and C must be equal.");
        }
        if (A[0].length != B[0].length) {
            throw new IllegalArgumentException("Number of columns of A and B must be equal.");
        }
        if (C == null) {
            C = new double[A.length][A[0].length];
        } else {
            if (C.length != B.length) {
                throw new IllegalArgumentException("Number of rows of A, B, and C must be equal.");
            }
            if (C[0].length != B[0].length) {
                throw new IllegalArgumentException("Number of columns of A, B, and C must be equal.");
            }
        }
        for (int i = 0; i < C.length; ++i) {
            for (int j = 0; j < C[i].length; ++j) {
                C[i][j] = A[i][j] + B[i][j];
            }
        }
        return C;
    }

    public static int[][] sum(int[][] A, int[][] B) {
        return MatrixOps.sum(A, B, null);
    }

    public static double[][] sum(double[][] A, double[][] B) {
        return MatrixOps.sum(A, B, null);
    }

    public static int[][] difference(int[][] A, int[][] B, int[][] C) {
        if (A.length != B.length) {
            throw new IllegalArgumentException("Number of rows of A and B must be equal.");
        }
        if (A.length == 0) {
            if (C == null) {
                return new int[0][0];
            }
            if (C.length == 0) {
                return C;
            }
            throw new IllegalArgumentException("Number of rows of A, B, and C must be equal.");
        }
        if (A[0].length != B[0].length) {
            throw new IllegalArgumentException("Number of columns of A and B must be equal.");
        }
        if (C == null) {
            C = new int[A.length][A[0].length];
        } else {
            if (C.length != B.length) {
                throw new IllegalArgumentException("Number of rows of A, B, and C must be equal.");
            }
            if (C[0].length != B[0].length) {
                throw new IllegalArgumentException("Number of columns of A, B, and C must be equal.");
            }
        }
        for (int i = 0; i < C.length; ++i) {
            for (int j = 0; j < C[i].length; ++j) {
                C[i][j] = A[i][j] - B[i][j];
            }
        }
        return C;
    }

    public static double[][] difference(double[][] A, double[][] B, double[][] C) {
        if (A.length != B.length) {
            throw new IllegalArgumentException("Number of rows of A and B must be equal.");
        }
        if (A.length == 0) {
            if (C == null) {
                return new double[0][0];
            }
            if (C.length == 0) {
                return C;
            }
            throw new IllegalArgumentException("Number of rows of A, B, and C must be equal.");
        }
        if (A[0].length != B[0].length) {
            throw new IllegalArgumentException("Number of columns of A and B must be equal.");
        }
        if (C == null) {
            C = new double[A.length][A[0].length];
        } else {
            if (C.length != B.length) {
                throw new IllegalArgumentException("Number of rows of A, B, and C must be equal.");
            }
            if (C[0].length != B[0].length) {
                throw new IllegalArgumentException("Number of columns of A, B, and C must be equal.");
            }
        }
        for (int i = 0; i < C.length; ++i) {
            for (int j = 0; j < C[i].length; ++j) {
                C[i][j] = A[i][j] - B[i][j];
            }
        }
        return C;
    }

    public static int[][] difference(int[][] A, int[][] B) {
        return MatrixOps.difference(A, B, null);
    }

    public static double[][] difference(double[][] A, double[][] B) {
        return MatrixOps.difference(A, B, null);
    }

    public static int[][] product(int[][] A, int[][] B, int[][] C) {
        if (A.length == 0 && B.length > 0 || A.length > 0 && B.length == 0) {
            throw new IllegalArgumentException("If either matrix has 0 rows, both must.");
        }
        if (A.length == 0) {
            if (C == null) {
                return new int[0][0];
            }
            if (C.length == 0) {
                return C;
            }
            throw new IllegalArgumentException("C's dimensions are inconsistent with A and B.");
        }
        if (A[0].length != B.length) {
            throw new IllegalArgumentException("Number of columns of A must equal number of rows of B.");
        }
        if (C == null) {
            C = new int[A.length][B[0].length];
        } else {
            if (C.length != A.length) {
                throw new IllegalArgumentException("Number of rows of A and C must be equal.");
            }
            if (C[0].length != B[0].length) {
                throw new IllegalArgumentException("Number of columns of B and C must be equal.");
            }
        }
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < B[0].length; ++j) {
                C[i][j] = 0;
                for (int k = 0; k < B.length; ++k) {
                    C[i][j] = C[i][j] + A[i][k] * B[k][j];
                }
            }
        }
        return C;
    }

    public static double[][] product(double[][] A, double[][] B, double[][] C) {
        if (A.length == 0 && B.length > 0 || A.length > 0 && B.length == 0) {
            throw new IllegalArgumentException("If either matrix has 0 rows, both must.");
        }
        if (A.length == 0) {
            if (C == null) {
                return new double[0][0];
            }
            if (C.length == 0) {
                return C;
            }
            throw new IllegalArgumentException("C's dimensions are inconsistent with A and B.");
        }
        if (A[0].length != B.length) {
            throw new IllegalArgumentException("Number of columns of A must equal number of rows of B.");
        }
        if (C == null) {
            C = new double[A.length][B[0].length];
        } else {
            if (C.length != A.length) {
                throw new IllegalArgumentException("Number of rows of A and C must be equal.");
            }
            if (C[0].length != B[0].length) {
                throw new IllegalArgumentException("Number of columns of B and C must be equal.");
            }
        }
        for (int i = 0; i < A.length; ++i) {
            for (int j = 0; j < B[0].length; ++j) {
                C[i][j] = 0.0;
                for (int k = 0; k < B.length; ++k) {
                    C[i][j] = C[i][j] + A[i][k] * B[k][j];
                }
            }
        }
        return C;
    }

    public static int[][] product(int[][] A, int[][] B) {
        return MatrixOps.product(A, B, null);
    }

    public static double[][] product(double[][] A, double[][] B) {
        return MatrixOps.product(A, B, null);
    }
}

