/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.ds;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.cicirello.ds.PriorityQueue;
import org.cicirello.ds.PriorityQueueNode;
import org.cicirello.util.Copyable;

public final class BinaryHeap<E>
implements PriorityQueue<E>,
Copyable<BinaryHeap<E>> {
    private PriorityQueueNode.Integer<E>[] buffer;
    private int size;
    private final HashMap<E, Integer> index;
    private final PriorityComparator compare;
    private final int extreme;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;

    private BinaryHeap(int initialCapacity) {
        this(initialCapacity, (int p1, int p2) -> p1 < p2);
    }

    private BinaryHeap(int initialCapacity, PriorityComparator compare) {
        this.compare = compare;
        this.buffer = this.allocate(initialCapacity);
        this.index = new HashMap();
        this.extreme = compare.belongsAbove(0, 1) ? Integer.MAX_VALUE : Integer.MIN_VALUE;
    }

    private BinaryHeap(Collection<PriorityQueueNode.Integer<E>> initialElements) {
        this(initialElements, (int p1, int p2) -> p1 < p2);
    }

    private BinaryHeap(Collection<PriorityQueueNode.Integer<E>> initialElements, PriorityComparator compare) {
        this(initialElements.size(), compare);
        for (PriorityQueueNode.Integer<E> element : initialElements) {
            if (this.index.containsKey(element.element)) {
                throw new IllegalArgumentException("initialElements contains duplicates");
            }
            this.buffer[this.size] = element.copy();
            this.index.put(this.buffer[this.size].element, this.size);
            ++this.size;
        }
        this.buildHeap();
    }

    private BinaryHeap(BinaryHeap<E> other) {
        this(other.capacity(), other.compare);
        this.size = other.size;
        for (int i = 0; i < this.size; ++i) {
            this.buffer[i] = other.buffer[i].copy();
            this.index.put(this.buffer[i].element, i);
        }
    }

    @Override
    public BinaryHeap<E> copy() {
        return new BinaryHeap<E>(this);
    }

    public static <E> BinaryHeap<E> createMinHeap() {
        return new BinaryHeap<E>(16);
    }

    public static <E> BinaryHeap<E> createMinHeap(int initialCapacity) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("Initial capacity must be positive.");
        }
        return new BinaryHeap<E>(initialCapacity);
    }

    public static <E> BinaryHeap<E> createMinHeap(Collection<PriorityQueueNode.Integer<E>> initialElements) {
        if (initialElements.size() < 1) {
            throw new IllegalArgumentException("initialElements is empty");
        }
        return new BinaryHeap<E>(initialElements);
    }

    public static <E> BinaryHeap<E> createMaxHeap() {
        return new BinaryHeap<E>(16, (p1, p2) -> p1 > p2);
    }

    public static <E> BinaryHeap<E> createMaxHeap(int initialCapacity) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("Initial capacity must be positive.");
        }
        return new BinaryHeap<E>(initialCapacity, (p1, p2) -> p1 > p2);
    }

    public static <E> BinaryHeap<E> createMaxHeap(Collection<PriorityQueueNode.Integer<E>> initialElements) {
        if (initialElements.size() < 1) {
            throw new IllegalArgumentException("initialElements is empty");
        }
        return new BinaryHeap<E>(initialElements, (p1, p2) -> p1 > p2);
    }

    @Override
    public final boolean change(E element, int priority) {
        if (!this.offer(element, priority)) {
            int i = this.index.get(element);
            if (this.compare.belongsAbove(priority, this.buffer[i].value)) {
                this.buffer[i].value = priority;
                this.percolateUp(i);
                return true;
            }
            if (this.compare.belongsAbove(this.buffer[i].value, priority)) {
                this.buffer[i].value = priority;
                this.percolateDown(i);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public final void clear() {
        Arrays.fill(this.buffer, null);
        this.size = 0;
        this.index.clear();
    }

    @Override
    public final boolean contains(Object o) {
        if (o instanceof PriorityQueueNode.Integer) {
            PriorityQueueNode.Integer pair = (PriorityQueueNode.Integer)o;
            return this.index.containsKey(pair.element);
        }
        return this.index.containsKey(o);
    }

    @Override
    public final boolean demote(E element, int priority) {
        Integer where = this.index.get(element);
        if (where != null) {
            int i = where;
            if (this.compare.belongsAbove(this.buffer[i].value, priority)) {
                this.buffer[i].value = priority;
                this.percolateDown(i);
                return true;
            }
        }
        return false;
    }

    public final void ensureCapacity(int minCapacity) {
        if (this.buffer.length < minCapacity) {
            this.internalAdjustCapacity(minCapacity);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof BinaryHeap) {
            BinaryHeap casted = (BinaryHeap)other;
            if (this.size != casted.size) {
                return false;
            }
            if (this.compare.belongsAbove(0, 1) != casted.compare.belongsAbove(0, 1)) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (!this.buffer[i].element.equals(casted.buffer[i].element)) {
                    return false;
                }
                if (casted.buffer[i].value == this.buffer[i].value) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.size; ++i) {
            h = 31 * h + this.buffer[i].value;
            h = 31 * h + this.buffer[i].element.hashCode();
        }
        return h;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final Iterator<PriorityQueueNode.Integer<E>> iterator() {
        return new BinaryHeapIterator();
    }

    @Override
    public final boolean offer(E element, int priority) {
        if (this.contains(element)) {
            return false;
        }
        return this.internalOffer(new PriorityQueueNode.Integer<E>(element, priority));
    }

    @Override
    public final boolean offer(PriorityQueueNode.Integer<E> pair) {
        if (this.contains(pair.element)) {
            return false;
        }
        return this.internalOffer((PriorityQueueNode.Integer<E>)pair.copy());
    }

    @Override
    public final E peekElement() {
        return (E)(this.size > 0 ? this.buffer[0].element : null);
    }

    @Override
    public final PriorityQueueNode.Integer<E> peek() {
        return this.size > 0 ? this.buffer[0] : null;
    }

    @Override
    public final int peekPriority() {
        return this.size > 0 ? this.buffer[0].value : this.extreme;
    }

    @Override
    public final int peekPriority(E element) {
        Integer i = this.index.get(element);
        return i != null ? this.buffer[i.intValue()].value : this.extreme;
    }

    @Override
    public final E pollElement() {
        Object min = this.poll();
        return (E)(min != null ? ((PriorityQueueNode.Integer)min).element : null);
    }

    @Override
    public final PriorityQueueNode.Integer<E> poll() {
        if (this.size > 0) {
            PriorityQueueNode.Integer<E> min = this.buffer[0];
            this.index.remove(min.element);
            --this.size;
            if (this.size > 0) {
                this.buffer[0] = this.buffer[this.size];
                this.buffer[this.size] = null;
                this.index.put(this.buffer[0].element, 0);
                this.percolateDown(0);
            } else {
                this.buffer[0] = null;
            }
            return min;
        }
        return null;
    }

    @Override
    public final boolean promote(E element, int priority) {
        Integer where = this.index.get(element);
        if (where != null) {
            int i = where;
            if (this.compare.belongsAbove(priority, this.buffer[i].value)) {
                this.buffer[i].value = priority;
                this.percolateUp(i);
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean remove(Object o) {
        Integer i = null;
        if (o instanceof PriorityQueueNode.Integer) {
            PriorityQueueNode.Integer pair = (PriorityQueueNode.Integer)o;
            i = this.index.get(pair.element);
        } else {
            i = this.index.get(o);
        }
        if (i == null) {
            return false;
        }
        this.index.remove(this.buffer[i.intValue()].element);
        --this.size;
        if (this.size > 0 && i != this.size) {
            int removedElementPriority = this.buffer[i.intValue()].value;
            this.buffer[i.intValue()] = this.buffer[this.size];
            this.buffer[this.size] = null;
            this.index.put(this.buffer[i.intValue()].element, i);
            if (this.compare.belongsAbove(this.buffer[i.intValue()].value, removedElementPriority)) {
                this.percolateUp(i);
            } else if (this.compare.belongsAbove(removedElementPriority, this.buffer[i.intValue()].value)) {
                this.percolateDown(i);
            }
        } else {
            this.buffer[i.intValue()] = null;
        }
        return true;
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        HashSet<Object> deleteThese = new HashSet<Object>();
        for (int i = 0; i < this.size; ++i) {
            deleteThese.add(this.buffer[i].element);
        }
        for (Object o : c) {
            if (o instanceof PriorityQueueNode.Integer) {
                PriorityQueueNode.Integer integer = (PriorityQueueNode.Integer)o;
                deleteThese.remove(integer.element);
                continue;
            }
            deleteThese.remove(o);
        }
        boolean changed = false;
        for (Object e : deleteThese) {
            this.remove(e);
            changed = true;
        }
        return changed;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final Object[] toArray() {
        Object[] array = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            array[i] = this.buffer[i];
        }
        return array;
    }

    @Override
    public final <T> T[] toArray(T[] array) {
        T[] result = array.length >= this.size ? array : (Object[])Array.newInstance(array.getClass().getComponentType(), this.size);
        for (int i = 0; i < this.size; ++i) {
            PriorityQueueNode.Integer<E> nextElement = this.buffer[i];
            result[i] = nextElement;
        }
        if (result.length > this.size) {
            result[this.size] = null;
        }
        return result;
    }

    public final void trimToSize() {
        if (this.size < this.buffer.length) {
            this.internalAdjustCapacity(this.size > 0 ? this.size : 1);
        }
    }

    int capacity() {
        return this.buffer.length;
    }

    private void percolateDown(int i) {
        int left;
        while ((left = (i << 1) + 1) < this.size) {
            int right;
            int smallest = i;
            if (this.compare.belongsAbove(this.buffer[left].value, this.buffer[i].value)) {
                smallest = left;
            }
            if ((right = left + 1) < this.size && this.compare.belongsAbove(this.buffer[right].value, this.buffer[smallest].value)) {
                smallest = right;
            }
            if (smallest == i) break;
            PriorityQueueNode.Integer<E> temp = this.buffer[i];
            this.buffer[i] = this.buffer[smallest];
            this.buffer[smallest] = temp;
            this.index.put(this.buffer[i].element, i);
            this.index.put(this.buffer[smallest].element, smallest);
            i = smallest;
        }
    }

    private void percolateUp(int i) {
        while (i > 0) {
            int parent = i - 1 >> 1;
            if (!this.compare.belongsAbove(this.buffer[i].value, this.buffer[parent].value)) break;
            PriorityQueueNode.Integer<E> temp = this.buffer[i];
            this.buffer[i] = this.buffer[parent];
            this.buffer[parent] = temp;
            this.index.put(this.buffer[i].element, i);
            this.index.put(this.buffer[parent].element, parent);
            i = parent;
        }
    }

    private PriorityQueueNode.Integer<E>[] allocate(int capacity) {
        PriorityQueueNode.Integer[] temp = new PriorityQueueNode.Integer[capacity];
        return temp;
    }

    private void internalAdjustCapacity(int capacity) {
        PriorityQueueNode.Integer<E>[] temp = this.allocate(capacity);
        System.arraycopy(this.buffer, 0, temp, 0, this.size);
        this.buffer = temp;
    }

    private boolean internalOffer(PriorityQueueNode.Integer<E> pair) {
        if (this.size == this.buffer.length) {
            this.internalAdjustCapacity(this.size << 1);
        }
        this.buffer[this.size] = pair;
        this.index.put(pair.element, this.size);
        this.percolateUp(this.size);
        ++this.size;
        return true;
    }

    private void buildHeap() {
        for (int i = (this.size >> 1) - 1; i >= 0; --i) {
            this.percolateDown(i);
        }
    }

    @FunctionalInterface
    private static interface PriorityComparator {
        public boolean belongsAbove(int var1, int var2);
    }

    private class BinaryHeapIterator
    implements Iterator<PriorityQueueNode.Integer<E>> {
        private int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < BinaryHeap.this.size;
        }

        @Override
        public PriorityQueueNode.Integer<E> next() {
            if (this.index >= BinaryHeap.this.size) {
                throw new NoSuchElementException("No more elements remain.");
            }
            ++this.index;
            return BinaryHeap.this.buffer[this.index - 1];
        }
    }
}

