/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.ds;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.cicirello.ds.PriorityQueueNode;

public interface PriorityQueue<E>
extends Queue<PriorityQueueNode.Integer<E>> {
    default public boolean add(E element, int priority) {
        if (!this.offer(element, priority)) {
            throw new IllegalArgumentException("already contains an (element, priority) pair with this element");
        }
        return true;
    }

    @Override
    default public boolean add(PriorityQueueNode.Integer<E> pair) {
        if (!this.offer(pair)) {
            throw new IllegalArgumentException("already contains an (element, priority) pair with this element");
        }
        return true;
    }

    @Override
    default public boolean addAll(Collection<? extends PriorityQueueNode.Integer<E>> c) {
        boolean changed = false;
        for (PriorityQueueNode.Integer<E> e : c) {
            this.add(e);
            changed = true;
        }
        return changed;
    }

    public boolean change(E var1, int var2);

    @Override
    public void clear();

    @Override
    public boolean contains(Object var1);

    @Override
    default public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public boolean demote(E var1, int var2);

    @Override
    default public PriorityQueueNode.Integer<E> element() {
        Object result = this.peek();
        if (result == null) {
            throw new NoSuchElementException("PriorityQueue is empty");
        }
        return result;
    }

    @Override
    public boolean isEmpty();

    @Override
    public Iterator<PriorityQueueNode.Integer<E>> iterator();

    public boolean offer(E var1, int var2);

    @Override
    public boolean offer(PriorityQueueNode.Integer<E> var1);

    @Override
    public PriorityQueueNode.Integer<E> peek();

    public int peekPriority();

    public int peekPriority(E var1);

    public E peekElement();

    @Override
    public PriorityQueueNode.Integer<E> poll();

    public E pollElement();

    public boolean promote(E var1, int var2);

    @Override
    default public PriorityQueueNode.Integer<E> remove() {
        Object result = this.poll();
        if (result == null) {
            throw new NoSuchElementException("PriorityQueue is empty");
        }
        return result;
    }

    @Override
    public boolean remove(Object var1);

    @Override
    default public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            changed = true;
        }
        return changed;
    }

    default public E removeElement() {
        E result = this.pollElement();
        if (result == null) {
            throw new NoSuchElementException("PriorityQueue is empty");
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> var1);

    @Override
    public int size();

    @Override
    public Object[] toArray();

    @Override
    public <T> T[] toArray(T[] var1);
}

