/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations.distance;

import org.cicirello.permutations.Permutation;
import org.cicirello.permutations.distance.NormalizedPermutationDistanceMeasurer;

public final class LeeDistance
implements NormalizedPermutationDistanceMeasurer {
    @Override
    public int distance(Permutation p1, Permutation p2) {
        if (p1.length() != p2.length()) {
            throw new IllegalArgumentException("Permutations must be the same length");
        }
        if (p1.length() <= 1) {
            return 0;
        }
        int distancePoints = 0;
        int[] invP1 = p1.getInverse();
        int[] invP2 = p2.getInverse();
        for (int i = 0; i < invP1.length; ++i) {
            int dev = Math.abs(invP1[i] - invP2[i]);
            distancePoints += Math.min(dev, invP1.length - dev);
        }
        return distancePoints;
    }

    @Override
    public int max(int length) {
        if (length <= 1) {
            return 0;
        }
        return length * (length >> 1);
    }
}

