/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.random.RandomGenerator;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.PermutationBinaryOperator;
import org.cicirello.permutations.PermutationIterator;
import org.cicirello.permutations.PermutationUnaryOperator;
import org.cicirello.util.Copyable;

public final class Permutation
implements Serializable,
Iterable<Permutation>,
Copyable<Permutation> {
    private static final long serialVersionUID = 1L;
    private final int[] permutation;

    public Permutation(int n) {
        this.permutation = new int[n];
        this.scramble();
    }

    public Permutation(int n, RandomGenerator r) {
        this.permutation = new int[n];
        this.scramble(r);
    }

    public Permutation(int n, int value) {
        int i;
        this.permutation = new int[n];
        for (i = 0; i < n; ++i) {
            this.permutation[i] = i;
        }
        for (i = 0; i < n - 1; ++i) {
            int j = i + value % (n - i);
            int temp = this.permutation[j];
            for (int k = j; k > i; --k) {
                this.permutation[k] = this.permutation[k - 1];
            }
            this.permutation[i] = temp;
            value /= n - i;
        }
    }

    public Permutation(int n, BigInteger value) {
        int i;
        this.permutation = new int[n];
        for (i = 0; i < n; ++i) {
            this.permutation[i] = i;
        }
        for (i = 0; i < n - 1; ++i) {
            BigInteger[] divRem = value.divideAndRemainder(BigInteger.valueOf(n - i));
            int j = i + divRem[1].intValue();
            int temp = this.permutation[j];
            for (int k = j; k > i; --k) {
                this.permutation[k] = this.permutation[k - 1];
            }
            this.permutation[i] = temp;
            value = divRem[0];
        }
    }

    public Permutation(int[] p) {
        this(p, true);
    }

    private Permutation(int[] p, boolean validate) {
        if (validate) {
            boolean[] inP = new boolean[p.length];
            for (int e : p) {
                if (e < 0 || e >= p.length) {
                    throw new IllegalArgumentException("Elements of p must be in interval [0, p.length)");
                }
                if (inP[e]) {
                    throw new IllegalArgumentException("Duplicate elements of p are not allowed.");
                }
                inP[e] = true;
            }
        }
        this.permutation = (int[])p.clone();
    }

    public Permutation(Permutation p) {
        this.permutation = (int[])p.permutation.clone();
    }

    public Permutation(Permutation p, int length) {
        if (length >= p.permutation.length) {
            this.permutation = (int[])p.permutation.clone();
        } else if (length <= 0) {
            this.permutation = new int[0];
        } else {
            this.permutation = new int[length];
            int k = 0;
            for (int i = 0; i < p.permutation.length && k < length; ++i) {
                if (p.permutation[i] >= length) continue;
                this.permutation[k] = p.permutation[i];
                ++k;
            }
        }
    }

    public void apply(PermutationUnaryOperator operator) {
        operator.apply(this.permutation);
    }

    public void apply(PermutationBinaryOperator operator, Permutation other) {
        operator.apply(this.permutation, other.permutation);
    }

    public Permutation copy() {
        return new Permutation(this);
    }

    public int toInteger() {
        int N = this.permutation.length;
        if (N > 12) {
            throw new UnsupportedOperationException("Unsupported for permutations of length greater than 12.");
        }
        int[] index = new int[N];
        for (int i = 0; i < N; ++i) {
            index[i] = i;
        }
        int result = 0;
        int multiplier = 1;
        int factor = N;
        for (int i = 0; i < N - 1; ++i) {
            result += multiplier * index[this.permutation[i]];
            int j = this.permutation[i];
            while (j < N) {
                int n = j++;
                index[n] = index[n] - 1;
            }
            multiplier *= factor;
            --factor;
        }
        return result;
    }

    public BigInteger toBigInteger() {
        int N = this.permutation.length;
        if (N <= 12) {
            return BigInteger.valueOf(this.toInteger());
        }
        int[] index = new int[N];
        for (int i = 0; i < N; ++i) {
            index[i] = i;
        }
        BigInteger result = BigInteger.ZERO;
        BigInteger multiplier = BigInteger.ONE;
        int factor = N;
        for (int i = 0; i < N - 1; ++i) {
            result = result.add(multiplier.multiply(BigInteger.valueOf(index[this.permutation[i]])));
            int j = this.permutation[i];
            while (j < N) {
                int n = j++;
                index[n] = index[n] - 1;
            }
            multiplier = multiplier.multiply(BigInteger.valueOf(factor));
            --factor;
        }
        return result;
    }

    public int[] getInverse() {
        int[] inverse = new int[this.permutation.length];
        for (int i = 0; i < this.permutation.length; ++i) {
            inverse[this.permutation[i]] = i;
        }
        return inverse;
    }

    public Permutation getInversePermutation() {
        return new Permutation(this.getInverse(), false);
    }

    public void invert() {
        int[] inverse = this.getInverse();
        System.arraycopy(inverse, 0, this.permutation, 0, inverse.length);
    }

    public void scramble() {
        this.scramble(ThreadLocalRandom.current());
    }

    public void scramble(RandomGenerator r) {
        if (this.permutation.length > 0) {
            this.permutation[0] = 0;
            for (int i = 1; i < this.permutation.length; ++i) {
                int j = RandomIndexer.nextInt((int)(i + 1), (RandomGenerator)r);
                if (j == i) {
                    this.permutation[i] = i;
                    continue;
                }
                this.permutation[i] = this.permutation[j];
                this.permutation[j] = i;
            }
        }
    }

    public void scramble(boolean guaranteeDifferent) {
        this.scramble(ThreadLocalRandom.current(), guaranteeDifferent);
    }

    public void scramble(RandomGenerator r, boolean guaranteeDifferent) {
        if (guaranteeDifferent) {
            boolean changed = false;
            for (int i = this.permutation.length - 1; i > 1; --i) {
                int j = RandomIndexer.nextInt((int)(i + 1), (RandomGenerator)r);
                if (i == j) continue;
                this.swap(i, j);
                changed = true;
            }
            if (this.permutation.length > 1 && (!changed || r.nextBoolean())) {
                this.swap(0, 1);
            }
        } else {
            this.scramble(r);
        }
    }

    public void scramble(int i, int j) {
        this.scramble(i, j, ThreadLocalRandom.current());
    }

    public void scramble(int i, int j, RandomGenerator r) {
        if (i == j) {
            return;
        }
        if (i > j) {
            int temp = i;
            i = j;
            j = temp;
        }
        boolean changed = false;
        for (int k = j; k > i + 1; --k) {
            int l = i + RandomIndexer.nextInt((int)(k - i + 1), (RandomGenerator)r);
            if (l == k) continue;
            this.swap(l, k);
            changed = true;
        }
        if (!changed || r.nextBoolean()) {
            this.swap(i, i + 1);
        }
    }

    public void scramble(int[] indexes, RandomGenerator r) {
        if (indexes.length > 1) {
            boolean changed = false;
            for (int j = indexes.length - 1; j > 1; --j) {
                int i = RandomIndexer.nextInt((int)(j + 1), (RandomGenerator)r);
                if (i == j) continue;
                this.swap(indexes[i], indexes[j]);
                changed = true;
            }
            if (!changed || r.nextBoolean()) {
                this.swap(indexes[0], indexes[1]);
            }
        }
    }

    public void scramble(int[] indexes) {
        this.scramble(indexes, ThreadLocalRandom.current());
    }

    public int get(int i) {
        return this.permutation[i];
    }

    public int[] get(int i, int j) {
        if (j < i) {
            throw new IllegalArgumentException("j must not be less than i");
        }
        int[] array = new int[j - i + 1];
        System.arraycopy(this.permutation, i, array, 0, array.length);
        return array;
    }

    public int[] get(int i, int j, int[] array) {
        if (j < i) {
            throw new IllegalArgumentException("j must not be less than i");
        }
        int n = j - i + 1;
        if (array == null || array.length != n) {
            array = new int[n];
        }
        System.arraycopy(this.permutation, i, array, 0, array.length);
        return array;
    }

    public int[] toArray() {
        return (int[])this.permutation.clone();
    }

    public int[] toArray(int[] array) {
        if (array == null || array.length != this.permutation.length) {
            return (int[])this.permutation.clone();
        }
        System.arraycopy(this.permutation, 0, array, 0, array.length);
        return array;
    }

    public int length() {
        return this.permutation.length;
    }

    public void swap(int i, int j) {
        int temp = this.permutation[i];
        this.permutation[i] = this.permutation[j];
        this.permutation[j] = temp;
    }

    public void cycle(int[] indexes) {
        if (indexes.length > 1) {
            int temp = this.permutation[indexes[0]];
            for (int i = 1; i < indexes.length; ++i) {
                this.permutation[indexes[i - 1]] = this.permutation[indexes[i]];
            }
            this.permutation[indexes[indexes.length - 1]] = temp;
        }
    }

    public void swapBlocks(int a, int b, int i, int j) {
        if (a < 0 || b < a || i <= b || j < i || j >= this.permutation.length) {
            throw new IllegalArgumentException("Illegal block definition.");
        }
        if (a == b && i == j) {
            this.swap(a, i);
        } else if (b + 1 == i) {
            this.removeAndInsert(i, j - i + 1, a);
        } else {
            int[] temp = new int[j - a + 1];
            int k = j - i + 1;
            System.arraycopy(this.permutation, i, temp, 0, k);
            int m = i - b - 1;
            System.arraycopy(this.permutation, b + 1, temp, k, m);
            System.arraycopy(this.permutation, a, temp, k + m, b - a + 1);
            System.arraycopy(temp, 0, this.permutation, a, temp.length);
        }
    }

    public void reverse() {
        int i = 0;
        for (int j = this.permutation.length - 1; i < j; ++i, --j) {
            this.swap(i, j);
        }
    }

    public void reverse(int i, int j) {
        if (i > j) {
            while (i > j) {
                this.swap(i, j);
                --i;
                ++j;
            }
        } else {
            while (i < j) {
                this.swap(i, j);
                ++i;
                --j;
            }
        }
    }

    public void removeAndInsert(int i, int j) {
        if (i < j) {
            int n = this.permutation[i];
            System.arraycopy(this.permutation, i + 1, this.permutation, i, j - i);
            this.permutation[j] = n;
        } else if (i > j) {
            int n = this.permutation[i];
            System.arraycopy(this.permutation, j, this.permutation, j + 1, i - j);
            this.permutation[j] = n;
        }
    }

    public void rotate(int numPositions) {
        if (numPositions >= this.permutation.length || numPositions < 0) {
            numPositions = Math.floorMod(numPositions, this.permutation.length);
        }
        if (numPositions == 0) {
            return;
        }
        int[] temp = new int[numPositions];
        System.arraycopy(this.permutation, 0, temp, 0, numPositions);
        System.arraycopy(this.permutation, numPositions, this.permutation, 0, this.permutation.length - numPositions);
        System.arraycopy(temp, 0, this.permutation, this.permutation.length - numPositions, numPositions);
    }

    public void removeAndInsert(int i, int size, int j) {
        if (size == 0 || i == j) {
            return;
        }
        if (size == 1) {
            this.removeAndInsert(i, j);
        } else if (i > j) {
            int[] temp = new int[i - j];
            System.arraycopy(this.permutation, j, temp, 0, i - j);
            System.arraycopy(this.permutation, i, this.permutation, j, size);
            System.arraycopy(temp, 0, this.permutation, j + size, i - j);
        } else {
            int[] temp = new int[size];
            System.arraycopy(this.permutation, i, temp, 0, size);
            System.arraycopy(this.permutation, i + size, this.permutation, i, j - i);
            System.arraycopy(temp, 0, this.permutation, j, size);
        }
    }

    public void set(int[] p) {
        if (p.length != this.permutation.length) {
            throw new IllegalArgumentException("Length of array must be same as that of permutation.");
        }
        boolean[] inP = new boolean[p.length];
        for (int e : p) {
            if (e < 0 || e >= p.length) {
                throw new IllegalArgumentException("Elements of p must be in interval [0, p.length)");
            }
            if (inP[e]) {
                throw new IllegalArgumentException("Duplicate elements of p are not allowed.");
            }
            inP[e] = true;
        }
        System.arraycopy(p, 0, this.permutation, 0, p.length);
    }

    @Override
    public Iterator<Permutation> iterator() {
        return new PermutationIterator(this);
    }

    public String toString() {
        Object permS = "";
        if (this.permutation.length > 0) {
            permS = (String)permS + this.permutation[0];
            for (int i = 1; i < this.permutation.length; ++i) {
                permS = (String)permS + " " + this.permutation[i];
            }
        }
        return permS;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Permutation)) {
            return false;
        }
        Permutation o = (Permutation)other;
        if (this.permutation.length != o.permutation.length) {
            return false;
        }
        for (int i = 0; i < this.permutation.length; ++i) {
            if (this.permutation[i] == o.permutation[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.permutation);
    }
}

