/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.sequences;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.math.rand.RandomVariates;

public final class SequenceSampler {
    private SequenceSampler() {
    }

    public static byte[] sample(byte[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null);
    }

    public static char[] sample(char[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null);
    }

    public static double[] sample(double[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null);
    }

    public static float[] sample(float[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null);
    }

    public static int[] sample(int[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null);
    }

    public static long[] sample(long[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null);
    }

    public static short[] sample(short[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null);
    }

    public static char[] sample(String source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial((int)source.length(), (double)p), null);
    }

    public static <T> T[] sample(T[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null);
    }

    public static int[] sample(int[] source, int k, int[] target) {
        if (2 * k < source.length) {
            if (k * k < source.length) {
                return SequenceSampler.sampleInsertion(source, k, target);
            }
            return SequenceSampler.samplePool(source, k, target);
        }
        return SequenceSampler.sampleReservoir(source, k, target);
    }

    public static long[] sample(long[] source, int k, long[] target) {
        if (2 * k < source.length) {
            if (k * k < source.length) {
                return SequenceSampler.sampleInsertion(source, k, target);
            }
            return SequenceSampler.samplePool(source, k, target);
        }
        return SequenceSampler.sampleReservoir(source, k, target);
    }

    public static short[] sample(short[] source, int k, short[] target) {
        if (2 * k < source.length) {
            if (k * k < source.length) {
                return SequenceSampler.sampleInsertion(source, k, target);
            }
            return SequenceSampler.samplePool(source, k, target);
        }
        return SequenceSampler.sampleReservoir(source, k, target);
    }

    public static byte[] sample(byte[] source, int k, byte[] target) {
        if (2 * k < source.length) {
            if (k * k < source.length) {
                return SequenceSampler.sampleInsertion(source, k, target);
            }
            return SequenceSampler.samplePool(source, k, target);
        }
        return SequenceSampler.sampleReservoir(source, k, target);
    }

    public static char[] sample(char[] source, int k, char[] target) {
        if (2 * k < source.length) {
            if (k * k < source.length) {
                return SequenceSampler.sampleInsertion(source, k, target);
            }
            return SequenceSampler.samplePool(source, k, target);
        }
        return SequenceSampler.sampleReservoir(source, k, target);
    }

    public static char[] sample(String source, int k, char[] target) {
        if (2 * k < source.length()) {
            if (k * k < source.length()) {
                return SequenceSampler.sampleInsertion(source, k, target);
            }
            return SequenceSampler.samplePool(source, k, target);
        }
        return SequenceSampler.sampleReservoir(source, k, target);
    }

    public static double[] sample(double[] source, int k, double[] target) {
        if (2 * k < source.length) {
            if (k * k < source.length) {
                return SequenceSampler.sampleInsertion(source, k, target);
            }
            return SequenceSampler.samplePool(source, k, target);
        }
        return SequenceSampler.sampleReservoir(source, k, target);
    }

    public static float[] sample(float[] source, int k, float[] target) {
        if (2 * k < source.length) {
            if (k * k < source.length) {
                return SequenceSampler.sampleInsertion(source, k, target);
            }
            return SequenceSampler.samplePool(source, k, target);
        }
        return SequenceSampler.sampleReservoir(source, k, target);
    }

    public static <T> T[] sample(T[] source, int k, T[] target) {
        if (2 * k < source.length) {
            if (k * k < source.length) {
                return SequenceSampler.sampleInsertion(source, k, target);
            }
            return SequenceSampler.samplePool(source, k, target);
        }
        return SequenceSampler.sampleReservoir(source, k, target);
    }

    public static int[] sampleReservoir(int[] source, int k, int[] target) {
        int i;
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null || target.length < k) {
            target = new int[k];
        }
        for (i = 0; i < k; ++i) {
            target[i] = source[i];
        }
        for (i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt((int)(i + 1));
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static long[] sampleReservoir(long[] source, int k, long[] target) {
        int i;
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null || target.length < k) {
            target = new long[k];
        }
        for (i = 0; i < k; ++i) {
            target[i] = source[i];
        }
        for (i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt((int)(i + 1));
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static short[] sampleReservoir(short[] source, int k, short[] target) {
        int i;
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null || target.length < k) {
            target = new short[k];
        }
        for (i = 0; i < k; ++i) {
            target[i] = source[i];
        }
        for (i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt((int)(i + 1));
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static byte[] sampleReservoir(byte[] source, int k, byte[] target) {
        int i;
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null || target.length < k) {
            target = new byte[k];
        }
        for (i = 0; i < k; ++i) {
            target[i] = source[i];
        }
        for (i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt((int)(i + 1));
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static char[] sampleReservoir(char[] source, int k, char[] target) {
        int i;
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null || target.length < k) {
            target = new char[k];
        }
        for (i = 0; i < k; ++i) {
            target[i] = source[i];
        }
        for (i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt((int)(i + 1));
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static char[] sampleReservoir(String source, int k, char[] target) {
        int i;
        if (k > source.length()) {
            throw new IllegalArgumentException("k must be no greater than length of source");
        }
        if (target == null || target.length < k) {
            target = new char[k];
        }
        for (i = 0; i < k; ++i) {
            target[i] = source.charAt(i);
        }
        for (i = k; i < source.length(); ++i) {
            int j = RandomIndexer.nextInt((int)(i + 1));
            if (j >= k) continue;
            target[j] = source.charAt(i);
        }
        return target;
    }

    public static double[] sampleReservoir(double[] source, int k, double[] target) {
        int i;
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null || target.length < k) {
            target = new double[k];
        }
        for (i = 0; i < k; ++i) {
            target[i] = source[i];
        }
        for (i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt((int)(i + 1));
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static float[] sampleReservoir(float[] source, int k, float[] target) {
        int i;
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null || target.length < k) {
            target = new float[k];
        }
        for (i = 0; i < k; ++i) {
            target[i] = source[i];
        }
        for (i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt((int)(i + 1));
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static <T> T[] sampleReservoir(T[] source, int k, T[] target) {
        int i;
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null) {
            target = (Object[])Array.newInstance(source.getClass().getComponentType(), k);
        } else if (target.length < k) {
            target = (Object[])Array.newInstance(target.getClass().getComponentType(), k);
        }
        for (i = 0; i < k; ++i) {
            target[i] = source[i];
        }
        for (i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt((int)(i + 1));
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static int[] samplePool(int[] source, int k, int[] target) {
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null || target.length < k) {
            target = new int[k];
        }
        int[] pool = (int[])source.clone();
        int remaining = pool.length;
        for (int i = 0; i < k; ++i) {
            int j = RandomIndexer.nextInt((int)remaining);
            target[i] = pool[j];
            pool[j] = pool[--remaining];
        }
        return target;
    }

    public static long[] samplePool(long[] source, int k, long[] target) {
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null || target.length < k) {
            target = new long[k];
        }
        long[] pool = (long[])source.clone();
        int remaining = pool.length;
        for (int i = 0; i < k; ++i) {
            int j = RandomIndexer.nextInt((int)remaining);
            target[i] = pool[j];
            pool[j] = pool[--remaining];
        }
        return target;
    }

    public static short[] samplePool(short[] source, int k, short[] target) {
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null || target.length < k) {
            target = new short[k];
        }
        short[] pool = (short[])source.clone();
        int remaining = pool.length;
        for (int i = 0; i < k; ++i) {
            int j = RandomIndexer.nextInt((int)remaining);
            target[i] = pool[j];
            pool[j] = pool[--remaining];
        }
        return target;
    }

    public static byte[] samplePool(byte[] source, int k, byte[] target) {
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null || target.length < k) {
            target = new byte[k];
        }
        byte[] pool = (byte[])source.clone();
        int remaining = pool.length;
        for (int i = 0; i < k; ++i) {
            int j = RandomIndexer.nextInt((int)remaining);
            target[i] = pool[j];
            pool[j] = pool[--remaining];
        }
        return target;
    }

    public static char[] samplePool(char[] source, int k, char[] target) {
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null || target.length < k) {
            target = new char[k];
        }
        char[] pool = (char[])source.clone();
        int remaining = pool.length;
        for (int i = 0; i < k; ++i) {
            int j = RandomIndexer.nextInt((int)remaining);
            target[i] = pool[j];
            pool[j] = pool[--remaining];
        }
        return target;
    }

    public static char[] samplePool(String source, int k, char[] target) {
        if (k > source.length()) {
            throw new IllegalArgumentException("k must be no greater than length of source");
        }
        return SequenceSampler.samplePool(source.toCharArray(), k, target);
    }

    public static double[] samplePool(double[] source, int k, double[] target) {
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null || target.length < k) {
            target = new double[k];
        }
        double[] pool = (double[])source.clone();
        int remaining = pool.length;
        for (int i = 0; i < k; ++i) {
            int j = RandomIndexer.nextInt((int)remaining);
            target[i] = pool[j];
            pool[j] = pool[--remaining];
        }
        return target;
    }

    public static float[] samplePool(float[] source, int k, float[] target) {
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null || target.length < k) {
            target = new float[k];
        }
        float[] pool = (float[])source.clone();
        int remaining = pool.length;
        for (int i = 0; i < k; ++i) {
            int j = RandomIndexer.nextInt((int)remaining);
            target[i] = pool[j];
            pool[j] = pool[--remaining];
        }
        return target;
    }

    public static <T> T[] samplePool(T[] source, int k, T[] target) {
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null) {
            target = (Object[])Array.newInstance(source.getClass().getComponentType(), k);
        } else if (target.length < k) {
            target = (Object[])Array.newInstance(target.getClass().getComponentType(), k);
        }
        T[] pool = Arrays.copyOf(source, source.length);
        int remaining = pool.length;
        for (int i = 0; i < k; ++i) {
            int j = RandomIndexer.nextInt((int)remaining);
            target[i] = pool[j];
            pool[j] = pool[--remaining];
        }
        return target;
    }

    public static int[] sampleInsertion(int[] source, int k, int[] target) {
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        target = RandomIndexer.sampleInsertion((int)source.length, (int)k, (int[])target);
        for (int i = 0; i < k; ++i) {
            target[i] = source[target[i]];
        }
        return target;
    }

    public static long[] sampleInsertion(long[] source, int k, long[] target) {
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null || target.length < k) {
            target = new long[k];
        }
        int[] indexes = RandomIndexer.sampleInsertion((int)source.length, (int)k, null);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }

    public static short[] sampleInsertion(short[] source, int k, short[] target) {
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null || target.length < k) {
            target = new short[k];
        }
        int[] indexes = RandomIndexer.sampleInsertion((int)source.length, (int)k, null);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }

    public static byte[] sampleInsertion(byte[] source, int k, byte[] target) {
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null || target.length < k) {
            target = new byte[k];
        }
        int[] indexes = RandomIndexer.sampleInsertion((int)source.length, (int)k, null);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }

    public static char[] sampleInsertion(char[] source, int k, char[] target) {
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null || target.length < k) {
            target = new char[k];
        }
        int[] indexes = RandomIndexer.sampleInsertion((int)source.length, (int)k, null);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }

    public static char[] sampleInsertion(String source, int k, char[] target) {
        if (k > source.length()) {
            throw new IllegalArgumentException("k must be no greater than length of source");
        }
        if (target == null || target.length < k) {
            target = new char[k];
        }
        int[] indexes = RandomIndexer.sampleInsertion((int)source.length(), (int)k, null);
        for (int i = 0; i < k; ++i) {
            target[i] = source.charAt(indexes[i]);
        }
        return target;
    }

    public static double[] sampleInsertion(double[] source, int k, double[] target) {
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null || target.length < k) {
            target = new double[k];
        }
        int[] indexes = RandomIndexer.sampleInsertion((int)source.length, (int)k, null);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }

    public static float[] sampleInsertion(float[] source, int k, float[] target) {
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null || target.length < k) {
            target = new float[k];
        }
        int[] indexes = RandomIndexer.sampleInsertion((int)source.length, (int)k, null);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }

    public static <T> T[] sampleInsertion(T[] source, int k, T[] target) {
        if (k > source.length) {
            throw new IllegalArgumentException("k must be no greater than length of source array");
        }
        if (target == null) {
            target = (Object[])Array.newInstance(source.getClass().getComponentType(), k);
        } else if (target.length < k) {
            target = (Object[])Array.newInstance(target.getClass().getComponentType(), k);
        }
        int[] indexes = RandomIndexer.sampleInsertion((int)source.length, (int)k, null);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }
}

