/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.ds;

import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.cicirello.ds.MergeablePriorityQueue;
import org.cicirello.ds.PriorityQueueNode;
import org.cicirello.util.Copyable;

public final class FibonacciHeap<E>
implements MergeablePriorityQueue<E, FibonacciHeap<E>>,
Copyable<FibonacciHeap<E>> {
    private HashMap<E, Node<E>> index;
    private final PriorityComparator compare;
    private final int extreme;
    private int size;
    private Node<E> min;
    private final Node<E>[] rootsByDegrees;
    private static final double INV_LOG_GOLDEN_RATIO = 2.0780869212350273;

    private FibonacciHeap() {
        this((int p1, int p2) -> p1 < p2);
    }

    private FibonacciHeap(PriorityComparator compare) {
        this.compare = compare;
        this.extreme = compare.comesBefore(0, 1) ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        this.index = new HashMap();
        this.rootsByDegrees = this.nodeArrayAllocate(45);
    }

    private FibonacciHeap(Collection<PriorityQueueNode.Integer<E>> initialElements) {
        this(initialElements, (p1, p2) -> p1 < p2);
    }

    private FibonacciHeap(Collection<PriorityQueueNode.Integer<E>> initialElements, PriorityComparator compare) {
        this(compare);
        for (PriorityQueueNode.Integer<E> element : initialElements) {
            if (this.index.containsKey(element.element)) {
                throw new IllegalArgumentException("initialElements contains duplicates");
            }
            this.internalOffer((PriorityQueueNode.Integer<E>)element.copy());
        }
    }

    private FibonacciHeap(FibonacciHeap<E> other) {
        this(other.compare);
        this.size = other.size;
        this.min = other.min != null ? other.min.copy(this.index) : null;
    }

    @Override
    public FibonacciHeap<E> copy() {
        return new FibonacciHeap<E>(this);
    }

    public static <E> FibonacciHeap<E> createMinHeap() {
        return new FibonacciHeap<E>();
    }

    public static <E> FibonacciHeap<E> createMinHeap(Collection<PriorityQueueNode.Integer<E>> initialElements) {
        return new FibonacciHeap<E>(initialElements);
    }

    public static <E> FibonacciHeap<E> createMaxHeap() {
        return new FibonacciHeap<E>((p1, p2) -> p1 > p2);
    }

    public static <E> FibonacciHeap<E> createMaxHeap(Collection<PriorityQueueNode.Integer<E>> initialElements) {
        return new FibonacciHeap<E>(initialElements, (p1, p2) -> p1 > p2);
    }

    @Override
    public final boolean change(E element, int priority) {
        if (!this.offer(element, priority)) {
            Node<E> node = this.index.get(element);
            if (this.compare.comesBefore(priority, node.e.value)) {
                this.internalPromote(node, priority);
                return true;
            }
            if (this.compare.comesBefore(node.e.value, priority)) {
                this.internalDemote(node, priority);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public final void clear() {
        this.size = 0;
        this.index = new HashMap();
        this.min = null;
    }

    @Override
    public final boolean contains(Object o) {
        if (o instanceof PriorityQueueNode.Integer) {
            PriorityQueueNode.Integer pair = (PriorityQueueNode.Integer)o;
            return this.index.containsKey(pair.element);
        }
        return this.index.containsKey(o);
    }

    @Override
    public final boolean demote(E element, int priority) {
        Node<E> node = this.index.get(element);
        if (node != null && this.compare.comesBefore(node.e.value, priority)) {
            this.internalDemote(node, priority);
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof FibonacciHeap) {
            FibonacciHeap casted = (FibonacciHeap)other;
            if (this.size != casted.size) {
                return false;
            }
            if (this.compare.comesBefore(0, 1) != casted.compare.comesBefore(0, 1)) {
                return false;
            }
            Iterator<PriorityQueueNode.Integer<E>> iter = this.iterator();
            Iterator<PriorityQueueNode.Integer<E>> otherIter = casted.iterator();
            while (iter.hasNext()) {
                if (iter.next().equals(otherIter.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (PriorityQueueNode.Integer<E> e : this) {
            h = 31 * h + Integer.hashCode(e.value);
            h = 31 * h + e.element.hashCode();
        }
        return h;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final Iterator<PriorityQueueNode.Integer<E>> iterator() {
        return new FibonacciHeapIterator();
    }

    @Override
    public boolean merge(FibonacciHeap<E> other) {
        if (this.compare.comesBefore(0, 1) != other.compare.comesBefore(0, 1)) {
            throw new IllegalArgumentException("this and other follow different priority-order");
        }
        if (other.size > 0) {
            other.min.insertListInto(this.min);
            if (this.compare.comesBefore(other.min.e.value, this.min.e.value)) {
                this.min = other.min;
            }
            this.size += other.size;
            this.index.putAll(other.index);
            other.clear();
            return true;
        }
        return false;
    }

    @Override
    public final boolean offer(E element, int priority) {
        if (this.index.containsKey(element)) {
            return false;
        }
        return this.internalOffer(new PriorityQueueNode.Integer<E>(element, priority));
    }

    @Override
    public final boolean offer(PriorityQueueNode.Integer<E> pair) {
        if (this.index.containsKey(pair.element)) {
            return false;
        }
        return this.internalOffer((PriorityQueueNode.Integer<E>)pair.copy());
    }

    @Override
    public final E peekElement() {
        return (E)(this.min != null ? this.min.e.element : null);
    }

    @Override
    public final PriorityQueueNode.Integer<E> peek() {
        return this.min != null ? this.min.e : null;
    }

    @Override
    public final int peekPriority() {
        return this.min != null ? this.min.e.value : this.extreme;
    }

    @Override
    public final int peekPriority(E element) {
        Node<E> node = this.index.get(element);
        return node != null ? node.e.value : this.extreme;
    }

    @Override
    public final E pollElement() {
        Object min = this.poll();
        return (E)(min != null ? ((PriorityQueueNode.Integer)min).element : null);
    }

    @Override
    public final PriorityQueueNode.Integer<E> poll() {
        if (this.size == 1) {
            PriorityQueueNode.Integer pair = this.min.e;
            this.index.remove(pair.element);
            this.min = null;
            this.size = 0;
            return pair;
        }
        if (this.size > 1) {
            Node<E> z = this.min;
            if (z.child != null) {
                z.child.clearParentReferences();
                z.child.insertListInto(this.min);
            }
            this.min = this.min.right;
            z.left.right = this.min;
            this.min.left = z.left;
            this.consolidate();
            this.index.remove(z.e.element);
            --this.size;
            return z.e;
        }
        return null;
    }

    @Override
    public final boolean promote(E element, int priority) {
        Node<E> node = this.index.get(element);
        if (node != null && this.compare.comesBefore(priority, node.e.value)) {
            this.internalPromote(node, priority);
            return true;
        }
        return false;
    }

    @Override
    public final boolean remove(Object o) {
        Node<E> node = null;
        if (o instanceof PriorityQueueNode.Integer) {
            PriorityQueueNode.Integer pair = (PriorityQueueNode.Integer)o;
            node = this.index.get(pair.element);
        } else {
            node = this.index.get(o);
        }
        if (node == null) {
            return false;
        }
        this.internalPromote(node, this.compare.comesBefore(this.min.e.value - 1, this.min.e.value) ? this.min.e.value - 1 : this.min.e.value + 1);
        this.poll();
        return true;
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        HashSet<Object> discardThese = new HashSet<Object>();
        for (Object o : c) {
            if (o instanceof PriorityQueueNode.Integer) {
                PriorityQueueNode.Integer pair = (PriorityQueueNode.Integer)o;
                discardThese.add(pair.element);
                continue;
            }
            discardThese.add(o);
        }
        ArrayList<PriorityQueueNode.Integer<E>> keepList = new ArrayList<PriorityQueueNode.Integer<E>>();
        for (PriorityQueueNode.Integer<E> e : this) {
            if (discardThese.contains(e.element)) continue;
            keepList.add(e);
        }
        if (keepList.size() < this.size) {
            this.clear();
            for (PriorityQueueNode.Integer<E> e : keepList) {
                this.internalOffer(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        HashSet<Object> keepThese = new HashSet<Object>();
        for (Object o : c) {
            if (o instanceof PriorityQueueNode.Integer) {
                PriorityQueueNode.Integer pair = (PriorityQueueNode.Integer)o;
                keepThese.add(pair.element);
                continue;
            }
            keepThese.add(o);
        }
        ArrayList<PriorityQueueNode.Integer<E>> keepList = new ArrayList<PriorityQueueNode.Integer<E>>(keepThese.size());
        for (PriorityQueueNode.Integer<E> e : this) {
            if (!keepThese.contains(e.element)) continue;
            keepList.add(e);
        }
        if (keepList.size() < this.size) {
            this.clear();
            for (PriorityQueueNode.Integer<E> e : keepList) {
                this.internalOffer(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final Object[] toArray() {
        Object[] array = new Object[this.size];
        int i = 0;
        Iterator<PriorityQueueNode.Integer<E>> iterator = this.iterator();
        while (iterator.hasNext()) {
            PriorityQueueNode.Integer<E> e;
            array[i] = e = iterator.next();
            ++i;
        }
        return array;
    }

    @Override
    public final <T> T[] toArray(T[] array) {
        T[] result = array.length >= this.size ? array : (Object[])Array.newInstance(array.getClass().getComponentType(), this.size);
        int i = 0;
        Iterator<PriorityQueueNode.Integer<E>> iterator = this.iterator();
        while (iterator.hasNext()) {
            PriorityQueueNode.Integer<E> e;
            PriorityQueueNode.Integer<E> nextElement = e = iterator.next();
            result[i] = nextElement;
            ++i;
        }
        if (result.length > this.size) {
            result[this.size] = null;
        }
        return result;
    }

    private boolean internalOffer(PriorityQueueNode.Integer<E> pair) {
        if (this.min == null) {
            this.min = new Node<E>(pair);
            this.index.put(pair.element, this.min);
            this.size = 1;
        } else {
            Node<E> added = new Node<E>(pair, this.min);
            this.index.put(pair.element, added);
            if (this.compare.comesBefore(pair.value, this.min.e.value)) {
                this.min = added;
            }
            ++this.size;
        }
        return true;
    }

    private void internalPromote(Node<E> x, int priority) {
        x.e.value = priority;
        Node y = x.parent;
        if (y != null && this.compare.comesBefore(priority, y.e.value)) {
            this.cut(x, y);
            this.cascadingCut(y);
        }
        if (this.compare.comesBefore(priority, this.min.e.value)) {
            this.min = x;
        }
    }

    private void internalDemote(Node<E> x, int priority) {
        this.internalPromote(x, this.compare.comesBefore(this.min.e.value - 1, this.min.e.value) ? this.min.e.value - 1 : this.min.e.value + 1);
        this.poll();
        x.e.value = priority;
        this.internalOffer(x.e);
    }

    private void cascadingCut(Node<E> y) {
        Node z = y.parent;
        if (z != null) {
            if (!y.mark) {
                y.mark = true;
            } else {
                this.cut(y, z);
                this.cascadingCut(z);
            }
        }
    }

    private void cut(Node<E> x, Node<E> y) {
        if (y.degree > 1) {
            y.child = x.right;
            x.left.right = x.right;
            x.right.left = x.left;
            --y.degree;
        } else {
            y.child = null;
            y.degree = 0;
        }
        x.insertInto(this.min);
        x.parent = null;
        x.mark = false;
    }

    private void consolidate() {
        int dn = (int)(Math.log(this.size) * 2.0780869212350273);
        Node<Object> w = this.min;
        w.left.right = null;
        do {
            Node<E> x = w;
            w = w.right;
            x.right = null;
            x.left = null;
            int d = x.degree;
            while (this.rootsByDegrees[d] != null) {
                Node<E> y = this.rootsByDegrees[d];
                if (this.compare.comesBefore(y.e.value, x.e.value)) {
                    Node<E> temp = x;
                    x = y;
                    y = temp;
                }
                this.fibHeapLink(y, x);
                this.rootsByDegrees[d] = null;
                ++d;
            }
            this.rootsByDegrees[d] = x;
        } while (w != null);
        this.min = null;
        for (int i = 0; i <= dn; ++i) {
            if (this.rootsByDegrees[i] == null) continue;
            if (this.min == null) {
                this.rootsByDegrees[i].singletonList();
                this.min = this.rootsByDegrees[i];
            } else {
                this.rootsByDegrees[i].insertInto(this.min);
                if (this.compare.comesBefore(this.rootsByDegrees[i].e.value, this.min.e.value)) {
                    this.min = this.rootsByDegrees[i];
                }
            }
            this.rootsByDegrees[i] = null;
        }
    }

    private void fibHeapLink(Node<E> y, Node<E> x) {
        if (x.degree > 0) {
            y.insertInto(x.child);
            y.parent = x;
            ++x.degree;
        } else {
            y.singletonList();
            x.child = y;
            y.parent = x;
            x.degree = 1;
        }
        y.mark = false;
    }

    private Node<E>[] nodeArrayAllocate(int n) {
        Node[] array = new Node[n];
        return array;
    }

    @FunctionalInterface
    private static interface PriorityComparator {
        public boolean comesBefore(int var1, int var2);
    }

    private class Node<E2> {
        private PriorityQueueNode.Integer<E2> e;
        private Node<E2> parent;
        private Node<E2> child;
        private Node<E2> left;
        private Node<E2> right;
        private int degree;
        private boolean mark;

        public Node(PriorityQueueNode.Integer<E2> e) {
            this.e = e;
            this.singletonList();
        }

        public Node(PriorityQueueNode.Integer<E2> e, Node<E2> list) {
            this.e = e;
            this.insertInto(list);
        }

        private Node(Node<E2> other) {
            this.e = other.e.copy();
            this.degree = other.degree;
            this.mark = other.mark;
        }

        private Node(Node<E2> other, Node<E2> toTheLeft) {
            this(other);
            this.left = toTheLeft;
        }

        private Node<E2> copy(HashMap<E2, Node<E2>> indexCopy) {
            return this.copyList(this, null, indexCopy);
        }

        private Node<E2> copyList(Node<E2> x, Node<E2> p, HashMap<E2, Node<E2>> indexCopy) {
            Node<E2> y = new Node<E2>(x);
            indexCopy.put(y.e.element, y);
            y.parent = p;
            if (x.child != null) {
                y.child = this.copyList(x.child, y, indexCopy);
            }
            Node<E2> rightOf = y;
            Node<E2> next = x.right;
            while (next != x) {
                rightOf.right = new Node<E2>(next, rightOf);
                indexCopy.put(rightOf.right.e.element, rightOf.right);
                rightOf.right.parent = p;
                if (next.child != null) {
                    rightOf.right.child = this.copyList(next.child, rightOf.right, indexCopy);
                }
                next = next.right;
                rightOf = rightOf.right;
            }
            rightOf.right = y;
            y.left = rightOf;
            return y;
        }

        private void singletonList() {
            this.left = this.right = this;
        }

        private void insertInto(Node<E2> list) {
            this.right = list.right;
            this.left = list;
            list.right = list.right.left = this;
        }

        private void insertListInto(Node<E2> list) {
            list.right.left = this.left;
            this.left.right = list.right;
            list.right = this;
            this.left = list;
        }

        private void clearParentReferences() {
            Node<E2> next = this;
            while (next.parent != null) {
                next.parent = null;
                next = next.right;
            }
        }
    }

    private class FibonacciHeapIterator
    implements Iterator<PriorityQueueNode.Integer<E>> {
        private final Deque<Node<E>> stack;

        public FibonacciHeapIterator() {
            this.stack = new ArrayDeque(FibonacciHeap.this.size);
            if (FibonacciHeap.this.size > 0) {
                this.stack.push(FibonacciHeap.this.min);
                Node next = FibonacciHeap.this.min.right;
                while (next != FibonacciHeap.this.min) {
                    this.stack.push(next);
                    next = next.right;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        @Override
        public PriorityQueueNode.Integer<E> next() {
            Node current = this.stack.pop();
            if (current.degree > 0) {
                this.stack.push(current.child);
                Node next = current.child.right;
                for (int i = 1; i < current.degree; ++i) {
                    this.stack.push(next);
                    next = next.right;
                }
            }
            return current.e;
        }
    }
}

