/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.sequences.distance;

import java.util.List;
import org.cicirello.sequences.distance.SequenceDistanceMeasurer;

public class EditDistance
implements SequenceDistanceMeasurer {
    private final int insert_i;
    private final int delete_i;
    private final int change_i;
    private final double insert_d;
    private final double delete_d;
    private final double change_d;

    public EditDistance(double insertCost, double deleteCost, double changeCost) {
        if (insertCost < 0.0 || deleteCost < 0.0 || changeCost < 0.0) {
            throw new IllegalArgumentException("Costs must be non-negative.");
        }
        this.insert_d = insertCost;
        this.delete_d = deleteCost;
        this.change_d = changeCost;
        if (this.isIntAsDouble(insertCost) && this.isIntAsDouble(deleteCost) && this.isIntAsDouble(changeCost)) {
            this.insert_i = (int)insertCost;
            this.delete_i = (int)deleteCost;
            this.change_i = (int)changeCost;
        } else {
            this.change_i = -1;
            this.delete_i = -1;
            this.insert_i = -1;
        }
    }

    public EditDistance(int insertCost, int deleteCost, int changeCost) {
        if (insertCost < 0 || deleteCost < 0 || changeCost < 0) {
            throw new IllegalArgumentException("Costs must be non-negative.");
        }
        this.insert_i = insertCost;
        this.insert_d = this.insert_i;
        this.delete_i = deleteCost;
        this.delete_d = this.delete_i;
        this.change_i = changeCost;
        this.change_d = this.change_i;
    }

    @Override
    public int distance(int[] s1, int[] s2) {
        int i;
        if (this.insert_i < 0) {
            throw new UnsupportedOperationException("EditDistance.distance not supported for floating-point costs.");
        }
        int[][] D = new int[s1.length + 1][s2.length + 1];
        for (i = 1; i <= s1.length; ++i) {
            D[i][0] = D[i - 1][0] + this.delete_i;
        }
        for (int j = 1; j <= s2.length; ++j) {
            D[0][j] = D[0][j - 1] + this.insert_i;
        }
        for (i = 1; i <= s1.length; ++i) {
            for (int j = 1; j <= s2.length; ++j) {
                int m1 = D[i - 1][j - 1] + (s1[i - 1] != s2[j - 1] ? this.change_i : 0);
                int m2 = D[i - 1][j] + this.delete_i;
                int m3 = D[i][j - 1] + this.insert_i;
                int min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[s1.length][s2.length];
    }

    @Override
    public int distance(long[] s1, long[] s2) {
        int i;
        if (this.insert_i < 0) {
            throw new UnsupportedOperationException("EditDistance.distance not supported for floating-point costs.");
        }
        int[][] D = new int[s1.length + 1][s2.length + 1];
        for (i = 1; i <= s1.length; ++i) {
            D[i][0] = D[i - 1][0] + this.delete_i;
        }
        for (int j = 1; j <= s2.length; ++j) {
            D[0][j] = D[0][j - 1] + this.insert_i;
        }
        for (i = 1; i <= s1.length; ++i) {
            for (int j = 1; j <= s2.length; ++j) {
                int m1 = D[i - 1][j - 1] + (s1[i - 1] != s2[j - 1] ? this.change_i : 0);
                int m2 = D[i - 1][j] + this.delete_i;
                int m3 = D[i][j - 1] + this.insert_i;
                int min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[s1.length][s2.length];
    }

    @Override
    public int distance(short[] s1, short[] s2) {
        int i;
        if (this.insert_i < 0) {
            throw new UnsupportedOperationException("EditDistance.distance not supported for floating-point costs.");
        }
        int[][] D = new int[s1.length + 1][s2.length + 1];
        for (i = 1; i <= s1.length; ++i) {
            D[i][0] = D[i - 1][0] + this.delete_i;
        }
        for (int j = 1; j <= s2.length; ++j) {
            D[0][j] = D[0][j - 1] + this.insert_i;
        }
        for (i = 1; i <= s1.length; ++i) {
            for (int j = 1; j <= s2.length; ++j) {
                int m1 = D[i - 1][j - 1] + (s1[i - 1] != s2[j - 1] ? this.change_i : 0);
                int m2 = D[i - 1][j] + this.delete_i;
                int m3 = D[i][j - 1] + this.insert_i;
                int min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[s1.length][s2.length];
    }

    @Override
    public int distance(byte[] s1, byte[] s2) {
        int i;
        if (this.insert_i < 0) {
            throw new UnsupportedOperationException("EditDistance.distance not supported for floating-point costs.");
        }
        int[][] D = new int[s1.length + 1][s2.length + 1];
        for (i = 1; i <= s1.length; ++i) {
            D[i][0] = D[i - 1][0] + this.delete_i;
        }
        for (int j = 1; j <= s2.length; ++j) {
            D[0][j] = D[0][j - 1] + this.insert_i;
        }
        for (i = 1; i <= s1.length; ++i) {
            for (int j = 1; j <= s2.length; ++j) {
                int m1 = D[i - 1][j - 1] + (s1[i - 1] != s2[j - 1] ? this.change_i : 0);
                int m2 = D[i - 1][j] + this.delete_i;
                int m3 = D[i][j - 1] + this.insert_i;
                int min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[s1.length][s2.length];
    }

    @Override
    public int distance(char[] s1, char[] s2) {
        int i;
        if (this.insert_i < 0) {
            throw new UnsupportedOperationException("EditDistance.distance not supported for floating-point costs.");
        }
        int[][] D = new int[s1.length + 1][s2.length + 1];
        for (i = 1; i <= s1.length; ++i) {
            D[i][0] = D[i - 1][0] + this.delete_i;
        }
        for (int j = 1; j <= s2.length; ++j) {
            D[0][j] = D[0][j - 1] + this.insert_i;
        }
        for (i = 1; i <= s1.length; ++i) {
            for (int j = 1; j <= s2.length; ++j) {
                int m1 = D[i - 1][j - 1] + (s1[i - 1] != s2[j - 1] ? this.change_i : 0);
                int m2 = D[i - 1][j] + this.delete_i;
                int m3 = D[i][j - 1] + this.insert_i;
                int min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[s1.length][s2.length];
    }

    @Override
    public int distance(boolean[] s1, boolean[] s2) {
        int i;
        if (this.insert_i < 0) {
            throw new UnsupportedOperationException("EditDistance.distance not supported for floating-point costs.");
        }
        int[][] D = new int[s1.length + 1][s2.length + 1];
        for (i = 1; i <= s1.length; ++i) {
            D[i][0] = D[i - 1][0] + this.delete_i;
        }
        for (int j = 1; j <= s2.length; ++j) {
            D[0][j] = D[0][j - 1] + this.insert_i;
        }
        for (i = 1; i <= s1.length; ++i) {
            for (int j = 1; j <= s2.length; ++j) {
                int m1 = D[i - 1][j - 1] + (s1[i - 1] != s2[j - 1] ? this.change_i : 0);
                int m2 = D[i - 1][j] + this.delete_i;
                int m3 = D[i][j - 1] + this.insert_i;
                int min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[s1.length][s2.length];
    }

    @Override
    public int distance(double[] s1, double[] s2) {
        int i;
        if (this.insert_i < 0) {
            throw new UnsupportedOperationException("EditDistance.distance not supported for floating-point costs.");
        }
        int[][] D = new int[s1.length + 1][s2.length + 1];
        for (i = 1; i <= s1.length; ++i) {
            D[i][0] = D[i - 1][0] + this.delete_i;
        }
        for (int j = 1; j <= s2.length; ++j) {
            D[0][j] = D[0][j - 1] + this.insert_i;
        }
        for (i = 1; i <= s1.length; ++i) {
            for (int j = 1; j <= s2.length; ++j) {
                int m1 = D[i - 1][j - 1] + (s1[i - 1] != s2[j - 1] ? this.change_i : 0);
                int m2 = D[i - 1][j] + this.delete_i;
                int m3 = D[i][j - 1] + this.insert_i;
                int min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[s1.length][s2.length];
    }

    @Override
    public int distance(float[] s1, float[] s2) {
        int i;
        if (this.insert_i < 0) {
            throw new UnsupportedOperationException("EditDistance.distance not supported for floating-point costs.");
        }
        int[][] D = new int[s1.length + 1][s2.length + 1];
        for (i = 1; i <= s1.length; ++i) {
            D[i][0] = D[i - 1][0] + this.delete_i;
        }
        for (int j = 1; j <= s2.length; ++j) {
            D[0][j] = D[0][j - 1] + this.insert_i;
        }
        for (i = 1; i <= s1.length; ++i) {
            for (int j = 1; j <= s2.length; ++j) {
                int m1 = D[i - 1][j - 1] + (s1[i - 1] != s2[j - 1] ? this.change_i : 0);
                int m2 = D[i - 1][j] + this.delete_i;
                int m3 = D[i][j - 1] + this.insert_i;
                int min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[s1.length][s2.length];
    }

    @Override
    public int distance(String s1, String s2) {
        int i;
        if (this.insert_i < 0) {
            throw new UnsupportedOperationException("EditDistance.distance not supported for floating-point costs.");
        }
        int[][] D = new int[s1.length() + 1][s2.length() + 1];
        for (i = 1; i <= s1.length(); ++i) {
            D[i][0] = D[i - 1][0] + this.delete_i;
        }
        for (int j = 1; j <= s2.length(); ++j) {
            D[0][j] = D[0][j - 1] + this.insert_i;
        }
        for (i = 1; i <= s1.length(); ++i) {
            for (int j = 1; j <= s2.length(); ++j) {
                int m1 = D[i - 1][j - 1] + (s1.charAt(i - 1) != s2.charAt(j - 1) ? this.change_i : 0);
                int m2 = D[i - 1][j] + this.delete_i;
                int m3 = D[i][j - 1] + this.insert_i;
                int min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[s1.length()][s2.length()];
    }

    @Override
    public int distance(Object[] s1, Object[] s2) {
        int i;
        if (this.insert_i < 0) {
            throw new UnsupportedOperationException("EditDistance.distance not supported for floating-point costs.");
        }
        int[][] D = new int[s1.length + 1][s2.length + 1];
        for (i = 1; i <= s1.length; ++i) {
            D[i][0] = D[i - 1][0] + this.delete_i;
        }
        for (int j = 1; j <= s2.length; ++j) {
            D[0][j] = D[0][j - 1] + this.insert_i;
        }
        for (i = 1; i <= s1.length; ++i) {
            for (int j = 1; j <= s2.length; ++j) {
                int m1 = D[i - 1][j - 1] + (!s1[i - 1].equals(s2[j - 1]) ? this.change_i : 0);
                int m2 = D[i - 1][j] + this.delete_i;
                int m3 = D[i][j - 1] + this.insert_i;
                int min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[s1.length][s2.length];
    }

    @Override
    public final <T> int distance(List<T> s1, List<T> s2) {
        return this.distance(s1.toArray(), s2.toArray());
    }

    @Override
    public double distancef(int[] s1, int[] s2) {
        int i;
        double[][] D = new double[s1.length + 1][s2.length + 1];
        for (i = 1; i <= s1.length; ++i) {
            D[i][0] = D[i - 1][0] + this.delete_d;
        }
        for (int j = 1; j <= s2.length; ++j) {
            D[0][j] = D[0][j - 1] + this.insert_d;
        }
        for (i = 1; i <= s1.length; ++i) {
            for (int j = 1; j <= s2.length; ++j) {
                double m1 = D[i - 1][j - 1] + (s1[i - 1] != s2[j - 1] ? this.change_d : 0.0);
                double m2 = D[i - 1][j] + this.delete_d;
                double m3 = D[i][j - 1] + this.insert_d;
                double min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[s1.length][s2.length];
    }

    @Override
    public double distancef(long[] s1, long[] s2) {
        int i;
        double[][] D = new double[s1.length + 1][s2.length + 1];
        for (i = 1; i <= s1.length; ++i) {
            D[i][0] = D[i - 1][0] + this.delete_d;
        }
        for (int j = 1; j <= s2.length; ++j) {
            D[0][j] = D[0][j - 1] + this.insert_d;
        }
        for (i = 1; i <= s1.length; ++i) {
            for (int j = 1; j <= s2.length; ++j) {
                double m1 = D[i - 1][j - 1] + (s1[i - 1] != s2[j - 1] ? this.change_d : 0.0);
                double m2 = D[i - 1][j] + this.delete_d;
                double m3 = D[i][j - 1] + this.insert_d;
                double min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[s1.length][s2.length];
    }

    @Override
    public double distancef(short[] s1, short[] s2) {
        int i;
        double[][] D = new double[s1.length + 1][s2.length + 1];
        for (i = 1; i <= s1.length; ++i) {
            D[i][0] = D[i - 1][0] + this.delete_d;
        }
        for (int j = 1; j <= s2.length; ++j) {
            D[0][j] = D[0][j - 1] + this.insert_d;
        }
        for (i = 1; i <= s1.length; ++i) {
            for (int j = 1; j <= s2.length; ++j) {
                double m1 = D[i - 1][j - 1] + (s1[i - 1] != s2[j - 1] ? this.change_d : 0.0);
                double m2 = D[i - 1][j] + this.delete_d;
                double m3 = D[i][j - 1] + this.insert_d;
                double min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[s1.length][s2.length];
    }

    @Override
    public double distancef(byte[] s1, byte[] s2) {
        int i;
        double[][] D = new double[s1.length + 1][s2.length + 1];
        for (i = 1; i <= s1.length; ++i) {
            D[i][0] = D[i - 1][0] + this.delete_d;
        }
        for (int j = 1; j <= s2.length; ++j) {
            D[0][j] = D[0][j - 1] + this.insert_d;
        }
        for (i = 1; i <= s1.length; ++i) {
            for (int j = 1; j <= s2.length; ++j) {
                double m1 = D[i - 1][j - 1] + (s1[i - 1] != s2[j - 1] ? this.change_d : 0.0);
                double m2 = D[i - 1][j] + this.delete_d;
                double m3 = D[i][j - 1] + this.insert_d;
                double min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[s1.length][s2.length];
    }

    @Override
    public double distancef(char[] s1, char[] s2) {
        int i;
        double[][] D = new double[s1.length + 1][s2.length + 1];
        for (i = 1; i <= s1.length; ++i) {
            D[i][0] = D[i - 1][0] + this.delete_d;
        }
        for (int j = 1; j <= s2.length; ++j) {
            D[0][j] = D[0][j - 1] + this.insert_d;
        }
        for (i = 1; i <= s1.length; ++i) {
            for (int j = 1; j <= s2.length; ++j) {
                double m1 = D[i - 1][j - 1] + (s1[i - 1] != s2[j - 1] ? this.change_d : 0.0);
                double m2 = D[i - 1][j] + this.delete_d;
                double m3 = D[i][j - 1] + this.insert_d;
                double min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[s1.length][s2.length];
    }

    @Override
    public double distancef(boolean[] s1, boolean[] s2) {
        int i;
        double[][] D = new double[s1.length + 1][s2.length + 1];
        for (i = 1; i <= s1.length; ++i) {
            D[i][0] = D[i - 1][0] + this.delete_d;
        }
        for (int j = 1; j <= s2.length; ++j) {
            D[0][j] = D[0][j - 1] + this.insert_d;
        }
        for (i = 1; i <= s1.length; ++i) {
            for (int j = 1; j <= s2.length; ++j) {
                double m1 = D[i - 1][j - 1] + (s1[i - 1] != s2[j - 1] ? this.change_d : 0.0);
                double m2 = D[i - 1][j] + this.delete_d;
                double m3 = D[i][j - 1] + this.insert_d;
                double min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[s1.length][s2.length];
    }

    @Override
    public double distancef(double[] s1, double[] s2) {
        int i;
        double[][] D = new double[s1.length + 1][s2.length + 1];
        for (i = 1; i <= s1.length; ++i) {
            D[i][0] = D[i - 1][0] + this.delete_d;
        }
        for (int j = 1; j <= s2.length; ++j) {
            D[0][j] = D[0][j - 1] + this.insert_d;
        }
        for (i = 1; i <= s1.length; ++i) {
            for (int j = 1; j <= s2.length; ++j) {
                double m1 = D[i - 1][j - 1] + (s1[i - 1] != s2[j - 1] ? this.change_d : 0.0);
                double m2 = D[i - 1][j] + this.delete_d;
                double m3 = D[i][j - 1] + this.insert_d;
                double min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[s1.length][s2.length];
    }

    @Override
    public double distancef(float[] s1, float[] s2) {
        int i;
        double[][] D = new double[s1.length + 1][s2.length + 1];
        for (i = 1; i <= s1.length; ++i) {
            D[i][0] = D[i - 1][0] + this.delete_d;
        }
        for (int j = 1; j <= s2.length; ++j) {
            D[0][j] = D[0][j - 1] + this.insert_d;
        }
        for (i = 1; i <= s1.length; ++i) {
            for (int j = 1; j <= s2.length; ++j) {
                double m1 = D[i - 1][j - 1] + (s1[i - 1] != s2[j - 1] ? this.change_d : 0.0);
                double m2 = D[i - 1][j] + this.delete_d;
                double m3 = D[i][j - 1] + this.insert_d;
                double min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[s1.length][s2.length];
    }

    @Override
    public double distancef(String s1, String s2) {
        int i;
        double[][] D = new double[s1.length() + 1][s2.length() + 1];
        for (i = 1; i <= s1.length(); ++i) {
            D[i][0] = D[i - 1][0] + this.delete_d;
        }
        for (int j = 1; j <= s2.length(); ++j) {
            D[0][j] = D[0][j - 1] + this.insert_d;
        }
        for (i = 1; i <= s1.length(); ++i) {
            for (int j = 1; j <= s2.length(); ++j) {
                double m1 = D[i - 1][j - 1] + (s1.charAt(i - 1) != s2.charAt(j - 1) ? this.change_d : 0.0);
                double m2 = D[i - 1][j] + this.delete_d;
                double m3 = D[i][j - 1] + this.insert_d;
                double min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[s1.length()][s2.length()];
    }

    @Override
    public double distancef(Object[] s1, Object[] s2) {
        int i;
        double[][] D = new double[s1.length + 1][s2.length + 1];
        for (i = 1; i <= s1.length; ++i) {
            D[i][0] = D[i - 1][0] + this.delete_d;
        }
        for (int j = 1; j <= s2.length; ++j) {
            D[0][j] = D[0][j - 1] + this.insert_d;
        }
        for (i = 1; i <= s1.length; ++i) {
            for (int j = 1; j <= s2.length; ++j) {
                double m1 = D[i - 1][j - 1] + (!s1[i - 1].equals(s2[j - 1]) ? this.change_d : 0.0);
                double m2 = D[i - 1][j] + this.delete_d;
                double m3 = D[i][j - 1] + this.insert_d;
                double min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[s1.length][s2.length];
    }

    @Override
    public final <T> double distancef(List<T> s1, List<T> s2) {
        return this.distancef(s1.toArray(), s2.toArray());
    }

    private boolean isIntAsDouble(double d) {
        return (double)((int)d) == d;
    }
}

