/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.util;

import org.cicirello.util.Copyable;

public final class IntegerList
implements Copyable<IntegerList> {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    private int[] list;
    private int size;

    public IntegerList() {
        this.list = new int[16];
    }

    public IntegerList(int initialCapacity) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("The initial capacity must be positive.");
        }
        this.list = new int[initialCapacity];
    }

    public IntegerList(int[] initialContents) {
        if (initialContents.length < 1) {
            throw new IllegalArgumentException("Initialization from array requires at least one element in array.");
        }
        this.list = (int[])initialContents.clone();
        this.size = this.list.length;
    }

    private IntegerList(IntegerList other) {
        this.list = (int[])other.list.clone();
        this.size = other.size;
    }

    public void add(int element) {
        if (this.size >= this.list.length) {
            this.reallocate();
        }
        this.list[this.size] = element;
        ++this.size;
    }

    public void add(int index, int element) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index is out of bounds");
        }
        if (this.size >= this.list.length) {
            this.reallocate();
        }
        if (index != this.size) {
            System.arraycopy(this.list, index, this.list, index + 1, this.size - index);
        }
        this.list[index] = element;
        ++this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean contains(int element) {
        for (int i = 0; i < this.size; ++i) {
            if (this.list[i] != element) continue;
            return true;
        }
        return false;
    }

    @Override
    public IntegerList copy() {
        return new IntegerList(this);
    }

    public void ensureCapacity(int minCapacity) {
        if (this.list.length < minCapacity) {
            this.reallocate(minCapacity);
        }
    }

    public int get(int index) {
        if (index < this.size) {
            return this.list[index];
        }
        throw new IndexOutOfBoundsException("index is out of bounds");
    }

    public int indexOf(int element) {
        for (int i = 0; i < this.size; ++i) {
            if (this.list[i] != element) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int lastIndexOf(int element) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.list[i] != element) continue;
            return i;
        }
        return -1;
    }

    public int remove(int index) {
        if (index < this.size) {
            int element = this.list[index];
            System.arraycopy(this.list, index + 1, this.list, index, this.size - index - 1);
            --this.size;
            return element;
        }
        throw new IndexOutOfBoundsException("index is out of bounds");
    }

    public void set(int index, int element) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index is out of bounds");
        }
        this.list[index] = element;
    }

    public int size() {
        return this.size;
    }

    public int[] toArray() {
        int[] result = new int[this.size];
        System.arraycopy(this.list, 0, result, 0, this.size);
        return result;
    }

    public void trimToSize() {
        this.reallocate(this.size > 0 ? this.size : 1);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof IntegerList) {
            IntegerList o = (IntegerList)other;
            if (this.size != o.size) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.list[i] == o.list[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.size > 0) {
            int h = this.list[0];
            for (int i = 1; i < this.size; ++i) {
                h = 31 * h + this.list[i];
            }
            return h;
        }
        return 0;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        if (this.size > 0) {
            s.append(this.list[0]);
            for (int i = 1; i < this.size; ++i) {
                s.append(", ");
                s.append(this.list[i]);
            }
        }
        s.append("]");
        return s.toString();
    }

    private void reallocate() {
        this.reallocate(this.list.length << 1);
    }

    private void reallocate(int capacity) {
        int[] temp = new int[capacity];
        System.arraycopy(this.list, 0, temp, 0, this.size);
        this.list = temp;
    }
}

