/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.ds;

import java.lang.reflect.Array;
import java.util.Iterator;
import org.cicirello.ds.FibonacciHeapNode;
import org.cicirello.ds.MergeablePriorityQueue;
import org.cicirello.ds.Prioritizer;
import org.cicirello.ds.PriorityQueueNode;
import org.cicirello.ds.SimpleFibonacciHeap;

abstract class AbstractFibonacciHeap<E>
implements MergeablePriorityQueue<E, SimpleFibonacciHeap<E>> {
    private final Prioritizer compare;
    private final int extreme;
    private int size;
    private FibonacciHeapNode<E> min;
    private final FibonacciHeapNode.Consolidator<E> consolidator;

    AbstractFibonacciHeap(Prioritizer compare) {
        this.compare = compare;
        this.extreme = compare.comesBefore(0, 1) ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        this.consolidator = new FibonacciHeapNode.Consolidator(compare);
    }

    AbstractFibonacciHeap(AbstractFibonacciHeap<E> other) {
        this(other.compare);
        this.size = other.size;
        this.min = other.min != null ? other.min.copy() : null;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.min = null;
    }

    @Override
    public final boolean demote(E element, int priority) {
        FibonacciHeapNode<E> node = this.find(element);
        if (node != null && this.compare.comesBefore(node.e.value, priority)) {
            this.internalDemote(node, priority);
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof AbstractFibonacciHeap) {
            AbstractFibonacciHeap casted = (AbstractFibonacciHeap)other;
            if (this.size != casted.size) {
                return false;
            }
            if (this.compare.comesBefore(0, 1) != casted.compare.comesBefore(0, 1)) {
                return false;
            }
            Iterator<PriorityQueueNode.Integer<E>> iter = this.iterator();
            Iterator<PriorityQueueNode.Integer<E>> otherIter = casted.iterator();
            while (iter.hasNext()) {
                if (iter.next().equals(otherIter.next())) continue;
                return false;
            }
            return this.getClass() == other.getClass();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (PriorityQueueNode.Integer<E> e : this) {
            h = 31 * h + Integer.hashCode(e.value);
            h = 31 * h + e.element.hashCode();
        }
        return h;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final Iterator<PriorityQueueNode.Integer<E>> iterator() {
        return new FibonacciHeapNode.FibonacciHeapIterator<E>(this.min);
    }

    @Override
    public final E peekElement() {
        return (E)(this.min != null ? this.min.e.element : null);
    }

    @Override
    public final PriorityQueueNode.Integer<E> peek() {
        return this.min != null ? this.min.e : null;
    }

    @Override
    public final int peekPriority() {
        return this.min != null ? this.min.e.value : this.extreme;
    }

    @Override
    public final int peekPriority(E element) {
        FibonacciHeapNode<E> node = this.find(element);
        return node != null ? node.e.value : this.extreme;
    }

    @Override
    public final E pollElement() {
        Object min = this.poll();
        return (E)(min != null ? ((PriorityQueueNode.Integer)min).element : null);
    }

    @Override
    public PriorityQueueNode.Integer<E> poll() {
        if (this.size == 1) {
            PriorityQueueNode.Integer pair = this.min.e;
            this.min = null;
            this.size = 0;
            return pair;
        }
        if (this.size > 1) {
            FibonacciHeapNode<E> z = this.min;
            this.min = this.min.removeSelf();
            this.min = this.consolidator.consolidate(this.min, this.size);
            --this.size;
            return z.e;
        }
        return null;
    }

    @Override
    public final boolean promote(E element, int priority) {
        FibonacciHeapNode<E> node = this.find(element);
        if (node != null && this.compare.comesBefore(priority, node.e.value)) {
            this.internalPromote(node, priority);
            return true;
        }
        return false;
    }

    @Override
    public final boolean remove(Object o) {
        FibonacciHeapNode<E> node = null;
        if (o instanceof PriorityQueueNode.Integer) {
            PriorityQueueNode.Integer pair = (PriorityQueueNode.Integer)o;
            node = this.find(pair.element);
        } else {
            node = this.find(o);
        }
        if (node == null) {
            return false;
        }
        this.internalPromote(node, this.compare.comesBefore(this.min.e.value - 1, this.min.e.value) ? this.min.e.value - 1 : this.min.e.value + 1);
        this.poll();
        return true;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final Object[] toArray() {
        Object[] array = new Object[this.size];
        int i = 0;
        Iterator<PriorityQueueNode.Integer<E>> iterator = this.iterator();
        while (iterator.hasNext()) {
            PriorityQueueNode.Integer<E> e;
            array[i] = e = iterator.next();
            ++i;
        }
        return array;
    }

    @Override
    public final <T> T[] toArray(T[] array) {
        T[] result = array.length >= this.size ? array : (Object[])Array.newInstance(array.getClass().getComponentType(), this.size);
        int i = 0;
        Iterator<PriorityQueueNode.Integer<E>> iterator = this.iterator();
        while (iterator.hasNext()) {
            PriorityQueueNode.Integer<E> e;
            PriorityQueueNode.Integer<E> nextElement = e = iterator.next();
            result[i] = nextElement;
            ++i;
        }
        if (result.length > this.size) {
            result[this.size] = null;
        }
        return result;
    }

    FibonacciHeapNode<E> find(Object element) {
        return this.min == null ? null : this.min.find(element);
    }

    FibonacciHeapNode<E> internalOffer(PriorityQueueNode.Integer<E> pair) {
        if (this.min == null) {
            this.min = new FibonacciHeapNode<E>(pair);
            this.size = 1;
            return this.min;
        }
        FibonacciHeapNode<E> added = new FibonacciHeapNode<E>(pair, this.min);
        if (this.compare.comesBefore(pair.value, this.min.e.value)) {
            this.min = added;
        }
        ++this.size;
        return added;
    }

    final void internalPromote(FibonacciHeapNode<E> x, int priority) {
        x.e.value = priority;
        FibonacciHeapNode<E> y = x.parent();
        if (y != null && this.compare.comesBefore(priority, y.e.value)) {
            x.cut(y, this.min);
            y.cascadingCut(this.min);
        }
        if (this.compare.comesBefore(priority, this.min.e.value)) {
            this.min = x;
        }
    }

    final boolean internalMerge(AbstractFibonacciHeap<E> other) {
        if (this.compare.comesBefore(0, 1) != other.compare.comesBefore(0, 1)) {
            throw new IllegalArgumentException("this and other follow different priority-order");
        }
        if (other.size > 0) {
            other.min.insertListInto(this.min);
            if (this.compare.comesBefore(other.min.e.value, this.min.e.value)) {
                this.min = other.min;
            }
            this.size += other.size;
            other.clear();
            return true;
        }
        return false;
    }

    final void internalDemote(FibonacciHeapNode<E> x, int priority) {
        this.internalPromote(x, this.compare.comesBefore(this.min.e.value - 1, this.min.e.value) ? this.min.e.value - 1 : this.min.e.value + 1);
        this.poll();
        x.e.value = priority;
        this.internalOffer(x.e);
    }

    final boolean internalChange(FibonacciHeapNode<E> node, int priority) {
        if (this.compare.comesBefore(priority, node.e.value)) {
            this.internalPromote(node, priority);
            return true;
        }
        if (this.compare.comesBefore(node.e.value, priority)) {
            this.internalDemote(node, priority);
            return true;
        }
        return false;
    }

    final FibonacciHeapNode.NodeIterator<E> nodeIterator() {
        return new FibonacciHeapNode.NodeIterator<E>(this.min);
    }
}

