/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.ds;

import java.util.Collection;
import java.util.HashMap;
import org.cicirello.ds.FibonacciHeapNode;
import org.cicirello.ds.MaxOrder;
import org.cicirello.ds.MinOrder;
import org.cicirello.ds.Prioritizer;
import org.cicirello.ds.PriorityQueueNode;
import org.cicirello.ds.SimpleFibonacciHeap;

public final class FibonacciHeap<E>
extends SimpleFibonacciHeap<E> {
    private HashMap<E, FibonacciHeapNode<E>> index = new HashMap();

    private FibonacciHeap() {
        this(new MinOrder());
    }

    private FibonacciHeap(Prioritizer compare) {
        super(compare);
    }

    private FibonacciHeap(Collection<PriorityQueueNode.Integer<E>> initialElements) {
        this(initialElements, new MinOrder());
    }

    private FibonacciHeap(Collection<PriorityQueueNode.Integer<E>> initialElements, Prioritizer compare) {
        this(compare);
        for (PriorityQueueNode.Integer<E> element : initialElements) {
            if (this.offer(element)) continue;
            throw new IllegalArgumentException("initialElements contains duplicates");
        }
    }

    private FibonacciHeap(FibonacciHeap<E> other) {
        super(other);
        FibonacciHeapNode.NodeIterator iter = this.nodeIterator();
        while (iter.hasNext()) {
            Object node = iter.next();
            this.index.put((E)((FibonacciHeapNode)node).e.element, (FibonacciHeapNode<E>)node);
        }
    }

    @Override
    public FibonacciHeap<E> copy() {
        return new FibonacciHeap<E>(this);
    }

    public static <E> FibonacciHeap<E> createMinHeap() {
        return new FibonacciHeap<E>();
    }

    public static <E> FibonacciHeap<E> createMinHeap(Collection<PriorityQueueNode.Integer<E>> initialElements) {
        return new FibonacciHeap<E>(initialElements);
    }

    public static <E> FibonacciHeap<E> createMaxHeap() {
        return new FibonacciHeap<E>(new MaxOrder());
    }

    public static <E> FibonacciHeap<E> createMaxHeap(Collection<PriorityQueueNode.Integer<E>> initialElements) {
        return new FibonacciHeap<E>(initialElements, new MaxOrder());
    }

    @Override
    public boolean add(E element, int priority) {
        if (this.index.containsKey(element)) {
            throw new IllegalArgumentException("already contains an (element, priority) pair with this element");
        }
        return this.offer(element, priority);
    }

    @Override
    public boolean add(PriorityQueueNode.Integer<E> pair) {
        if (this.index.containsKey(pair.element)) {
            throw new IllegalArgumentException("already contains an (element, priority) pair with this element");
        }
        return this.offer(pair);
    }

    @Override
    public final void clear() {
        super.clear();
        this.index = new HashMap();
    }

    @Override
    public final boolean contains(Object o) {
        if (o instanceof PriorityQueueNode.Integer) {
            PriorityQueueNode.Integer pair = (PriorityQueueNode.Integer)o;
            return this.index.containsKey(pair.element);
        }
        return this.index.containsKey(o);
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (o instanceof PriorityQueueNode.Integer) {
                PriorityQueueNode.Integer pair = (PriorityQueueNode.Integer)o;
                if (this.index.containsKey(pair.element)) continue;
                return false;
            }
            if (this.index.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean merge(SimpleFibonacciHeap<E> other) {
        if (other instanceof FibonacciHeap) {
            FibonacciHeap fib = (FibonacciHeap)other;
            this.index.putAll(fib.index);
        } else {
            FibonacciHeapNode.NodeIterator iter = other.nodeIterator();
            while (iter.hasNext()) {
                Object node = iter.next();
                this.index.put((E)((FibonacciHeapNode)node).e.element, (FibonacciHeapNode<E>)node);
            }
        }
        return super.merge(other);
    }

    @Override
    public final boolean offer(E element, int priority) {
        if (this.index.containsKey(element)) {
            return false;
        }
        return super.offer(element, priority);
    }

    @Override
    public final boolean offer(PriorityQueueNode.Integer<E> pair) {
        if (this.index.containsKey(pair.element)) {
            return false;
        }
        return super.offer(pair);
    }

    @Override
    public final PriorityQueueNode.Integer<E> poll() {
        PriorityQueueNode.Integer result = super.poll();
        if (result != null) {
            this.index.remove(result.element);
        }
        return result;
    }

    @Override
    final FibonacciHeapNode<E> find(Object element) {
        return this.index.get(element);
    }

    @Override
    final FibonacciHeapNode<E> internalOffer(PriorityQueueNode.Integer<E> pair) {
        FibonacciHeapNode<E> node = super.internalOffer(pair);
        this.index.put(pair.element, node);
        return node;
    }
}

