/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.ds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.cicirello.ds.AbstractFibonacciHeap;
import org.cicirello.ds.FibonacciHeapNode;
import org.cicirello.ds.MaxOrder;
import org.cicirello.ds.MergeablePriorityQueue;
import org.cicirello.ds.MinOrder;
import org.cicirello.ds.Prioritizer;
import org.cicirello.ds.PriorityQueueNode;
import org.cicirello.util.Copyable;

public class SimpleFibonacciHeap<E>
extends AbstractFibonacciHeap<E>
implements MergeablePriorityQueue<E, SimpleFibonacciHeap<E>>,
Copyable<SimpleFibonacciHeap<E>> {
    private SimpleFibonacciHeap() {
        this(new MinOrder());
    }

    SimpleFibonacciHeap(Prioritizer compare) {
        super(compare);
    }

    private SimpleFibonacciHeap(Collection<PriorityQueueNode.Integer<E>> initialElements) {
        this(initialElements, new MinOrder());
    }

    private SimpleFibonacciHeap(Collection<PriorityQueueNode.Integer<E>> initialElements, Prioritizer compare) {
        this(compare);
        for (PriorityQueueNode.Integer<E> element : initialElements) {
            this.internalOffer((PriorityQueueNode.Integer<E>)element.copy());
        }
    }

    SimpleFibonacciHeap(SimpleFibonacciHeap<E> other) {
        super(other);
    }

    @Override
    public SimpleFibonacciHeap<E> copy() {
        return new SimpleFibonacciHeap<E>(this);
    }

    public static <E> SimpleFibonacciHeap<E> createMinHeap() {
        return new SimpleFibonacciHeap<E>();
    }

    public static <E> SimpleFibonacciHeap<E> createMinHeap(Collection<PriorityQueueNode.Integer<E>> initialElements) {
        return new SimpleFibonacciHeap<E>(initialElements);
    }

    public static <E> SimpleFibonacciHeap<E> createMaxHeap() {
        return new SimpleFibonacciHeap<E>(new MaxOrder());
    }

    public static <E> SimpleFibonacciHeap<E> createMaxHeap(Collection<PriorityQueueNode.Integer<E>> initialElements) {
        return new SimpleFibonacciHeap<E>(initialElements, new MaxOrder());
    }

    @Override
    public boolean add(E element, int priority) {
        return this.offer(element, priority);
    }

    @Override
    public boolean add(PriorityQueueNode.Integer<E> pair) {
        return this.offer(pair);
    }

    @Override
    public final boolean change(E element, int priority) {
        FibonacciHeapNode node = this.find(element);
        if (node != null) {
            return this.internalChange(node, priority);
        }
        return this.offer(element, priority);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof PriorityQueueNode.Integer) {
            PriorityQueueNode.Integer pair = (PriorityQueueNode.Integer)o;
            return this.find(pair.element) != null;
        }
        return this.find(o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        HashSet<Object> containsThese = new HashSet<Object>();
        for (PriorityQueueNode.Integer e : this) {
            containsThese.add(e.element);
        }
        for (PriorityQueueNode.Integer<Object> o : c) {
            if (o instanceof PriorityQueueNode.Integer) {
                PriorityQueueNode.Integer<Object> pair = o;
                if (containsThese.contains(pair.element)) continue;
                return false;
            }
            if (containsThese.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean merge(SimpleFibonacciHeap<E> other) {
        return this.internalMerge(other);
    }

    @Override
    public boolean offer(E element, int priority) {
        this.internalOffer(new PriorityQueueNode.Integer<E>(element, priority));
        return true;
    }

    @Override
    public boolean offer(PriorityQueueNode.Integer<E> pair) {
        this.internalOffer(pair.copy());
        return true;
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        HashSet<Object> discardThese = this.toSet(c);
        ArrayList keepList = new ArrayList();
        for (PriorityQueueNode.Integer e : this) {
            if (discardThese.contains(e.element)) continue;
            keepList.add(e);
        }
        return this.from(keepList);
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        HashSet<Object> keepThese = this.toSet(c);
        ArrayList keepList = new ArrayList(keepThese.size());
        for (PriorityQueueNode.Integer e : this) {
            if (!keepThese.contains(e.element)) continue;
            keepList.add(e);
        }
        return this.from(keepList);
    }

    private HashSet<Object> toSet(Collection<?> c) {
        HashSet<Object> set = new HashSet<Object>();
        for (Object o : c) {
            if (o instanceof PriorityQueueNode.Integer) {
                PriorityQueueNode.Integer pair = (PriorityQueueNode.Integer)o;
                set.add(pair.element);
                continue;
            }
            set.add(o);
        }
        return set;
    }

    private boolean from(ArrayList<PriorityQueueNode.Integer<E>> keepList) {
        if (keepList.size() < this.size()) {
            this.clear();
            for (PriorityQueueNode.Integer<E> e : keepList) {
                this.internalOffer(e);
            }
            return true;
        }
        return false;
    }
}

