/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.sequences;

import java.util.random.RandomGenerator;
import org.cicirello.math.rand.RandomSampler;
import org.cicirello.sequences.AbstractSequenceSampler;
import org.cicirello.util.ArrayMinimumLengthEnforcer;

public final class SequenceInsertionSampler
extends AbstractSequenceSampler {
    private SequenceInsertionSampler() {
    }

    public static int[] sample(int[] source, int k, int[] target, RandomGenerator r) {
        SequenceInsertionSampler.validateK(k, source.length);
        target = RandomSampler.sampleInsertion(source.length, k, target, r);
        for (int i = 0; i < k; ++i) {
            target[i] = source[target[i]];
        }
        return target;
    }

    public static long[] sample(long[] source, int k, long[] target, RandomGenerator r) {
        SequenceInsertionSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        int[] indexes = RandomSampler.sampleInsertion(source.length, k, null, r);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }

    public static short[] sample(short[] source, int k, short[] target, RandomGenerator r) {
        SequenceInsertionSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        int[] indexes = RandomSampler.sampleInsertion(source.length, k, null, r);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }

    public static byte[] sample(byte[] source, int k, byte[] target, RandomGenerator r) {
        SequenceInsertionSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        int[] indexes = RandomSampler.sampleInsertion(source.length, k, null, r);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }

    public static char[] sample(char[] source, int k, char[] target, RandomGenerator r) {
        SequenceInsertionSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        int[] indexes = RandomSampler.sampleInsertion(source.length, k, null, r);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }

    public static char[] sample(String source, int k, char[] target, RandomGenerator r) {
        return SequenceInsertionSampler.sample(source.toCharArray(), k, target, r);
    }

    public static double[] sample(double[] source, int k, double[] target, RandomGenerator r) {
        SequenceInsertionSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        int[] indexes = RandomSampler.sampleInsertion(source.length, k, null, r);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }

    public static float[] sample(float[] source, int k, float[] target, RandomGenerator r) {
        SequenceInsertionSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        int[] indexes = RandomSampler.sampleInsertion(source.length, k, null, r);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }

    public static <T> T[] sample(T[] source, int k, T[] target, RandomGenerator r) {
        SequenceInsertionSampler.validateK(k, source.length);
        target = SequenceInsertionSampler.allocateIfNecessary(source, k, target);
        int[] indexes = RandomSampler.sampleInsertion(source.length, k, null, r);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }
}

