/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.sequences;

import java.util.Arrays;
import java.util.random.RandomGenerator;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.sequences.AbstractSequenceSampler;
import org.cicirello.util.ArrayMinimumLengthEnforcer;

public final class SequencePoolSampler
extends AbstractSequenceSampler {
    private SequencePoolSampler() {
    }

    public static int[] sample(int[] source, int k, int[] target, RandomGenerator r) {
        SequencePoolSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        int[] pool = (int[])source.clone();
        int remaining = pool.length;
        for (int i = 0; i < k; ++i) {
            int j = RandomIndexer.nextInt(remaining, r);
            target[i] = pool[j];
            pool[j] = pool[--remaining];
        }
        return target;
    }

    public static long[] sample(long[] source, int k, long[] target, RandomGenerator r) {
        SequencePoolSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        long[] pool = (long[])source.clone();
        int remaining = pool.length;
        for (int i = 0; i < k; ++i) {
            int j = RandomIndexer.nextInt(remaining, r);
            target[i] = pool[j];
            pool[j] = pool[--remaining];
        }
        return target;
    }

    public static short[] sample(short[] source, int k, short[] target, RandomGenerator r) {
        SequencePoolSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        short[] pool = (short[])source.clone();
        int remaining = pool.length;
        for (int i = 0; i < k; ++i) {
            int j = RandomIndexer.nextInt(remaining, r);
            target[i] = pool[j];
            pool[j] = pool[--remaining];
        }
        return target;
    }

    public static byte[] sample(byte[] source, int k, byte[] target, RandomGenerator r) {
        SequencePoolSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        byte[] pool = (byte[])source.clone();
        int remaining = pool.length;
        for (int i = 0; i < k; ++i) {
            int j = RandomIndexer.nextInt(remaining, r);
            target[i] = pool[j];
            pool[j] = pool[--remaining];
        }
        return target;
    }

    public static char[] sample(char[] source, int k, char[] target, RandomGenerator r) {
        SequencePoolSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        char[] pool = (char[])source.clone();
        int remaining = pool.length;
        for (int i = 0; i < k; ++i) {
            int j = RandomIndexer.nextInt(remaining, r);
            target[i] = pool[j];
            pool[j] = pool[--remaining];
        }
        return target;
    }

    public static char[] sample(String source, int k, char[] target, RandomGenerator r) {
        return SequencePoolSampler.sample(source.toCharArray(), k, target, r);
    }

    public static double[] sample(double[] source, int k, double[] target, RandomGenerator r) {
        SequencePoolSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        double[] pool = (double[])source.clone();
        int remaining = pool.length;
        for (int i = 0; i < k; ++i) {
            int j = RandomIndexer.nextInt(remaining, r);
            target[i] = pool[j];
            pool[j] = pool[--remaining];
        }
        return target;
    }

    public static float[] sample(float[] source, int k, float[] target, RandomGenerator r) {
        SequencePoolSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        float[] pool = (float[])source.clone();
        int remaining = pool.length;
        for (int i = 0; i < k; ++i) {
            int j = RandomIndexer.nextInt(remaining, r);
            target[i] = pool[j];
            pool[j] = pool[--remaining];
        }
        return target;
    }

    public static <T> T[] sample(T[] source, int k, T[] target, RandomGenerator r) {
        SequencePoolSampler.validateK(k, source.length);
        target = SequencePoolSampler.allocateIfNecessary(source, k, target);
        T[] pool = Arrays.copyOf(source, source.length);
        int remaining = pool.length;
        for (int i = 0; i < k; ++i) {
            int j = RandomIndexer.nextInt(remaining, r);
            target[i] = pool[j];
            pool[j] = pool[--remaining];
        }
        return target;
    }
}

