/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.sequences;

import java.util.random.RandomGenerator;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.sequences.AbstractSequenceSampler;
import org.cicirello.util.ArrayMinimumLengthEnforcer;

public final class SequenceReservoirSampler
extends AbstractSequenceSampler {
    private SequenceReservoirSampler() {
    }

    public static int[] sample(int[] source, int k, int[] target, RandomGenerator r) {
        SequenceReservoirSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        System.arraycopy(source, 0, target, 0, k);
        for (int i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt(i + 1, r);
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static long[] sample(long[] source, int k, long[] target, RandomGenerator r) {
        SequenceReservoirSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        System.arraycopy(source, 0, target, 0, k);
        for (int i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt(i + 1, r);
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static short[] sample(short[] source, int k, short[] target, RandomGenerator r) {
        SequenceReservoirSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        System.arraycopy(source, 0, target, 0, k);
        for (int i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt(i + 1, r);
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static byte[] sample(byte[] source, int k, byte[] target, RandomGenerator r) {
        SequenceReservoirSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        System.arraycopy(source, 0, target, 0, k);
        for (int i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt(i + 1, r);
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static char[] sample(char[] source, int k, char[] target, RandomGenerator r) {
        SequenceReservoirSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        System.arraycopy(source, 0, target, 0, k);
        for (int i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt(i + 1, r);
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static char[] sample(String source, int k, char[] target, RandomGenerator r) {
        return SequenceReservoirSampler.sample(source.toCharArray(), k, target, r);
    }

    public static double[] sample(double[] source, int k, double[] target, RandomGenerator r) {
        SequenceReservoirSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        System.arraycopy(source, 0, target, 0, k);
        for (int i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt(i + 1, r);
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static float[] sample(float[] source, int k, float[] target, RandomGenerator r) {
        SequenceReservoirSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce(target, k);
        System.arraycopy(source, 0, target, 0, k);
        for (int i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt(i + 1, r);
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }

    public static <T> T[] sample(T[] source, int k, T[] target, RandomGenerator r) {
        SequenceReservoirSampler.validateK(k, source.length);
        target = SequenceReservoirSampler.allocateIfNecessary(source, k, target);
        System.arraycopy(source, 0, target, 0, k);
        for (int i = k; i < source.length; ++i) {
            int j = RandomIndexer.nextInt(i + 1, r);
            if (j >= k) continue;
            target[j] = source[i];
        }
        return target;
    }
}

