/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.sequences;

import java.util.concurrent.ThreadLocalRandom;
import java.util.random.RandomGenerator;
import org.cicirello.math.rand.RandomVariates;
import org.cicirello.sequences.SequenceCompositeSampler;
import org.cicirello.sequences.SequenceInsertionSampler;
import org.cicirello.sequences.SequencePoolSampler;
import org.cicirello.sequences.SequenceReservoirSampler;

public final class SequenceSampler {
    private SequenceSampler() {
    }

    public static byte[] sample(byte[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null);
    }

    public static char[] sample(char[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null);
    }

    public static double[] sample(double[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null);
    }

    public static float[] sample(float[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null);
    }

    public static int[] sample(int[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null);
    }

    public static long[] sample(long[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null);
    }

    public static short[] sample(short[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null);
    }

    public static char[] sample(String source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial(source.length(), p), null);
    }

    public static <T> T[] sample(T[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null);
    }

    public static int[] sample(int[] source, int k, int[] target) {
        return SequenceCompositeSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static long[] sample(long[] source, int k, long[] target) {
        return SequenceCompositeSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static short[] sample(short[] source, int k, short[] target) {
        return SequenceCompositeSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static byte[] sample(byte[] source, int k, byte[] target) {
        return SequenceCompositeSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static char[] sample(char[] source, int k, char[] target) {
        return SequenceCompositeSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static char[] sample(String source, int k, char[] target) {
        return SequenceCompositeSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static double[] sample(double[] source, int k, double[] target) {
        return SequenceCompositeSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static float[] sample(float[] source, int k, float[] target) {
        return SequenceCompositeSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static <T> T[] sample(T[] source, int k, T[] target) {
        return SequenceCompositeSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static int[] sampleReservoir(int[] source, int k, int[] target) {
        return SequenceReservoirSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static long[] sampleReservoir(long[] source, int k, long[] target) {
        return SequenceReservoirSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static short[] sampleReservoir(short[] source, int k, short[] target) {
        return SequenceReservoirSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static byte[] sampleReservoir(byte[] source, int k, byte[] target) {
        return SequenceReservoirSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static char[] sampleReservoir(char[] source, int k, char[] target) {
        return SequenceReservoirSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static char[] sampleReservoir(String source, int k, char[] target) {
        return SequenceReservoirSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static double[] sampleReservoir(double[] source, int k, double[] target) {
        return SequenceReservoirSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static float[] sampleReservoir(float[] source, int k, float[] target) {
        return SequenceReservoirSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static <T> T[] sampleReservoir(T[] source, int k, T[] target) {
        return SequenceReservoirSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static int[] samplePool(int[] source, int k, int[] target) {
        return SequencePoolSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static long[] samplePool(long[] source, int k, long[] target) {
        return SequencePoolSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static short[] samplePool(short[] source, int k, short[] target) {
        return SequencePoolSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static byte[] samplePool(byte[] source, int k, byte[] target) {
        return SequencePoolSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static char[] samplePool(char[] source, int k, char[] target) {
        return SequencePoolSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static char[] samplePool(String source, int k, char[] target) {
        return SequencePoolSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static double[] samplePool(double[] source, int k, double[] target) {
        return SequencePoolSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static float[] samplePool(float[] source, int k, float[] target) {
        return SequencePoolSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static <T> T[] samplePool(T[] source, int k, T[] target) {
        return SequencePoolSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static int[] sampleInsertion(int[] source, int k, int[] target) {
        return SequenceInsertionSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static long[] sampleInsertion(long[] source, int k, long[] target) {
        return SequenceInsertionSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static short[] sampleInsertion(short[] source, int k, short[] target) {
        return SequenceInsertionSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static byte[] sampleInsertion(byte[] source, int k, byte[] target) {
        return SequenceInsertionSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static char[] sampleInsertion(char[] source, int k, char[] target) {
        return SequenceInsertionSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static char[] sampleInsertion(String source, int k, char[] target) {
        return SequenceInsertionSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static double[] sampleInsertion(double[] source, int k, double[] target) {
        return SequenceInsertionSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static float[] sampleInsertion(float[] source, int k, float[] target) {
        return SequenceInsertionSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    @Deprecated
    public static <T> T[] sampleInsertion(T[] source, int k, T[] target) {
        return SequenceInsertionSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }
}

