/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations.distance;

import org.cicirello.permutations.Permutation;
import org.cicirello.permutations.distance.NormalizedPermutationDistanceMeasurer;

public final class CycleDistance
implements NormalizedPermutationDistanceMeasurer {
    @Override
    public int distance(Permutation p1, Permutation p2) {
        if (p1.length() != p2.length()) {
            throw new IllegalArgumentException("Permutations must be the same length");
        }
        boolean[] used = new boolean[p1.length()];
        for (int k = 0; k < used.length; ++k) {
            if (p1.get(k) != p2.get(k)) continue;
            used[p1.get((int)k)] = true;
        }
        int i = 0;
        for (i = 0; i < used.length && used[p1.get(i)]; ++i) {
        }
        int[] invP1 = p1.getInverse();
        int cycleCount = 0;
        int iLast = i;
        while (i < used.length) {
            int j = p1.get(i);
            while (!used[j]) {
                used[j] = true;
                j = p2.get(i);
                i = invP1[j];
            }
            ++cycleCount;
            for (i = iLast + 1; i < used.length && used[p1.get(i)]; ++i) {
            }
            iLast = i;
        }
        return cycleCount;
    }

    @Override
    public int max(int length) {
        return length >> 1;
    }
}

