/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations.distance;

import org.cicirello.permutations.Permutation;
import org.cicirello.permutations.distance.NormalizedPermutationDistanceMeasurer;

public final class KCycleDistance
implements NormalizedPermutationDistanceMeasurer {
    private final int maxCycleLength;
    private int lastLength;
    private int precomputedMax;

    public KCycleDistance(int k) {
        if (k < 2) {
            throw new IllegalArgumentException("k must be at least 2");
        }
        this.maxCycleLength = k;
    }

    @Override
    public int distance(Permutation p1, Permutation p2) {
        if (p1.length() != p2.length()) {
            throw new IllegalArgumentException("Permutations must be the same length");
        }
        boolean[] used = new boolean[p1.length()];
        for (int k = 0; k < used.length; ++k) {
            if (p1.get(k) != p2.get(k)) continue;
            used[p1.get((int)k)] = true;
        }
        int i = 0;
        for (i = 0; i < used.length && used[p1.get(i)]; ++i) {
        }
        int[] invP1 = p1.getInverse();
        int cycleCount = 0;
        int iLast = i;
        while (i < used.length) {
            int j = p1.get(i);
            int cycleLength = 0;
            while (!used[j]) {
                used[j] = true;
                ++cycleLength;
                j = p2.get(i);
                i = invP1[j];
            }
            cycleCount = cycleLength > this.maxCycleLength ? (cycleCount += (int)Math.ceil(((double)cycleLength - 1.0) / ((double)this.maxCycleLength - 1.0))) : ++cycleCount;
            for (i = iLast + 1; i < used.length && used[p1.get(i)]; ++i) {
            }
            iLast = i;
        }
        return cycleCount;
    }

    @Override
    public int max(int length) {
        if (length != this.lastLength) {
            this.lastLength = length;
            this.precomputedMax = Math.max(length >> 1, (int)Math.ceil(((double)length - 1.0) / ((double)this.maxCycleLength - 1.0)));
        }
        return this.precomputedMax;
    }
}

