/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.sequences.distance;

import java.util.List;
import org.cicirello.sequences.distance.EditDistanceDouble;
import org.cicirello.sequences.distance.SequenceDistanceMeasurer;

public class EditDistance
extends EditDistanceDouble
implements SequenceDistanceMeasurer {
    private final int insert_i;
    private final int delete_i;
    private final int change_i;

    public EditDistance(double insertCost, double deleteCost, double changeCost) {
        super(insertCost, deleteCost, changeCost);
        if (this.isIntAsDouble(insertCost) && this.isIntAsDouble(deleteCost) && this.isIntAsDouble(changeCost)) {
            this.insert_i = (int)insertCost;
            this.delete_i = (int)deleteCost;
            this.change_i = (int)changeCost;
        } else {
            this.change_i = -1;
            this.delete_i = -1;
            this.insert_i = -1;
        }
    }

    public EditDistance(int insertCost, int deleteCost, int changeCost) {
        super(insertCost, deleteCost, changeCost);
        this.insert_i = insertCost;
        this.delete_i = deleteCost;
        this.change_i = changeCost;
    }

    @Override
    public final int distance(int[] s1, int[] s2) {
        return this.distance(s1.length, s2.length, (i, j, costIfSame) -> s1[i] == s2[j] ? costIfSame : costIfSame + this.change_i);
    }

    @Override
    public final int distance(long[] s1, long[] s2) {
        return this.distance(s1.length, s2.length, (i, j, costIfSame) -> s1[i] == s2[j] ? costIfSame : costIfSame + this.change_i);
    }

    @Override
    public final int distance(short[] s1, short[] s2) {
        return this.distance(s1.length, s2.length, (i, j, costIfSame) -> s1[i] == s2[j] ? costIfSame : costIfSame + this.change_i);
    }

    @Override
    public final int distance(byte[] s1, byte[] s2) {
        return this.distance(s1.length, s2.length, (i, j, costIfSame) -> s1[i] == s2[j] ? costIfSame : costIfSame + this.change_i);
    }

    @Override
    public final int distance(char[] s1, char[] s2) {
        return this.distance(s1.length, s2.length, (i, j, costIfSame) -> s1[i] == s2[j] ? costIfSame : costIfSame + this.change_i);
    }

    @Override
    public final int distance(boolean[] s1, boolean[] s2) {
        return this.distance(s1.length, s2.length, (i, j, costIfSame) -> s1[i] == s2[j] ? costIfSame : costIfSame + this.change_i);
    }

    @Override
    public final int distance(double[] s1, double[] s2) {
        return this.distance(s1.length, s2.length, (i, j, costIfSame) -> s1[i] == s2[j] ? costIfSame : costIfSame + this.change_i);
    }

    @Override
    public final int distance(float[] s1, float[] s2) {
        return this.distance(s1.length, s2.length, (i, j, costIfSame) -> s1[i] == s2[j] ? costIfSame : costIfSame + this.change_i);
    }

    @Override
    public final int distance(String s1, String s2) {
        return this.distance(s1.length(), s2.length(), (i, j, costIfSame) -> s1.charAt(i) == s2.charAt(j) ? costIfSame : costIfSame + this.change_i);
    }

    @Override
    public final int distance(Object[] s1, Object[] s2) {
        return this.distance(s1.length, s2.length, (i, j, costIfSame) -> s1[i].equals(s2[j]) ? costIfSame : costIfSame + this.change_i);
    }

    @Override
    public final <T> int distance(List<T> s1, List<T> s2) {
        return this.distance(s1.toArray(), s2.toArray());
    }

    private boolean isIntAsDouble(double d) {
        return (double)((int)d) == d;
    }

    private int distance(int n, int m, ChangeCost coster) {
        int[][] D = this.initD(n, m);
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= m; ++j) {
                D[i][j] = this.min(coster.apply(i - 1, j - 1, D[i - 1][j - 1]), D[i - 1][j] + this.delete_i, D[i][j - 1] + this.insert_i);
            }
        }
        return D[n][m];
    }

    private int[][] initD(int n, int m) {
        if (this.insert_i < 0) {
            throw new UnsupportedOperationException("EditDistance.distance not supported for floating-point costs.");
        }
        int[][] D = new int[n + 1][m + 1];
        for (int i = 1; i <= n; ++i) {
            D[i][0] = D[i - 1][0] + this.delete_i;
        }
        for (int j = 1; j <= m; ++j) {
            D[0][j] = D[0][j - 1] + this.insert_i;
        }
        return D;
    }

    private int min(int m1, int m2, int m3) {
        if (m2 < m1) {
            m1 = m2;
        }
        return m3 < m1 ? m3 : m1;
    }

    @FunctionalInterface
    private static interface ChangeCost {
        public int apply(int var1, int var2, int var3);
    }
}

