/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.ds;

import java.util.Collection;
import java.util.HashMap;
import org.cicirello.ds.FibonacciHeapDoubleNode;
import org.cicirello.ds.MaxOrder;
import org.cicirello.ds.MinOrder;
import org.cicirello.ds.Prioritizer;
import org.cicirello.ds.PriorityQueueNode;
import org.cicirello.ds.SimpleFibonacciHeapDouble;

public final class FibonacciHeapDouble<E>
extends SimpleFibonacciHeapDouble<E> {
    private HashMap<E, FibonacciHeapDoubleNode<E>> index = new HashMap();

    private FibonacciHeapDouble() {
        this(new MinOrder());
    }

    private FibonacciHeapDouble(Prioritizer compare) {
        super(compare);
    }

    private FibonacciHeapDouble(Collection<PriorityQueueNode.Double<E>> initialElements) {
        this(initialElements, new MinOrder());
    }

    private FibonacciHeapDouble(Collection<PriorityQueueNode.Double<E>> initialElements, Prioritizer compare) {
        this(compare);
        for (PriorityQueueNode.Double<E> element : initialElements) {
            if (this.offer(element)) continue;
            throw new IllegalArgumentException("initialElements contains duplicates");
        }
    }

    private FibonacciHeapDouble(FibonacciHeapDouble<E> other) {
        super(other);
        FibonacciHeapDoubleNode.NodeIterator iter = this.nodeIterator();
        while (iter.hasNext()) {
            Object node = iter.next();
            this.index.put((E)((FibonacciHeapDoubleNode)node).e.element, (FibonacciHeapDoubleNode<E>)node);
        }
    }

    @Override
    public FibonacciHeapDouble<E> copy() {
        return new FibonacciHeapDouble<E>(this);
    }

    public static <E> FibonacciHeapDouble<E> createMinHeap() {
        return new FibonacciHeapDouble<E>();
    }

    public static <E> FibonacciHeapDouble<E> createMinHeap(Collection<PriorityQueueNode.Double<E>> initialElements) {
        return new FibonacciHeapDouble<E>(initialElements);
    }

    public static <E> FibonacciHeapDouble<E> createMaxHeap() {
        return new FibonacciHeapDouble<E>(new MaxOrder());
    }

    public static <E> FibonacciHeapDouble<E> createMaxHeap(Collection<PriorityQueueNode.Double<E>> initialElements) {
        return new FibonacciHeapDouble<E>(initialElements, new MaxOrder());
    }

    @Override
    public boolean add(E element, double priority) {
        if (this.index.containsKey(element)) {
            throw new IllegalArgumentException("already contains an (element, priority) pair with this element");
        }
        return this.offer(element, priority);
    }

    @Override
    public boolean add(PriorityQueueNode.Double<E> pair) {
        if (this.index.containsKey(pair.element)) {
            throw new IllegalArgumentException("already contains an (element, priority) pair with this element");
        }
        return this.offer(pair);
    }

    @Override
    public final void clear() {
        super.clear();
        this.index = new HashMap();
    }

    @Override
    public final boolean contains(Object o) {
        if (o instanceof PriorityQueueNode.Double) {
            PriorityQueueNode.Double pair = (PriorityQueueNode.Double)o;
            return this.index.containsKey(pair.element);
        }
        return this.index.containsKey(o);
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (o instanceof PriorityQueueNode.Double) {
                PriorityQueueNode.Double pair = (PriorityQueueNode.Double)o;
                if (this.index.containsKey(pair.element)) continue;
                return false;
            }
            if (this.index.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean merge(SimpleFibonacciHeapDouble<E> other) {
        if (other instanceof FibonacciHeapDouble) {
            FibonacciHeapDouble fib = (FibonacciHeapDouble)other;
            this.index.putAll(fib.index);
        } else {
            FibonacciHeapDoubleNode.NodeIterator iter = other.nodeIterator();
            while (iter.hasNext()) {
                Object node = iter.next();
                this.index.put((E)((FibonacciHeapDoubleNode)node).e.element, (FibonacciHeapDoubleNode<E>)node);
            }
        }
        return super.merge(other);
    }

    @Override
    public final boolean offer(E element, double priority) {
        if (this.index.containsKey(element)) {
            return false;
        }
        return super.offer(element, priority);
    }

    @Override
    public final boolean offer(PriorityQueueNode.Double<E> pair) {
        if (this.index.containsKey(pair.element)) {
            return false;
        }
        return super.offer(pair);
    }

    @Override
    public final PriorityQueueNode.Double<E> poll() {
        PriorityQueueNode.Double result = super.poll();
        if (result != null) {
            this.index.remove(result.element);
        }
        return result;
    }

    @Override
    final FibonacciHeapDoubleNode<E> find(Object element) {
        return this.index.get(element);
    }

    @Override
    final FibonacciHeapDoubleNode<E> internalOffer(PriorityQueueNode.Double<E> pair) {
        FibonacciHeapDoubleNode<E> node = super.internalOffer(pair);
        this.index.put(pair.element, node);
        return node;
    }
}

