/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.ds;

import java.util.Arrays;
import org.cicirello.ds.IntPriorityQueueDouble;
import org.cicirello.util.Copyable;

public class IntFibonacciHeapDouble
implements IntPriorityQueueDouble,
Copyable<IntFibonacciHeapDouble> {
    private final Node[] index;
    private Node min;
    private int size;
    private final Node[] rootsByDegrees;
    private static final double INV_LOG_GOLDEN_RATIO = 2.0780869212350273;

    private IntFibonacciHeapDouble(int n) {
        this.index = new Node[n];
        this.rootsByDegrees = new Node[45];
    }

    private IntFibonacciHeapDouble(IntFibonacciHeapDouble other) {
        this.size = other.size;
        this.index = new Node[other.index.length];
        this.min = this.size > 0 ? other.min.copy(this.index) : null;
        this.rootsByDegrees = new Node[45];
    }

    @Override
    public IntFibonacciHeapDouble copy() {
        return new IntFibonacciHeapDouble(this);
    }

    @Override
    public boolean change(int element, double priority) {
        if (this.index[element] == null) {
            this.internalOffer(element, priority);
            return true;
        }
        return this.internalPromote(element, priority) || this.internalDemote(element, priority);
    }

    @Override
    public final void clear() {
        if (this.size > 0) {
            this.size = 0;
            this.min = null;
            Arrays.fill(this.index, null);
        }
    }

    @Override
    public final boolean contains(int element) {
        return this.index[element] != null;
    }

    public static IntFibonacciHeapDouble createMaxHeap(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("domain must be positive");
        }
        return new Max(n);
    }

    public static IntFibonacciHeapDouble createMinHeap(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("domain must be positive");
        }
        return new IntFibonacciHeapDouble(n);
    }

    @Override
    public boolean demote(int element, double priority) {
        return this.index[element] != null && this.internalDemote(element, priority);
    }

    @Override
    public final int domain() {
        return this.index.length;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean offer(int element, double priority) {
        if (this.index[element] != null) {
            return false;
        }
        this.internalOffer(element, priority);
        return true;
    }

    @Override
    public final int peek() {
        return this.min.element;
    }

    @Override
    public double peekPriority() {
        return this.min.priority;
    }

    @Override
    public double peekPriority(int element) {
        return this.index[element].priority;
    }

    @Override
    public final int poll() {
        if (this.size == 1) {
            int e = this.min.element;
            this.index[e] = null;
            this.min = null;
            this.size = 0;
            return e;
        }
        if (this.size > 1) {
            Node z = this.min;
            if (z.child != null) {
                z.child.clearParentReferences();
                z.child.insertListInto(this.min);
            }
            z.left.right = this.min = this.min.right;
            this.min.left = z.left;
            this.consolidate();
            this.index[z.element] = null;
            --this.size;
            return z.element;
        }
        return -1;
    }

    @Override
    public boolean promote(int element, double priority) {
        return this.index[element] != null && this.internalPromote(element, priority);
    }

    @Override
    public final int size() {
        return this.size;
    }

    private void consolidate() {
        int dn = (int)(Math.log(this.size) * 2.0780869212350273);
        Node w = this.min;
        w.left.right = null;
        do {
            Node x = w;
            w = w.right;
            x.right = null;
            x.left = null;
            int d = x.degree;
            while (this.rootsByDegrees[d] != null) {
                Node y = this.rootsByDegrees[d];
                if (y.priority < x.priority) {
                    Node temp = x;
                    x = y;
                    y = temp;
                }
                this.fibHeapLink(y, x);
                this.rootsByDegrees[d] = null;
                ++d;
            }
            this.rootsByDegrees[d] = x;
        } while (w != null);
        this.min = null;
        for (int i = 0; i <= dn; ++i) {
            if (this.rootsByDegrees[i] == null) continue;
            if (this.min == null) {
                this.rootsByDegrees[i].singletonList();
                this.min = this.rootsByDegrees[i];
            } else {
                this.rootsByDegrees[i].insertInto(this.min);
                if (this.rootsByDegrees[i].priority < this.min.priority) {
                    this.min = this.rootsByDegrees[i];
                }
            }
            this.rootsByDegrees[i] = null;
        }
    }

    private void fibHeapLink(Node y, Node x) {
        if (x.degree > 0) {
            y.insertInto(x.child);
            y.parent = x;
            ++x.degree;
        } else {
            y.singletonList();
            x.child = y;
            y.parent = x;
            x.degree = 1;
        }
        y.mark = false;
    }

    private void internalOffer(int element, double priority) {
        if (this.min == null) {
            this.index[element] = this.min = new Node(element, priority);
            this.size = 1;
        } else {
            this.index[element] = new Node(element, priority, this.min);
            if (priority < this.min.priority) {
                this.min = this.index[element];
            }
            ++this.size;
        }
    }

    private boolean internalPromote(int element, double priority) {
        Node x = this.index[element];
        if (priority < x.priority) {
            x.priority = priority;
            Node y = x.parent;
            if (y != null && priority < y.priority) {
                this.cut(x, y);
                this.cascadingCut(y);
            }
            if (priority < this.min.priority) {
                this.min = x;
            }
            return true;
        }
        return false;
    }

    private void cut(Node x, Node y) {
        if (y.degree > 1) {
            y.child = x.right;
            x.left.right = x.right;
            x.right.left = x.left;
            --y.degree;
        } else {
            y.child = null;
            y.degree = 0;
        }
        x.insertInto(this.min);
        x.parent = null;
        x.mark = false;
    }

    private void cascadingCut(Node y) {
        Node z = y.parent;
        if (z != null) {
            if (!y.mark) {
                y.mark = true;
            } else {
                this.cut(y, z);
                this.cascadingCut(z);
            }
        }
    }

    private boolean internalDemote(int element, double priority) {
        if (priority > this.index[element].priority) {
            this.internalPromote(element, this.min.priority - 1.0);
            this.poll();
            this.internalOffer(element, priority);
            return true;
        }
        return false;
    }

    private class Node {
        private final int element;
        private double priority;
        private Node parent;
        private Node child;
        private Node left;
        private Node right;
        private int degree;
        private boolean mark;

        public Node(int element, double priority) {
            this.element = element;
            this.priority = priority;
            this.singletonList();
        }

        public Node(int element, double priority, Node list) {
            this.element = element;
            this.priority = priority;
            this.insertInto(list);
        }

        private Node(Node other) {
            this.element = other.element;
            this.priority = other.priority;
            this.degree = other.degree;
            this.mark = other.mark;
        }

        private Node(Node other, Node toTheLeft) {
            this(other);
            this.left = toTheLeft;
        }

        private Node copy(Node[] indexCopy) {
            return this.copyList(this, null, indexCopy);
        }

        private Node copyList(Node x, Node p, Node[] indexCopy) {
            Node y;
            indexCopy[y.element] = y = new Node(x);
            y.parent = p;
            if (x.child != null) {
                y.child = this.copyList(x.child, y, indexCopy);
            }
            Node rightOf = y;
            Node next = x.right;
            while (next != x) {
                indexCopy[rightOf.right.element] = rightOf.right = new Node(next, rightOf);
                rightOf.right.parent = p;
                if (next.child != null) {
                    rightOf.right.child = this.copyList(next.child, rightOf.right, indexCopy);
                }
                next = next.right;
                rightOf = rightOf.right;
            }
            rightOf.right = y;
            y.left = rightOf;
            return y;
        }

        private void singletonList() {
            this.left = this.right = this;
        }

        private void insertInto(Node list) {
            this.right = list.right;
            this.left = list;
            list.right = list.right.left = this;
        }

        private void insertListInto(Node list) {
            list.right.left = this.left;
            this.left.right = list.right;
            list.right = this;
            this.left = list;
        }

        private void clearParentReferences() {
            Node next = this;
            while (next.parent != null) {
                next.parent = null;
                next = next.right;
            }
        }
    }

    private static final class Max
    extends IntFibonacciHeapDouble {
        private Max(int n) {
            super(n);
        }

        private Max(Max other) {
            super(other);
        }

        @Override
        public Max copy() {
            return new Max(this);
        }

        @Override
        public boolean change(int element, double priority) {
            return super.change(element, -priority);
        }

        @Override
        public boolean demote(int element, double priority) {
            return super.demote(element, -priority);
        }

        @Override
        public boolean offer(int element, double priority) {
            return super.offer(element, -priority);
        }

        @Override
        public double peekPriority() {
            return -super.peekPriority();
        }

        @Override
        public double peekPriority(int element) {
            return -super.peekPriority(element);
        }

        @Override
        public boolean promote(int element, double priority) {
            return super.promote(element, -priority);
        }
    }
}

