/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.ds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.cicirello.ds.AbstractFibonacciHeapDouble;
import org.cicirello.ds.FibonacciHeapDoubleNode;
import org.cicirello.ds.MaxOrder;
import org.cicirello.ds.MergeablePriorityQueueDouble;
import org.cicirello.ds.MinOrder;
import org.cicirello.ds.Prioritizer;
import org.cicirello.ds.PriorityQueueNode;
import org.cicirello.util.Copyable;

public class SimpleFibonacciHeapDouble<E>
extends AbstractFibonacciHeapDouble<E>
implements MergeablePriorityQueueDouble<E, SimpleFibonacciHeapDouble<E>>,
Copyable<SimpleFibonacciHeapDouble<E>> {
    private SimpleFibonacciHeapDouble() {
        this(new MinOrder());
    }

    SimpleFibonacciHeapDouble(Prioritizer compare) {
        super(compare);
    }

    private SimpleFibonacciHeapDouble(Collection<PriorityQueueNode.Double<E>> initialElements) {
        this(initialElements, new MinOrder());
    }

    private SimpleFibonacciHeapDouble(Collection<PriorityQueueNode.Double<E>> initialElements, Prioritizer compare) {
        this(compare);
        for (PriorityQueueNode.Double<E> element : initialElements) {
            this.internalOffer((PriorityQueueNode.Double<E>)element.copy());
        }
    }

    SimpleFibonacciHeapDouble(SimpleFibonacciHeapDouble<E> other) {
        super(other);
    }

    @Override
    public SimpleFibonacciHeapDouble<E> copy() {
        return new SimpleFibonacciHeapDouble<E>(this);
    }

    public static <E> SimpleFibonacciHeapDouble<E> createMinHeap() {
        return new SimpleFibonacciHeapDouble<E>();
    }

    public static <E> SimpleFibonacciHeapDouble<E> createMinHeap(Collection<PriorityQueueNode.Double<E>> initialElements) {
        return new SimpleFibonacciHeapDouble<E>(initialElements);
    }

    public static <E> SimpleFibonacciHeapDouble<E> createMaxHeap() {
        return new SimpleFibonacciHeapDouble<E>(new MaxOrder());
    }

    public static <E> SimpleFibonacciHeapDouble<E> createMaxHeap(Collection<PriorityQueueNode.Double<E>> initialElements) {
        return new SimpleFibonacciHeapDouble<E>(initialElements, new MaxOrder());
    }

    @Override
    public boolean add(E element, double priority) {
        return this.offer(element, priority);
    }

    @Override
    public boolean add(PriorityQueueNode.Double<E> pair) {
        return this.offer(pair);
    }

    @Override
    public final boolean change(E element, double priority) {
        FibonacciHeapDoubleNode node = this.find(element);
        if (node != null) {
            return this.internalChange(node, priority);
        }
        return this.offer(element, priority);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof PriorityQueueNode.Double) {
            PriorityQueueNode.Double pair = (PriorityQueueNode.Double)o;
            return this.find(pair.element) != null;
        }
        return this.find(o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        HashSet<Object> containsThese = new HashSet<Object>();
        for (PriorityQueueNode.Double e : this) {
            containsThese.add(e.element);
        }
        for (PriorityQueueNode.Double<Object> o : c) {
            if (o instanceof PriorityQueueNode.Double) {
                PriorityQueueNode.Double<Object> pair = o;
                if (containsThese.contains(pair.element)) continue;
                return false;
            }
            if (containsThese.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean merge(SimpleFibonacciHeapDouble<E> other) {
        return this.internalMerge(other);
    }

    @Override
    public boolean offer(E element, double priority) {
        this.internalOffer(new PriorityQueueNode.Double<E>(element, priority));
        return true;
    }

    @Override
    public boolean offer(PriorityQueueNode.Double<E> pair) {
        this.internalOffer(pair.copy());
        return true;
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        HashSet<Object> discardThese = this.toSet(c);
        ArrayList keepList = new ArrayList();
        for (PriorityQueueNode.Double e : this) {
            if (discardThese.contains(e.element)) continue;
            keepList.add(e);
        }
        return this.from(keepList);
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        HashSet<Object> keepThese = this.toSet(c);
        ArrayList keepList = new ArrayList(keepThese.size());
        for (PriorityQueueNode.Double e : this) {
            if (!keepThese.contains(e.element)) continue;
            keepList.add(e);
        }
        return this.from(keepList);
    }

    private HashSet<Object> toSet(Collection<?> c) {
        HashSet<Object> set = new HashSet<Object>();
        for (Object o : c) {
            if (o instanceof PriorityQueueNode.Double) {
                PriorityQueueNode.Double pair = (PriorityQueueNode.Double)o;
                set.add(pair.element);
                continue;
            }
            set.add(o);
        }
        return set;
    }

    private boolean from(ArrayList<PriorityQueueNode.Double<E>> keepList) {
        if (keepList.size() < this.size()) {
            this.clear();
            for (PriorityQueueNode.Double<E> e : keepList) {
                this.internalOffer(e);
            }
            return true;
        }
        return false;
    }
}

