/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations.distance;

import org.cicirello.permutations.Permutation;
import org.cicirello.permutations.distance.PermutationDistanceMeasurerDouble;

public final class EditDistance
implements PermutationDistanceMeasurerDouble {
    private double insertCost;
    private double deleteCost;
    private double changeCost;

    public EditDistance(double insertCost, double deleteCost, double changeCost) {
        this.insertCost = insertCost;
        this.deleteCost = deleteCost;
        this.changeCost = changeCost;
    }

    public EditDistance() {
        this.deleteCost = 0.5;
        this.insertCost = 0.5;
        this.changeCost = 1.0;
    }

    @Override
    public double distancef(Permutation p1, Permutation p2) {
        int i;
        int L2;
        int L1 = p1.length();
        if (L1 == (L2 = p2.length()) && L1 <= 1) {
            return 0.0;
        }
        double[][] D = new double[L1 + 1][L2 + 1];
        for (i = 1; i <= L1; ++i) {
            D[i][0] = D[i - 1][0] + this.deleteCost;
        }
        for (int j = 1; j <= L2; ++j) {
            D[0][j] = D[0][j - 1] + this.insertCost;
        }
        for (i = 1; i <= L1; ++i) {
            for (int j = 1; j <= L2; ++j) {
                double m1 = D[i - 1][j - 1] + (p1.get(i - 1) != p2.get(j - 1) ? this.changeCost : 0.0);
                double m2 = D[i - 1][j] + this.deleteCost;
                double m3 = D[i][j - 1] + this.insertCost;
                double min = m1;
                if (m2 < min) {
                    min = m2;
                }
                if (m3 < min) {
                    min = m3;
                }
                D[i][j] = min;
            }
        }
        return D[L1][L2];
    }
}

