/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.sequences;

import java.util.random.RandomGenerator;
import org.cicirello.math.rand.RandomSampler;
import org.cicirello.math.rand.RandomVariates;
import org.cicirello.sequences.AbstractSequenceSampler;
import org.cicirello.sequences.SequenceSampler;
import org.cicirello.util.ArrayMinimumLengthEnforcer;

public final class SequenceInsertionSampler
extends AbstractSequenceSampler
implements SequenceSampler {
    private final RandomGenerator r;

    public SequenceInsertionSampler(RandomGenerator r) {
        this.r = r;
    }

    @Override
    public int[] nextSample(int[] source, int k, int[] target) {
        return SequenceInsertionSampler.sample(source, k, target, this.r);
    }

    @Override
    public long[] nextSample(long[] source, int k, long[] target) {
        return SequenceInsertionSampler.sample(source, k, target, this.r);
    }

    @Override
    public short[] nextSample(short[] source, int k, short[] target) {
        return SequenceInsertionSampler.sample(source, k, target, this.r);
    }

    @Override
    public byte[] nextSample(byte[] source, int k, byte[] target) {
        return SequenceInsertionSampler.sample(source, k, target, this.r);
    }

    @Override
    public double[] nextSample(double[] source, int k, double[] target) {
        return SequenceInsertionSampler.sample(source, k, target, this.r);
    }

    @Override
    public float[] nextSample(float[] source, int k, float[] target) {
        return SequenceInsertionSampler.sample(source, k, target, this.r);
    }

    @Override
    public char[] nextSample(char[] source, int k, char[] target) {
        return SequenceInsertionSampler.sample(source, k, target, this.r);
    }

    @Override
    public char[] nextSample(String source, int k, char[] target) {
        return SequenceInsertionSampler.sample(source, k, target, this.r);
    }

    @Override
    public <T> T[] nextSample(T[] source, int k, T[] target) {
        return SequenceInsertionSampler.sample(source, k, target, this.r);
    }

    public static int[] sample(int[] source, double p, RandomGenerator r) {
        return SequenceInsertionSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null, r);
    }

    public static long[] sample(long[] source, double p, RandomGenerator r) {
        return SequenceInsertionSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null, r);
    }

    public static short[] sample(short[] source, double p, RandomGenerator r) {
        return SequenceInsertionSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null, r);
    }

    public static byte[] sample(byte[] source, double p, RandomGenerator r) {
        return SequenceInsertionSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null, r);
    }

    public static double[] sample(double[] source, double p, RandomGenerator r) {
        return SequenceInsertionSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null, r);
    }

    public static float[] sample(float[] source, double p, RandomGenerator r) {
        return SequenceInsertionSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null, r);
    }

    public static char[] sample(char[] source, double p, RandomGenerator r) {
        return SequenceInsertionSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null, r);
    }

    public static char[] sample(String source, double p, RandomGenerator r) {
        return SequenceInsertionSampler.sample(source, RandomVariates.nextBinomial((int)source.length(), (double)p), null, r);
    }

    public static <T> T[] sample(T[] source, double p, RandomGenerator r) {
        return SequenceInsertionSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null, r);
    }

    public static int[] sample(int[] source, int k, int[] target, RandomGenerator r) {
        SequenceInsertionSampler.validateK(k, source.length);
        target = RandomSampler.sampleInsertion((int)source.length, (int)k, (int[])target, (RandomGenerator)r);
        for (int i = 0; i < k; ++i) {
            target[i] = source[target[i]];
        }
        return target;
    }

    public static long[] sample(long[] source, int k, long[] target, RandomGenerator r) {
        SequenceInsertionSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce((long[])target, (int)k);
        int[] indexes = RandomSampler.sampleInsertion((int)source.length, (int)k, null, (RandomGenerator)r);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }

    public static short[] sample(short[] source, int k, short[] target, RandomGenerator r) {
        SequenceInsertionSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce((short[])target, (int)k);
        int[] indexes = RandomSampler.sampleInsertion((int)source.length, (int)k, null, (RandomGenerator)r);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }

    public static byte[] sample(byte[] source, int k, byte[] target, RandomGenerator r) {
        SequenceInsertionSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce((byte[])target, (int)k);
        int[] indexes = RandomSampler.sampleInsertion((int)source.length, (int)k, null, (RandomGenerator)r);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }

    public static char[] sample(char[] source, int k, char[] target, RandomGenerator r) {
        SequenceInsertionSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce((char[])target, (int)k);
        int[] indexes = RandomSampler.sampleInsertion((int)source.length, (int)k, null, (RandomGenerator)r);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }

    public static char[] sample(String source, int k, char[] target, RandomGenerator r) {
        return SequenceInsertionSampler.sample(source.toCharArray(), k, target, r);
    }

    public static double[] sample(double[] source, int k, double[] target, RandomGenerator r) {
        SequenceInsertionSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce((double[])target, (int)k);
        int[] indexes = RandomSampler.sampleInsertion((int)source.length, (int)k, null, (RandomGenerator)r);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }

    public static float[] sample(float[] source, int k, float[] target, RandomGenerator r) {
        SequenceInsertionSampler.validateK(k, source.length);
        target = ArrayMinimumLengthEnforcer.enforce((float[])target, (int)k);
        int[] indexes = RandomSampler.sampleInsertion((int)source.length, (int)k, null, (RandomGenerator)r);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }

    public static <T> T[] sample(T[] source, int k, T[] target, RandomGenerator r) {
        SequenceInsertionSampler.validateK(k, source.length);
        target = SequenceInsertionSampler.allocateIfNecessary(source, k, target);
        int[] indexes = RandomSampler.sampleInsertion((int)source.length, (int)k, null, (RandomGenerator)r);
        for (int i = 0; i < k; ++i) {
            target[i] = source[indexes[i]];
        }
        return target;
    }
}

