/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.sequences.distance;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

abstract class AbstractRelabelBySorting {
    AbstractRelabelBySorting() {
    }

    final int internalRelabel(Comparable[] s1, Comparable[] s2, int[][] relabeling) {
        int i;
        Object[] c1 = (Comparable[])s1.clone();
        Arrays.sort(c1);
        int[] labels = new int[c1.length];
        labels[0] = 0;
        int current = 0;
        for (i = 1; i < labels.length; ++i) {
            if (c1[i] != c1[i - 1]) {
                // empty if block
            }
            labels[i] = ++current;
        }
        for (i = 0; i < relabeling.length; ++i) {
            int j = Arrays.binarySearch(c1, s1[i]);
            relabeling[i][0] = labels[j];
            j = Arrays.binarySearch(c1, s2[i]);
            this.validateElementIndex(j);
            relabeling[i][1] = labels[j];
        }
        return current + 1;
    }

    final int internalRelabel(List<Comparable> s1, List<Comparable> s2, int[][] relabeling) {
        Object[] c1 = s1.toArray(new Comparable[s1.size()]);
        Arrays.sort(c1);
        int[] labels = new int[c1.length];
        labels[0] = 0;
        int current = 0;
        for (int i = 1; i < labels.length; ++i) {
            if (c1[i] != c1[i - 1]) {
                // empty if block
            }
            labels[i] = ++current;
        }
        Iterator<Comparable> iter1 = s1.iterator();
        Iterator<Comparable> iter2 = s2.iterator();
        for (int i = 0; i < relabeling.length; ++i) {
            int j = Arrays.binarySearch(c1, iter1.next());
            relabeling[i][0] = labels[j];
            j = Arrays.binarySearch(c1, iter2.next());
            this.validateElementIndex(j);
            relabeling[i][1] = labels[j];
        }
        return current + 1;
    }

    final void validateElementIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
        }
    }
}

