/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.sequences.distance;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.cicirello.sequences.distance.KendallTauRelabeler;

final class RelabelByHashing
implements KendallTauRelabeler {
    RelabelByHashing() {
    }

    @Override
    public int relabel(Object[] s1, Object[] s2, int[][] relabeling) {
        int i;
        HashMap<Object, Integer> labelMap = new HashMap<Object, Integer>((int)(1.334 * (double)relabeling.length) + 2);
        int current = -1;
        for (i = 0; i < relabeling.length; ++i) {
            if (labelMap.containsKey(s1[i])) continue;
            labelMap.put(s1[i], ++current);
        }
        for (i = 0; i < relabeling.length; ++i) {
            relabeling[i][0] = (Integer)labelMap.get(s1[i]);
            Integer j = (Integer)labelMap.get(s2[i]);
            if (j == null) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = j;
        }
        return current + 1;
    }

    @Override
    public <T> int relabel(List<T> s1, List<T> s2, int[][] relabeling) {
        HashMap<T, Integer> labelMap = new HashMap<T, Integer>((int)(1.334 * (double)relabeling.length) + 2);
        int current = -1;
        for (T e : s1) {
            if (labelMap.containsKey(e)) continue;
            labelMap.put(e, ++current);
        }
        Iterator<T> iter1 = s1.iterator();
        Iterator<T> iter2 = s2.iterator();
        for (int i = 0; i < relabeling.length; ++i) {
            relabeling[i][0] = (Integer)labelMap.get(iter1.next());
            Integer j = (Integer)labelMap.get(iter2.next());
            if (j == null) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = j;
        }
        return current + 1;
    }

    @Override
    public int relabel(int[] s1, int[] s2, int[][] relabeling) {
        IntHT labelMap = new IntHT((int)(1.334 * (double)relabeling.length) + 2);
        int current = labelMap.populate(s1);
        for (int i = 0; i < relabeling.length; ++i) {
            relabeling[i][0] = labelMap.get(s1[i]);
            int j = labelMap.get(s2[i]);
            if (j == -1) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = j;
        }
        return current + 1;
    }

    @Override
    public int relabel(double[] s1, double[] s2, int[][] relabeling) {
        DoubleHT labelMap = new DoubleHT((int)(1.334 * (double)relabeling.length) + 2);
        int current = labelMap.populate(s1);
        for (int i = 0; i < relabeling.length; ++i) {
            relabeling[i][0] = labelMap.get(s1[i]);
            int j = labelMap.get(s2[i]);
            if (j == -1) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = j;
        }
        return current + 1;
    }

    @Override
    public int relabel(float[] s1, float[] s2, int[][] relabeling) {
        FloatHT labelMap = new FloatHT((int)(1.334 * (double)relabeling.length) + 2);
        int current = labelMap.populate(s1);
        for (int i = 0; i < relabeling.length; ++i) {
            relabeling[i][0] = labelMap.get(s1[i]);
            int j = labelMap.get(s2[i]);
            if (j == -1) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = j;
        }
        return current + 1;
    }

    @Override
    public int relabel(long[] s1, long[] s2, int[][] relabeling) {
        LongHT labelMap = new LongHT((int)(1.334 * (double)relabeling.length) + 2);
        int current = labelMap.populate(s1);
        for (int i = 0; i < relabeling.length; ++i) {
            relabeling[i][0] = labelMap.get(s1[i]);
            int j = labelMap.get(s2[i]);
            if (j == -1) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = j;
        }
        return current + 1;
    }

    @Override
    public int relabel(short[] s1, short[] s2, int[][] relabeling) {
        ShortHT labelMap = new ShortHT((int)(1.334 * (double)relabeling.length) + 2);
        int current = labelMap.populate(s1);
        for (int i = 0; i < relabeling.length; ++i) {
            relabeling[i][0] = labelMap.get(s1[i]);
            int j = labelMap.get(s2[i]);
            if (j == -1) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = j;
        }
        return current + 1;
    }

    @Override
    public int relabel(char[] s1, char[] s2, int[][] relabeling) {
        CharHT labelMap = new CharHT((int)(1.334 * (double)relabeling.length) + 2);
        int current = labelMap.populate(s1);
        for (int i = 0; i < relabeling.length; ++i) {
            relabeling[i][0] = labelMap.get(s1[i]);
            int j = labelMap.get(s2[i]);
            if (j == -1) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = j;
        }
        return current + 1;
    }

    @Override
    public int relabel(String s1, String s2, int[][] relabeling) {
        CharHT labelMap = new CharHT((int)(1.334 * (double)relabeling.length) + 2);
        int current = labelMap.populate(s1);
        for (int i = 0; i < relabeling.length; ++i) {
            relabeling[i][0] = labelMap.get(s1.charAt(i));
            int j = labelMap.get(s2.charAt(i));
            if (j == -1) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = j;
        }
        return current + 1;
    }

    @Override
    public int relabel(byte[] s1, byte[] s2, int[][] relabeling) {
        int i;
        int[] labelMap = new int[256];
        int current = 0;
        for (i = 0; i < relabeling.length; ++i) {
            int key = 0xFF & s1[i];
            if (labelMap[key] != 0) continue;
            labelMap[key] = ++current;
        }
        for (i = 0; i < relabeling.length; ++i) {
            int key1 = 0xFF & s1[i];
            relabeling[i][0] = labelMap[key1] - 1;
            int key2 = 0xFF & s2[i];
            int j = labelMap[key2];
            if (j == 0) {
                throw new IllegalArgumentException("Sequences must contain same elements: s2 contains at least one element not in s1.");
            }
            relabeling[i][1] = j - 1;
        }
        return current;
    }

    private static final class IntHT
    extends BaseHT {
        private final Node[] table;

        IntHT(int min) {
            super(0x40000000, min);
            this.table = new Node[this.minSize];
        }

        int populate(int[] s1) {
            int current = -1;
            for (int i = 0; i < s1.length; ++i) {
                if (this.containsKey(s1[i])) continue;
                this.put(s1[i], ++current);
            }
            return current;
        }

        int index(int key) {
            return (key ^ key >>> 16) & this.mask;
        }

        boolean containsKey(int key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return true;
                }
                current = current.next;
            }
            return false;
        }

        int get(int key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return current.value;
                }
                current = current.next;
            }
            return -1;
        }

        void put(int key, int value) {
            int i = this.index(key);
            this.table[i] = new Node(key, value, this.table[i]);
        }

        static final class Node {
            int key;
            int value;
            Node next;

            Node(int key, int value, Node next) {
                this.key = key;
                this.value = value;
                this.next = next;
            }
        }
    }

    private static final class DoubleHT
    extends BaseHT {
        private final Node[] table;

        DoubleHT(int min) {
            super(0x40000000, min);
            this.table = new Node[this.minSize];
        }

        int populate(double[] s1) {
            int current = -1;
            for (int i = 0; i < s1.length; ++i) {
                if (this.containsKey(s1[i])) continue;
                this.put(s1[i], ++current);
            }
            return current;
        }

        int index(double key) {
            long x = Double.doubleToLongBits(key);
            int y = (int)(x ^ x >>> 32);
            return (y ^ y >>> 16) & this.mask;
        }

        boolean containsKey(double key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return true;
                }
                current = current.next;
            }
            return false;
        }

        int get(double key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return current.value;
                }
                current = current.next;
            }
            return -1;
        }

        void put(double key, int value) {
            int i = this.index(key);
            this.table[i] = new Node(key, value, this.table[i]);
        }

        static final class Node {
            double key;
            int value;
            Node next;

            Node(double key, int value, Node next) {
                this.key = key;
                this.value = value;
                this.next = next;
            }
        }
    }

    private static final class FloatHT
    extends BaseHT {
        private final Node[] table;

        FloatHT(int min) {
            super(0x40000000, min);
            this.table = new Node[this.minSize];
        }

        int populate(float[] s1) {
            int current = -1;
            for (int i = 0; i < s1.length; ++i) {
                if (this.containsKey(s1[i])) continue;
                this.put(s1[i], ++current);
            }
            return current;
        }

        int index(float key) {
            int x = Float.floatToIntBits(key);
            return (x ^ x >>> 16) & this.mask;
        }

        boolean containsKey(float key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return true;
                }
                current = current.next;
            }
            return false;
        }

        int get(float key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return current.value;
                }
                current = current.next;
            }
            return -1;
        }

        void put(float key, int value) {
            int i = this.index(key);
            this.table[i] = new Node(key, value, this.table[i]);
        }

        static final class Node {
            float key;
            int value;
            Node next;

            Node(float key, int value, Node next) {
                this.key = key;
                this.value = value;
                this.next = next;
            }
        }
    }

    private static final class LongHT
    extends BaseHT {
        private final Node[] table;

        LongHT(int min) {
            super(0x40000000, min);
            this.table = new Node[this.minSize];
        }

        int populate(long[] s1) {
            int current = -1;
            for (int i = 0; i < s1.length; ++i) {
                if (this.containsKey(s1[i])) continue;
                this.put(s1[i], ++current);
            }
            return current;
        }

        int index(long key) {
            int x = (int)(key ^ key >>> 32);
            return (x ^ x >>> 16) & this.mask;
        }

        boolean containsKey(long key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return true;
                }
                current = current.next;
            }
            return false;
        }

        int get(long key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return current.value;
                }
                current = current.next;
            }
            return -1;
        }

        void put(long key, int value) {
            int i = this.index(key);
            this.table[i] = new Node(key, value, this.table[i]);
        }

        static final class Node {
            long key;
            int value;
            Node next;

            Node(long key, int value, Node next) {
                this.key = key;
                this.value = value;
                this.next = next;
            }
        }
    }

    private static final class ShortHT
    extends BaseHT {
        private final Node[] table;

        ShortHT(int min) {
            super(65536, min);
            this.table = new Node[this.minSize];
        }

        int populate(short[] s1) {
            int current = -1;
            for (int i = 0; i < s1.length; ++i) {
                if (this.containsKey(s1[i])) continue;
                this.put(s1[i], ++current);
            }
            return current;
        }

        int index(short key) {
            return key & this.mask;
        }

        boolean containsKey(short key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return true;
                }
                current = current.next;
            }
            return false;
        }

        int get(short key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return current.value;
                }
                current = current.next;
            }
            return -1;
        }

        void put(short key, int value) {
            int i = this.index(key);
            this.table[i] = new Node(key, value, this.table[i]);
        }

        static final class Node {
            short key;
            int value;
            Node next;

            Node(short key, int value, Node next) {
                this.key = key;
                this.value = value;
                this.next = next;
            }
        }
    }

    private static final class CharHT
    extends BaseHT {
        private final Node[] table;

        CharHT(int min) {
            super(65536, min);
            this.table = new Node[this.minSize];
        }

        int populate(char[] s1) {
            int current = -1;
            for (int i = 0; i < s1.length; ++i) {
                if (this.containsKey(s1[i])) continue;
                this.put(s1[i], ++current);
            }
            return current;
        }

        int populate(String s1) {
            int current = -1;
            for (int i = 0; i < s1.length(); ++i) {
                if (this.containsKey(s1.charAt(i))) continue;
                this.put(s1.charAt(i), ++current);
            }
            return current;
        }

        int index(char key) {
            return key & this.mask;
        }

        boolean containsKey(char key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return true;
                }
                current = current.next;
            }
            return false;
        }

        int get(char key) {
            Node current = this.table[this.index(key)];
            while (current != null) {
                if (current.key == key) {
                    return current.value;
                }
                current = current.next;
            }
            return -1;
        }

        void put(char key, int value) {
            int i = this.index(key);
            this.table[i] = new Node(key, value, this.table[i]);
        }

        static final class Node {
            char key;
            int value;
            Node next;

            Node(char key, int value, Node next) {
                this.key = key;
                this.value = value;
                this.next = next;
            }
        }
    }

    static class BaseHT {
        protected final int mask;
        protected final int minSize;

        BaseHT(int maxSize, int minSize) {
            int MAX_SIZE = maxSize;
            if (minSize > MAX_SIZE) {
                minSize = MAX_SIZE;
                this.mask = minSize - 1;
            } else {
                --minSize;
                minSize |= minSize >> 1;
                minSize |= minSize >> 2;
                minSize |= minSize >> 4;
                minSize |= minSize >> 8;
                minSize |= minSize >> 16;
                this.mask = minSize++;
            }
            this.minSize = minSize;
        }
    }
}

