/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.ds;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.cicirello.ds.MaxOrder;
import org.cicirello.ds.MergeablePriorityQueueDouble;
import org.cicirello.ds.MinOrder;
import org.cicirello.ds.Prioritizer;
import org.cicirello.ds.PriorityQueueNode;
import org.cicirello.util.Copyable;

public final class BinaryHeapDouble<E>
implements MergeablePriorityQueueDouble<E, BinaryHeapDouble<E>>,
Copyable<BinaryHeapDouble<E>> {
    private PriorityQueueNode.Double<E>[] buffer;
    private int size;
    private final HashMap<E, Integer> index;
    private final Prioritizer compare;
    private final double extreme;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;

    private BinaryHeapDouble(int initialCapacity) {
        this(initialCapacity, (Prioritizer)new MinOrder());
    }

    private BinaryHeapDouble(int initialCapacity, Prioritizer compare) {
        this.compare = compare;
        this.buffer = this.allocate(initialCapacity);
        this.index = new HashMap();
        this.extreme = compare.comesBefore(0, 1) ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
    }

    private BinaryHeapDouble(Collection<PriorityQueueNode.Double<E>> initialElements) {
        this(initialElements, (Prioritizer)new MinOrder());
    }

    private BinaryHeapDouble(Collection<PriorityQueueNode.Double<E>> initialElements, Prioritizer compare) {
        this(initialElements.size(), compare);
        for (PriorityQueueNode.Double<E> element : initialElements) {
            if (this.index.containsKey(element.element)) {
                throw new IllegalArgumentException("initialElements contains duplicates");
            }
            this.buffer[this.size] = element.copy();
            this.index.put(this.buffer[this.size].element, this.size);
            ++this.size;
        }
        this.buildHeap();
    }

    private BinaryHeapDouble(BinaryHeapDouble<E> other) {
        this(other.capacity(), other.compare);
        this.size = other.size;
        for (int i = 0; i < this.size; ++i) {
            this.buffer[i] = other.buffer[i].copy();
            this.index.put(this.buffer[i].element, i);
        }
    }

    @Override
    public BinaryHeapDouble<E> copy() {
        return new BinaryHeapDouble<E>(this);
    }

    public static <E> BinaryHeapDouble<E> createMinHeap() {
        return new BinaryHeapDouble<E>(16);
    }

    public static <E> BinaryHeapDouble<E> createMinHeap(int initialCapacity) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("Initial capacity must be positive.");
        }
        return new BinaryHeapDouble<E>(initialCapacity);
    }

    public static <E> BinaryHeapDouble<E> createMinHeap(Collection<PriorityQueueNode.Double<E>> initialElements) {
        if (initialElements.size() < 1) {
            throw new IllegalArgumentException("initialElements is empty");
        }
        return new BinaryHeapDouble<E>(initialElements);
    }

    public static <E> BinaryHeapDouble<E> createMaxHeap() {
        return new BinaryHeapDouble<E>(16, (Prioritizer)new MaxOrder());
    }

    public static <E> BinaryHeapDouble<E> createMaxHeap(int initialCapacity) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("Initial capacity must be positive.");
        }
        return new BinaryHeapDouble<E>(initialCapacity, (Prioritizer)new MaxOrder());
    }

    public static <E> BinaryHeapDouble<E> createMaxHeap(Collection<PriorityQueueNode.Double<E>> initialElements) {
        if (initialElements.size() < 1) {
            throw new IllegalArgumentException("initialElements is empty");
        }
        return new BinaryHeapDouble<E>(initialElements, (Prioritizer)new MaxOrder());
    }

    @Override
    public final boolean addAll(Collection<? extends PriorityQueueNode.Double<E>> c) {
        if (this.size + c.size() > this.buffer.length) {
            this.internalAdjustCapacity(this.size + c.size() << 1);
        }
        boolean changed = false;
        for (PriorityQueueNode.Double<E> e : c) {
            if (this.index.containsKey(e.element)) {
                throw new IllegalArgumentException("heap already contains one or more of these elements");
            }
            this.buffer[this.size] = e.copy();
            this.index.put(this.buffer[this.size].element, this.size);
            ++this.size;
            changed = true;
        }
        if (changed) {
            this.buildHeap();
        }
        return changed;
    }

    @Override
    public final boolean change(E element, double priority) {
        if (!this.offer(element, priority)) {
            int i = this.index.get(element);
            if (this.compare.comesBefore(priority, this.buffer[i].value)) {
                this.buffer[i].value = priority;
                this.percolateUp(i);
                return true;
            }
            if (this.compare.comesBefore(this.buffer[i].value, priority)) {
                this.buffer[i].value = priority;
                this.percolateDown(i);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public final void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.buffer[i] = null;
        }
        this.size = 0;
        this.index.clear();
    }

    @Override
    public final boolean contains(Object o) {
        if (o instanceof PriorityQueueNode.Double) {
            PriorityQueueNode.Double pair = (PriorityQueueNode.Double)o;
            return this.index.containsKey(pair.element);
        }
        return this.index.containsKey(o);
    }

    @Override
    public final boolean demote(E element, double priority) {
        Integer where = this.index.get(element);
        if (where != null) {
            int i = where;
            if (this.compare.comesBefore(this.buffer[i].value, priority)) {
                this.buffer[i].value = priority;
                this.percolateDown(i);
                return true;
            }
        }
        return false;
    }

    public final void ensureCapacity(int minCapacity) {
        if (this.buffer.length < minCapacity) {
            this.internalAdjustCapacity(minCapacity);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof BinaryHeapDouble) {
            BinaryHeapDouble casted = (BinaryHeapDouble)other;
            if (this.size != casted.size) {
                return false;
            }
            if (this.compare.comesBefore(0, 1) != casted.compare.comesBefore(0, 1)) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (!this.buffer[i].element.equals(casted.buffer[i].element)) {
                    return false;
                }
                if (casted.buffer[i].value == this.buffer[i].value) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.size; ++i) {
            h = 31 * h + Double.hashCode(this.buffer[i].value);
            h = 31 * h + this.buffer[i].element.hashCode();
        }
        return h;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final Iterator<PriorityQueueNode.Double<E>> iterator() {
        return new BinaryHeapDoubleIterator();
    }

    @Override
    public boolean merge(BinaryHeapDouble<E> other) {
        if (this.compare.comesBefore(0, 1) != other.compare.comesBefore(0, 1)) {
            throw new IllegalArgumentException("this and other follow different priority-order");
        }
        if (this.size + other.size() > this.buffer.length) {
            this.internalAdjustCapacity(this.size + other.size() << 1);
        }
        boolean changed = false;
        for (int i = 0; i < other.size; ++i) {
            this.buffer[this.size] = other.buffer[i];
            this.index.put(this.buffer[this.size].element, this.size);
            ++this.size;
            changed = true;
        }
        if (changed) {
            other.clear();
            this.buildHeap();
        }
        return changed;
    }

    @Override
    public final boolean offer(E element, double priority) {
        if (this.contains(element)) {
            return false;
        }
        return this.internalOffer(new PriorityQueueNode.Double<E>(element, priority));
    }

    @Override
    public final boolean offer(PriorityQueueNode.Double<E> pair) {
        if (this.contains(pair.element)) {
            return false;
        }
        return this.internalOffer((PriorityQueueNode.Double<E>)pair.copy());
    }

    @Override
    public final E peekElement() {
        return (E)(this.size > 0 ? this.buffer[0].element : null);
    }

    @Override
    public final PriorityQueueNode.Double<E> peek() {
        return this.size > 0 ? this.buffer[0] : null;
    }

    @Override
    public final double peekPriority() {
        return this.size > 0 ? this.buffer[0].value : this.extreme;
    }

    @Override
    public final double peekPriority(E element) {
        Integer i = this.index.get(element);
        return i != null ? this.buffer[i.intValue()].value : this.extreme;
    }

    @Override
    public final E pollElement() {
        Object min = this.poll();
        return (E)(min != null ? ((PriorityQueueNode.Double)min).element : null);
    }

    @Override
    public final PriorityQueueNode.Double<E> poll() {
        if (this.size > 0) {
            PriorityQueueNode.Double<E> min = this.buffer[0];
            this.index.remove(min.element);
            --this.size;
            if (this.size > 0) {
                this.buffer[0] = this.buffer[this.size];
                this.buffer[this.size] = null;
                this.index.put(this.buffer[0].element, 0);
                this.percolateDown(0);
            } else {
                this.buffer[0] = null;
            }
            return min;
        }
        return null;
    }

    @Override
    public final PriorityQueueNode.Double<E> pollThenAdd(PriorityQueueNode.Double<E> pair) {
        PriorityQueueNode.Double<E> min;
        PriorityQueueNode.Double<E> double_ = min = this.size > 0 ? this.buffer[0] : null;
        if (min != null) {
            this.index.remove(min.element);
        }
        if (this.contains(pair.element)) {
            throw new IllegalArgumentException("This priority queue doesn't support duplicate elements, and already contains the element.");
        }
        this.buffer[0] = pair.copy();
        this.index.put(this.buffer[0].element, 0);
        if (this.size <= 0) {
            this.size = 1;
        } else {
            this.percolateDown(0);
        }
        return min;
    }

    @Override
    public final E pollThenAdd(E element, double priority) {
        Object min;
        Object object = min = this.size > 0 ? this.buffer[0].element : null;
        if (min != null) {
            this.index.remove(min);
        }
        if (this.contains(element)) {
            throw new IllegalArgumentException("This priority queue doesn't support duplicate elements, and already contains the element.");
        }
        this.buffer[0] = new PriorityQueueNode.Double<E>(element, priority);
        this.index.put(this.buffer[0].element, 0);
        if (this.size <= 0) {
            this.size = 1;
        } else {
            this.percolateDown(0);
        }
        return (E)min;
    }

    @Override
    public final boolean promote(E element, double priority) {
        Integer where = this.index.get(element);
        if (where != null) {
            int i = where;
            if (this.compare.comesBefore(priority, this.buffer[i].value)) {
                this.buffer[i].value = priority;
                this.percolateUp(i);
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean remove(Object o) {
        Integer i = null;
        if (o instanceof PriorityQueueNode.Double) {
            PriorityQueueNode.Double pair = (PriorityQueueNode.Double)o;
            i = this.index.get(pair.element);
        } else {
            i = this.index.get(o);
        }
        if (i == null) {
            return false;
        }
        this.index.remove(this.buffer[i.intValue()].element);
        --this.size;
        if (this.size > 0 && i != this.size) {
            double removedElementPriority = this.buffer[i.intValue()].value;
            this.buffer[i.intValue()] = this.buffer[this.size];
            this.buffer[this.size] = null;
            this.index.put(this.buffer[i.intValue()].element, i);
            if (this.compare.comesBefore(this.buffer[i.intValue()].value, removedElementPriority)) {
                this.percolateUp(i);
            } else if (this.compare.comesBefore(removedElementPriority, this.buffer[i.intValue()].value)) {
                this.percolateDown(i);
            }
        } else {
            this.buffer[i.intValue()] = null;
        }
        return true;
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        HashSet<Object> discardThese = new HashSet<Object>();
        for (Object o : c) {
            if (o instanceof PriorityQueueNode.Double) {
                PriorityQueueNode.Double pair = (PriorityQueueNode.Double)o;
                discardThese.add(pair.element);
                continue;
            }
            discardThese.add(o);
        }
        boolean changed = false;
        for (int i = this.size - 1; i >= 0; --i) {
            if (!discardThese.contains(this.buffer[i].element)) continue;
            changed = true;
            this.index.remove(this.buffer[i].element);
            --this.size;
            if (i == this.size) {
                this.buffer[i] = null;
                continue;
            }
            this.buffer[i] = this.buffer[this.size];
            this.index.put(this.buffer[i].element, i);
            this.buffer[this.size] = null;
        }
        if (changed) {
            this.buildHeap();
        }
        return changed;
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        HashSet<Object> keepThese = new HashSet<Object>();
        for (Object o : c) {
            if (o instanceof PriorityQueueNode.Double) {
                PriorityQueueNode.Double pair = (PriorityQueueNode.Double)o;
                keepThese.add(pair.element);
                continue;
            }
            keepThese.add(o);
        }
        boolean changed = false;
        for (int i = this.size - 1; i >= 0; --i) {
            if (keepThese.contains(this.buffer[i].element)) continue;
            changed = true;
            this.index.remove(this.buffer[i].element);
            --this.size;
            if (i == this.size) {
                this.buffer[i] = null;
                continue;
            }
            this.buffer[i] = this.buffer[this.size];
            this.index.put(this.buffer[i].element, i);
            this.buffer[this.size] = null;
        }
        if (changed) {
            this.buildHeap();
        }
        return changed;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final Object[] toArray() {
        Object[] array = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            array[i] = this.buffer[i];
        }
        return array;
    }

    @Override
    public final <T> T[] toArray(T[] array) {
        T[] result = array.length >= this.size ? array : (Object[])Array.newInstance(array.getClass().getComponentType(), this.size);
        for (int i = 0; i < this.size; ++i) {
            PriorityQueueNode.Double<E> nextElement = this.buffer[i];
            result[i] = nextElement;
        }
        if (result.length > this.size) {
            result[this.size] = null;
        }
        return result;
    }

    public final void trimToSize() {
        if (this.size < this.buffer.length) {
            this.internalAdjustCapacity(this.size > 0 ? this.size : 1);
        }
    }

    int capacity() {
        return this.buffer.length;
    }

    private void percolateDown(int i) {
        int left;
        while ((left = (i << 1) + 1) < this.size) {
            int right;
            int smallest = i;
            if (this.compare.comesBefore(this.buffer[left].value, this.buffer[i].value)) {
                smallest = left;
            }
            if ((right = left + 1) < this.size && this.compare.comesBefore(this.buffer[right].value, this.buffer[smallest].value)) {
                smallest = right;
            }
            if (smallest == i) break;
            PriorityQueueNode.Double<E> temp = this.buffer[i];
            this.buffer[i] = this.buffer[smallest];
            this.buffer[smallest] = temp;
            this.index.put(this.buffer[i].element, i);
            this.index.put(this.buffer[smallest].element, smallest);
            i = smallest;
        }
    }

    private void percolateUp(int i) {
        while (i > 0) {
            int parent = i - 1 >> 1;
            if (!this.compare.comesBefore(this.buffer[i].value, this.buffer[parent].value)) break;
            PriorityQueueNode.Double<E> temp = this.buffer[i];
            this.buffer[i] = this.buffer[parent];
            this.buffer[parent] = temp;
            this.index.put(this.buffer[i].element, i);
            this.index.put(this.buffer[parent].element, parent);
            i = parent;
        }
    }

    private PriorityQueueNode.Double<E>[] allocate(int capacity) {
        PriorityQueueNode.Double[] temp = new PriorityQueueNode.Double[capacity];
        return temp;
    }

    private void internalAdjustCapacity(int capacity) {
        PriorityQueueNode.Double<E>[] temp = this.allocate(capacity);
        System.arraycopy(this.buffer, 0, temp, 0, this.size);
        this.buffer = temp;
    }

    private boolean internalOffer(PriorityQueueNode.Double<E> pair) {
        if (this.size == this.buffer.length) {
            this.internalAdjustCapacity(this.size << 1);
        }
        this.buffer[this.size] = pair;
        this.index.put(pair.element, this.size);
        this.percolateUp(this.size);
        ++this.size;
        return true;
    }

    private void buildHeap() {
        for (int i = (this.size >> 1) - 1; i >= 0; --i) {
            this.percolateDown(i);
        }
    }

    private class BinaryHeapDoubleIterator
    implements Iterator<PriorityQueueNode.Double<E>> {
        private int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < BinaryHeapDouble.this.size;
        }

        @Override
        public PriorityQueueNode.Double<E> next() {
            if (this.index >= BinaryHeapDouble.this.size) {
                throw new NoSuchElementException("No more elements remain.");
            }
            ++this.index;
            return BinaryHeapDouble.this.buffer[this.index - 1];
        }
    }
}

