/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.ds;

import java.util.Collection;
import java.util.HashSet;
import org.cicirello.util.Copyable;

public abstract class PriorityQueueNode<E> {
    final E element;

    private PriorityQueueNode(E element) {
        this.element = element;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof PriorityQueueNode) {
            PriorityQueueNode casted = (PriorityQueueNode)other;
            return this.element.equals(casted.element);
        }
        return false;
    }

    public final E getElement() {
        return this.element;
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public static final class Double<E>
    extends PriorityQueueNode<E>
    implements Copyable<Double<E>> {
        double value;

        public Double(E element, double value) {
            super(element);
            this.value = value;
        }

        @Override
        public Double<E> copy() {
            if (this.element instanceof Copyable) {
                Copyable copyable = (Copyable)this.element;
                Object casted = copyable.copy();
                return new Double(casted, this.value);
            }
            return new Double<Object>(this.element, this.value);
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other) && ((Double)other).value == this.value;
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + java.lang.Double.hashCode(this.value);
        }

        public double getPriority() {
            return this.value;
        }

        final void setPriority(double value) {
            this.value = value;
        }

        static HashSet<Object> toSet(Collection<?> c) {
            HashSet<Object> set = new HashSet<Object>();
            for (Object o : c) {
                if (o instanceof Double) {
                    Double pair = (Double)o;
                    set.add(pair.element);
                    continue;
                }
                set.add(o);
            }
            return set;
        }
    }

    public static final class Integer<E>
    extends PriorityQueueNode<E>
    implements Copyable<Integer<E>> {
        int value;

        public Integer(E element, int value) {
            super(element);
            this.value = value;
        }

        @Override
        public Integer<E> copy() {
            if (this.element instanceof Copyable) {
                Copyable copyable = (Copyable)this.element;
                Object casted = copyable.copy();
                return new Integer(casted, this.value);
            }
            return new Integer<Object>(this.element, this.value);
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other) && ((Integer)other).value == this.value;
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + this.value;
        }

        public int getPriority() {
            return this.value;
        }

        final void setPriority(int value) {
            this.value = value;
        }

        static HashSet<Object> toSet(Collection<?> c) {
            HashSet<Object> set = new HashSet<Object>();
            for (Object o : c) {
                if (o instanceof Integer) {
                    Integer pair = (Integer)o;
                    set.add(pair.element);
                    continue;
                }
                set.add(o);
            }
            return set;
        }
    }
}

