/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.math.stats;

import org.cicirello.math.stats.Statistics;

final class InternalStatistics {
    private InternalStatistics() {
    }

    static double variance(int[] data, double divisor) {
        if (data.length < 2) {
            return 0.0;
        }
        double mean = Statistics.mean(data);
        double sumSquares = 0.0;
        double sum = 0.0;
        for (int e : data) {
            sumSquares += ((double)e - mean) * ((double)e - mean);
            sum += (double)e - mean;
        }
        return (sumSquares - sum * sum / (double)data.length) / divisor;
    }

    static double variance(double[] data, double divisor) {
        if (data.length < 2) {
            return 0.0;
        }
        double mean = Statistics.mean(data);
        double sumSquares = 0.0;
        double sum = 0.0;
        for (double e : data) {
            sumSquares += (e - mean) * (e - mean);
            sum += e - mean;
        }
        return (sumSquares - sum * sum / (double)data.length) / divisor;
    }

    static double correlation(double varX, double varY, double covar) {
        if (covar < 0.0) {
            return -Math.exp(Math.log(-covar) - 0.5 * Math.log(varX) - 0.5 * Math.log(varY));
        }
        return Math.exp(Math.log(covar) - 0.5 * Math.log(varX) - 0.5 * Math.log(varY));
    }
}

