/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations.distance;

import org.cicirello.permutations.Permutation;
import org.cicirello.permutations.distance.NormalizedPermutationDistanceMeasurer;

public final class CycleEditDistance
implements NormalizedPermutationDistanceMeasurer {
    @Override
    public int distance(Permutation p1, Permutation p2) {
        if (p1.length() != p2.length()) {
            throw new IllegalArgumentException("Permutations must be the same length");
        }
        boolean[] used = new boolean[p1.length()];
        for (int k = 0; k < used.length; ++k) {
            if (p1.get(k) != p2.get(k)) continue;
            used[p1.get((int)k)] = true;
        }
        int i = 0;
        for (i = 0; i < used.length && used[p1.get(i)]; ++i) {
        }
        if (i >= used.length) {
            return 0;
        }
        int[] invP1 = p1.getInverse();
        int iLast = i;
        int j = p1.get(i);
        while (!used[j]) {
            used[j] = true;
            j = p2.get(i);
            i = invP1[j];
        }
        for (i = iLast + 1; i < used.length; ++i) {
            if (used[p1.get(i)]) continue;
            return 2;
        }
        return 1;
    }

    @Override
    public int max(int length) {
        return length >= 4 ? 2 : (length >= 2 ? 1 : 0);
    }
}

