/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.sequences.distance;

import java.util.List;
import org.cicirello.sequences.distance.SequenceDistanceMeasurerDouble;

public class EditDistanceDouble
implements SequenceDistanceMeasurerDouble {
    private final double insert_d;
    private final double delete_d;
    private final double change_d;

    public EditDistanceDouble(double insertCost, double deleteCost, double changeCost) {
        if (insertCost < 0.0 || deleteCost < 0.0 || changeCost < 0.0) {
            throw new IllegalArgumentException("Costs must be non-negative.");
        }
        this.insert_d = insertCost;
        this.delete_d = deleteCost;
        this.change_d = changeCost;
    }

    @Override
    public final double distancef(int[] s1, int[] s2) {
        return this.distancef(s1.length, s2.length, (i, j, costIfSame) -> s1[i] == s2[j] ? costIfSame : costIfSame + this.change_d);
    }

    @Override
    public final double distancef(long[] s1, long[] s2) {
        return this.distancef(s1.length, s2.length, (i, j, costIfSame) -> s1[i] == s2[j] ? costIfSame : costIfSame + this.change_d);
    }

    @Override
    public final double distancef(short[] s1, short[] s2) {
        return this.distancef(s1.length, s2.length, (i, j, costIfSame) -> s1[i] == s2[j] ? costIfSame : costIfSame + this.change_d);
    }

    @Override
    public final double distancef(byte[] s1, byte[] s2) {
        return this.distancef(s1.length, s2.length, (i, j, costIfSame) -> s1[i] == s2[j] ? costIfSame : costIfSame + this.change_d);
    }

    @Override
    public final double distancef(char[] s1, char[] s2) {
        return this.distancef(s1.length, s2.length, (i, j, costIfSame) -> s1[i] == s2[j] ? costIfSame : costIfSame + this.change_d);
    }

    @Override
    public final double distancef(boolean[] s1, boolean[] s2) {
        return this.distancef(s1.length, s2.length, (i, j, costIfSame) -> s1[i] == s2[j] ? costIfSame : costIfSame + this.change_d);
    }

    @Override
    public final double distancef(double[] s1, double[] s2) {
        return this.distancef(s1.length, s2.length, (i, j, costIfSame) -> s1[i] == s2[j] ? costIfSame : costIfSame + this.change_d);
    }

    @Override
    public final double distancef(float[] s1, float[] s2) {
        return this.distancef(s1.length, s2.length, (i, j, costIfSame) -> s1[i] == s2[j] ? costIfSame : costIfSame + this.change_d);
    }

    @Override
    public final double distancef(String s1, String s2) {
        return this.distancef(s1.length(), s2.length(), (i, j, costIfSame) -> s1.charAt(i) == s2.charAt(j) ? costIfSame : costIfSame + this.change_d);
    }

    @Override
    public final double distancef(Object[] s1, Object[] s2) {
        return this.distancef(s1.length, s2.length, (i, j, costIfSame) -> s1[i].equals(s2[j]) ? costIfSame : costIfSame + this.change_d);
    }

    @Override
    public final <T> double distancef(List<T> s1, List<T> s2) {
        return this.distancef(s1.toArray(), s2.toArray());
    }

    private double distancef(int n, int m, ChangeCost coster) {
        double[][] D = this.initD(n, m);
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= m; ++j) {
                D[i][j] = this.min(coster.apply(i - 1, j - 1, D[i - 1][j - 1]), D[i - 1][j] + this.delete_d, D[i][j - 1] + this.insert_d);
            }
        }
        return D[n][m];
    }

    private double[][] initD(int n, int m) {
        double[][] D = new double[n + 1][m + 1];
        for (int i = 1; i <= n; ++i) {
            D[i][0] = D[i - 1][0] + this.delete_d;
        }
        for (int j = 1; j <= m; ++j) {
            D[0][j] = D[0][j - 1] + this.insert_d;
        }
        return D;
    }

    private double min(double m1, double m2, double m3) {
        if (m2 < m1) {
            m1 = m2;
        }
        return m3 < m1 ? m3 : m1;
    }

    @FunctionalInterface
    private static interface ChangeCost {
        public double apply(int var1, int var2, double var3);
    }
}

