/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.sequences.distance;

import java.util.Arrays;
import java.util.List;
import org.cicirello.sequences.distance.KendallTauRelabeler;
import org.cicirello.sequences.distance.RelabelByHashing;
import org.cicirello.sequences.distance.RelabelBySorting;
import org.cicirello.sequences.distance.SequenceDistanceMeasurer;

public final class KendallTauSequenceDistance
implements SequenceDistanceMeasurer {
    private final KendallTauRelabeler relabeler;

    public KendallTauSequenceDistance() {
        this(false);
    }

    public KendallTauSequenceDistance(boolean useAlternateAlg) {
        this.relabeler = useAlternateAlg ? new RelabelBySorting() : new RelabelByHashing();
    }

    @Override
    public int distance(int[] s1, int[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.length == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.length][2];
        int numLabels = this.relabeler.relabel(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping, 0, mapping.length - 1);
    }

    @Override
    public int distance(long[] s1, long[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.length == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.length][2];
        int numLabels = this.relabeler.relabel(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping, 0, mapping.length - 1);
    }

    @Override
    public int distance(short[] s1, short[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.length == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.length][2];
        int numLabels = this.relabeler.relabel(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping, 0, mapping.length - 1);
    }

    @Override
    public int distance(byte[] s1, byte[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.length == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.length][2];
        int numLabels = this.relabeler.relabel(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping, 0, mapping.length - 1);
    }

    @Override
    public int distance(char[] s1, char[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.length == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.length][2];
        int numLabels = this.relabeler.relabel(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping, 0, mapping.length - 1);
    }

    @Override
    public int distance(String s1, String s2) {
        if (s1.length() != s2.length()) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.length() == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.length()][2];
        int numLabels = this.relabeler.relabel(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping, 0, mapping.length - 1);
    }

    @Override
    public int distance(float[] s1, float[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.length == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.length][2];
        int numLabels = this.relabeler.relabel(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping, 0, mapping.length - 1);
    }

    @Override
    public int distance(double[] s1, double[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.length == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.length][2];
        int numLabels = this.relabeler.relabel(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping, 0, mapping.length - 1);
    }

    @Override
    public int distance(boolean[] s1, boolean[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.length == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.length][2];
        int numLabels = this.relabeler.relabel(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping, 0, mapping.length - 1);
    }

    @Override
    public int distance(Object[] s1, Object[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.length == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.length][2];
        int numLabels = this.relabeler.relabel(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping, 0, mapping.length - 1);
    }

    @Override
    public <T> int distance(List<T> s1, List<T> s2) {
        if (s1.size() != s2.size()) {
            throw new IllegalArgumentException("Sequences must be same length for Kendall Tau distance.");
        }
        if (s1.size() == 0) {
            return 0;
        }
        int[][] relabeling = new int[s1.size()][2];
        int numLabels = this.relabeler.relabel(s1, s2, relabeling);
        Bucket[][] buckets = this.bucketSortElements(relabeling, numLabels);
        int[] mapping = this.mapElements(buckets, relabeling.length);
        return this.countInversions(mapping, 0, mapping.length - 1);
    }

    private int[] mapElements(Bucket[][] buckets, int seqLength) {
        int[] mapping = new int[seqLength];
        for (int k = 0; k < buckets.length; ++k) {
            while (buckets[k][0].head != null) {
                int j;
                int i = buckets[k][0].remove();
                if (buckets[k][1].head == null) {
                    throw new IllegalArgumentException("Sequences must contain same elements.");
                }
                mapping[i] = j = buckets[k][1].remove();
            }
            if (buckets[k][1].head == null) continue;
            throw new IllegalArgumentException("Sequences must contain same elements.");
        }
        return mapping;
    }

    private Bucket[][] bucketSortElements(int[][] relabeling, int numLabels) {
        int i;
        Bucket[][] buckets = new Bucket[numLabels][2];
        for (i = 0; i < numLabels; ++i) {
            buckets[i][0] = new Bucket();
            buckets[i][1] = new Bucket();
        }
        for (i = 0; i < relabeling.length; ++i) {
            buckets[relabeling[i][0]][0].add(i);
            buckets[relabeling[i][1]][1].add(i);
        }
        return buckets;
    }

    private int countInversions(int[] array, int first, int last) {
        if (last <= first) {
            return 0;
        }
        int m = first + last >> 1;
        return this.countInversions(array, first, m) + this.countInversions(array, m + 1, last) + this.merge(array, first, m + 1, last + 1);
    }

    private int merge(int[] array, int first, int midPlus, int lastPlus) {
        int[] left = Arrays.copyOfRange(array, first, midPlus);
        int[] right = Arrays.copyOfRange(array, midPlus, lastPlus);
        int i = 0;
        int j = 0;
        int k = first;
        int count = 0;
        while (i < left.length && j < right.length) {
            if (left[i] <= right[j]) {
                array[k] = left[i];
                ++i;
                ++k;
                continue;
            }
            count += left.length - i;
            array[k] = right[j];
            ++j;
            ++k;
        }
        int size = left.length - i;
        System.arraycopy(left, i, array, k, size);
        System.arraycopy(right, j, array, k + size, right.length - j);
        return count;
    }

    private static final class Bucket {
        Node head;
        Node tail;

        private Bucket() {
        }

        void add(int value) {
            if (this.head == null) {
                this.head = this.tail = new Node(value);
            } else {
                this.tail = this.tail.next = new Node(value);
            }
        }

        int remove() {
            int v = this.head.value;
            this.head = this.head.next;
            if (this.head == null) {
                this.tail = null;
            }
            return v;
        }

        static final class Node {
            int value;
            Node next;

            Node(int value) {
                this.value = value;
            }
        }
    }
}

