/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.sequences;

import java.util.random.RandomGenerator;
import org.cicirello.math.rand.RandomVariates;
import org.cicirello.sequences.SequenceInsertionSampler;
import org.cicirello.sequences.SequencePoolSampler;
import org.cicirello.sequences.SequenceReservoirSampler;
import org.cicirello.sequences.SequenceSampler;

public final class SequenceCompositeSampler
implements SequenceSampler {
    private final RandomGenerator r;

    public SequenceCompositeSampler(RandomGenerator r) {
        this.r = r;
    }

    @Override
    public int[] nextSample(int[] source, int k, int[] target) {
        return SequenceCompositeSampler.sample(source, k, target, this.r);
    }

    @Override
    public long[] nextSample(long[] source, int k, long[] target) {
        return SequenceCompositeSampler.sample(source, k, target, this.r);
    }

    @Override
    public short[] nextSample(short[] source, int k, short[] target) {
        return SequenceCompositeSampler.sample(source, k, target, this.r);
    }

    @Override
    public byte[] nextSample(byte[] source, int k, byte[] target) {
        return SequenceCompositeSampler.sample(source, k, target, this.r);
    }

    @Override
    public double[] nextSample(double[] source, int k, double[] target) {
        return SequenceCompositeSampler.sample(source, k, target, this.r);
    }

    @Override
    public float[] nextSample(float[] source, int k, float[] target) {
        return SequenceCompositeSampler.sample(source, k, target, this.r);
    }

    @Override
    public char[] nextSample(char[] source, int k, char[] target) {
        return SequenceCompositeSampler.sample(source, k, target, this.r);
    }

    @Override
    public char[] nextSample(String source, int k, char[] target) {
        return SequenceCompositeSampler.sample(source, k, target, this.r);
    }

    @Override
    public <T> T[] nextSample(T[] source, int k, T[] target) {
        return SequenceCompositeSampler.sample(source, k, target, this.r);
    }

    public static int[] sample(int[] source, double p, RandomGenerator r) {
        return SequenceCompositeSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null, r);
    }

    public static long[] sample(long[] source, double p, RandomGenerator r) {
        return SequenceCompositeSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null, r);
    }

    public static short[] sample(short[] source, double p, RandomGenerator r) {
        return SequenceCompositeSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null, r);
    }

    public static byte[] sample(byte[] source, double p, RandomGenerator r) {
        return SequenceCompositeSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null, r);
    }

    public static double[] sample(double[] source, double p, RandomGenerator r) {
        return SequenceCompositeSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null, r);
    }

    public static float[] sample(float[] source, double p, RandomGenerator r) {
        return SequenceCompositeSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null, r);
    }

    public static char[] sample(char[] source, double p, RandomGenerator r) {
        return SequenceCompositeSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null, r);
    }

    public static char[] sample(String source, double p, RandomGenerator r) {
        return SequenceCompositeSampler.sample(source, RandomVariates.nextBinomial((int)source.length(), (double)p), null, r);
    }

    public static <T> T[] sample(T[] source, double p, RandomGenerator r) {
        return SequenceCompositeSampler.sample(source, RandomVariates.nextBinomial((int)source.length, (double)p), null, r);
    }

    public static int[] sample(int[] source, int k, int[] target, RandomGenerator r) {
        if (k + k < source.length) {
            if (k * k < source.length) {
                return SequenceInsertionSampler.sample(source, k, target, r);
            }
            return SequencePoolSampler.sample(source, k, target, r);
        }
        return SequenceReservoirSampler.sample(source, k, target, r);
    }

    public static long[] sample(long[] source, int k, long[] target, RandomGenerator r) {
        if (k + k < source.length) {
            if (k * k < source.length) {
                return SequenceInsertionSampler.sample(source, k, target, r);
            }
            return SequencePoolSampler.sample(source, k, target, r);
        }
        return SequenceReservoirSampler.sample(source, k, target, r);
    }

    public static short[] sample(short[] source, int k, short[] target, RandomGenerator r) {
        if (k + k < source.length) {
            if (k * k < source.length) {
                return SequenceInsertionSampler.sample(source, k, target, r);
            }
            return SequencePoolSampler.sample(source, k, target, r);
        }
        return SequenceReservoirSampler.sample(source, k, target, r);
    }

    public static byte[] sample(byte[] source, int k, byte[] target, RandomGenerator r) {
        if (k + k < source.length) {
            if (k * k < source.length) {
                return SequenceInsertionSampler.sample(source, k, target, r);
            }
            return SequencePoolSampler.sample(source, k, target, r);
        }
        return SequenceReservoirSampler.sample(source, k, target, r);
    }

    public static char[] sample(char[] source, int k, char[] target, RandomGenerator r) {
        if (k + k < source.length) {
            if (k * k < source.length) {
                return SequenceInsertionSampler.sample(source, k, target, r);
            }
            return SequencePoolSampler.sample(source, k, target, r);
        }
        return SequenceReservoirSampler.sample(source, k, target, r);
    }

    public static char[] sample(String source, int k, char[] target, RandomGenerator r) {
        return SequenceCompositeSampler.sample(source.toCharArray(), k, target, r);
    }

    public static double[] sample(double[] source, int k, double[] target, RandomGenerator r) {
        if (k + k < source.length) {
            if (k * k < source.length) {
                return SequenceInsertionSampler.sample(source, k, target, r);
            }
            return SequencePoolSampler.sample(source, k, target, r);
        }
        return SequenceReservoirSampler.sample(source, k, target, r);
    }

    public static float[] sample(float[] source, int k, float[] target, RandomGenerator r) {
        if (k + k < source.length) {
            if (k * k < source.length) {
                return SequenceInsertionSampler.sample(source, k, target, r);
            }
            return SequencePoolSampler.sample(source, k, target, r);
        }
        return SequenceReservoirSampler.sample(source, k, target, r);
    }

    public static <T> T[] sample(T[] source, int k, T[] target, RandomGenerator r) {
        if (k + k < source.length) {
            if (k * k < source.length) {
                return SequenceInsertionSampler.sample(source, k, target, r);
            }
            return SequencePoolSampler.sample(source, k, target, r);
        }
        return SequenceReservoirSampler.sample(source, k, target, r);
    }
}

