/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.ds;

import java.util.HashMap;

public final class DisjointSetForest<T> {
    private final HashMap<T, Node> nodes = new HashMap();
    private int size;

    public boolean contains(T element) {
        return this.nodes.containsKey(element);
    }

    public int findSet(T element) {
        Node node = this.nodes.get(element);
        if (node == null) {
            throw new IllegalArgumentException("Element not in disjoint set forest: " + element.toString());
        }
        return this.findSet((Node)node).id;
    }

    public void makeSet(T element) {
        if (this.nodes.containsKey(element)) {
            throw new IllegalArgumentException("Already contains this element: " + element.toString());
        }
        this.nodes.put(element, new Node());
    }

    public boolean sameSet(T element1, T element2) {
        Node node1 = this.nodes.get(element1);
        if (node1 == null) {
            return false;
        }
        Node node2 = this.nodes.get(element2);
        if (node2 == null) {
            return false;
        }
        return this.findSet(node1) == this.findSet(node2);
    }

    public int size() {
        return this.size;
    }

    public void union(T element1, T element2) {
        Node x = this.nodes.get(element1);
        Node y = this.nodes.get(element2);
        if (x == null || y == null) {
            throw new IllegalArgumentException("One or both of the elements does not exist.");
        }
        this.link(this.findSet(x), this.findSet(y));
    }

    private Node findSet(Node node) {
        if (node.parent != node) {
            node.parent = this.findSet(node.parent);
        }
        return node.parent;
    }

    private void link(Node x, Node y) {
        if (x.rank > y.rank) {
            y.parent = x;
        } else {
            x.parent = y;
            if (x.rank == y.rank) {
                ++y.rank;
            }
        }
    }

    private class Node {
        private int rank;
        private Node parent = this;
        private final int id;

        private Node() {
            this.id = DisjointSetForest.this.size++;
        }
    }
}

