/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations.distance;

import java.util.Arrays;
import org.cicirello.permutations.Permutation;
import org.cicirello.permutations.distance.NormalizedPermutationDistanceMeasurerDouble;

public final class WeightedKendallTauDistance
implements NormalizedPermutationDistanceMeasurerDouble {
    private final double[] weights;
    private final double maxDistance;

    public WeightedKendallTauDistance(double[] weights) {
        this.weights = (double[])weights.clone();
        double max = 0.0;
        for (int i = 0; i < weights.length - 1; ++i) {
            double runningSum = 0.0;
            for (int j = i + 1; j < weights.length; ++j) {
                runningSum += weights[j];
            }
            max += weights[i] * runningSum;
        }
        this.maxDistance = max;
    }

    public int supportedLength() {
        return this.weights.length;
    }

    @Override
    public double distancef(Permutation p1, Permutation p2) {
        if (p1.length() != this.weights.length || p2.length() != this.weights.length) {
            throw new IllegalArgumentException("p1 and/or p2 not of supported length of this instance");
        }
        int[] invP1 = p1.getInverse();
        int[] arrayP2 = new int[invP1.length];
        double[] w = new double[this.weights.length];
        for (int i = 0; i < arrayP2.length; ++i) {
            arrayP2[i] = invP1[p2.get(i)];
            w[arrayP2[i]] = this.weights[p2.get(i)];
        }
        return this.countWeightedInversions(arrayP2, w, 0, arrayP2.length - 1);
    }

    @Override
    public double maxf(int length) {
        return this.maxDistance;
    }

    private double countWeightedInversions(int[] array, double[] w, int first, int last) {
        if (last <= first) {
            return 0.0;
        }
        int m = first + last >> 1;
        return this.countWeightedInversions(array, w, first, m) + this.countWeightedInversions(array, w, m + 1, last) + this.merge(array, w, first, m + 1, last + 1);
    }

    private double merge(int[] array, double[] w, int first, int midPlus, int lastPlus) {
        int[] left = Arrays.copyOfRange(array, first, midPlus);
        int[] right = Arrays.copyOfRange(array, midPlus, lastPlus);
        int i = 0;
        int j = 0;
        int k = first;
        double weightedCount = 0.0;
        double leftWeights = 0.0;
        for (int x = 0; x < left.length; ++x) {
            leftWeights += w[left[x]];
        }
        while (i < left.length && j < right.length) {
            if (left[i] < right[j]) {
                leftWeights -= w[left[i]];
                array[k] = left[i];
                ++i;
                ++k;
                continue;
            }
            weightedCount += w[right[j]] * leftWeights;
            array[k] = right[j];
            ++j;
            ++k;
        }
        System.arraycopy(left, i, array, k, left.length - i);
        System.arraycopy(right, j, array, k, right.length - j);
        return weightedCount;
    }
}

