/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.ds;

import java.util.Arrays;
import org.cicirello.util.Copyable;

public final class DisjointIntegerSetForest
implements Copyable<DisjointIntegerSetForest> {
    private final int[] rank;
    private final int[] parent;

    public DisjointIntegerSetForest(int n) {
        this.rank = new int[n];
        this.parent = new int[n];
        for (int i = 0; i < n; ++i) {
            this.parent[i] = i;
        }
    }

    private DisjointIntegerSetForest(DisjointIntegerSetForest other) {
        this.rank = (int[])other.rank.clone();
        this.parent = (int[])other.parent.clone();
    }

    @Override
    public DisjointIntegerSetForest copy() {
        return new DisjointIntegerSetForest(this);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof DisjointIntegerSetForest) {
            DisjointIntegerSetForest casted = (DisjointIntegerSetForest)other;
            return Arrays.equals(this.rank, casted.rank) && Arrays.equals(this.parent, casted.parent);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.rank) * 31 + Arrays.hashCode(this.parent);
    }

    public int findSet(int element) {
        if (this.parent[element] != element) {
            this.parent[element] = this.findSet(this.parent[element]);
        }
        return this.parent[element];
    }

    public boolean sameSet(int element1, int element2) {
        return this.findSet(element1) == this.findSet(element2);
    }

    public int size() {
        return this.rank.length;
    }

    public void union(int element1, int element2) {
        this.link(this.findSet(element1), this.findSet(element2));
    }

    private void link(int x, int y) {
        if (this.rank[x] > this.rank[y]) {
            this.parent[y] = x;
        } else {
            this.parent[x] = y;
            if (this.rank[x] == this.rank[y]) {
                int n = y;
                this.rank[n] = this.rank[n] + 1;
            }
        }
    }
}

