/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.cicirello.permutations.Permutation;
import org.cicirello.util.ArrayFiller;

public class PermutationIterator
implements Iterator<Permutation> {
    private final Permutation p;
    private final int[] lastSwap;
    private boolean done;

    public PermutationIterator(int n) {
        this(new Permutation(n));
    }

    public PermutationIterator(Permutation p) {
        this.p = new Permutation(p);
        this.lastSwap = ArrayFiller.create(p.length());
        this.done = false;
    }

    @Override
    public boolean hasNext() {
        return !this.done;
    }

    @Override
    public Permutation next() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        Permutation n = new Permutation(this.p);
        if (this.lastSwap.length <= 1) {
            this.done = true;
        } else {
            for (int i = this.lastSwap.length - 2; i >= 0; --i) {
                if (this.lastSwap[i] != i) {
                    this.p.internalSwap(i, this.lastSwap[i]);
                }
                if (this.lastSwap[i] == this.lastSwap.length - 1) {
                    this.lastSwap[i] = i;
                    if (i != 0) continue;
                    this.done = true;
                    continue;
                }
                int n2 = i;
                this.lastSwap[n2] = this.lastSwap[n2] + 1;
                this.p.internalSwap(i, this.lastSwap[i]);
                break;
            }
        }
        return n;
    }
}

