/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations.distance;

import java.util.Arrays;
import org.cicirello.permutations.Permutation;
import org.cicirello.permutations.distance.NormalizedPermutationDistanceMeasurer;

public final class KendallTauDistance
implements NormalizedPermutationDistanceMeasurer {
    @Override
    public int distance(Permutation p1, Permutation p2) {
        if (p1.length() != p2.length()) {
            throw new IllegalArgumentException("Permutations must be the same length");
        }
        int[] invP1 = p1.getInverse();
        int[] arrayP2 = new int[invP1.length];
        for (int i = 0; i < arrayP2.length; ++i) {
            arrayP2[i] = invP1[p2.get(i)];
        }
        return this.countInversions(arrayP2, 0, arrayP2.length - 1);
    }

    @Override
    public int max(int length) {
        if (length <= 1) {
            return 0;
        }
        return length * (length - 1) >> 1;
    }

    private int countInversions(int[] array, int first, int last) {
        if (last <= first) {
            return 0;
        }
        int m = first + last >> 1;
        return this.countInversions(array, first, m) + this.countInversions(array, m + 1, last) + this.merge(array, first, m + 1, last + 1);
    }

    private int merge(int[] array, int first, int midPlus, int lastPlus) {
        int[] left = Arrays.copyOfRange(array, first, midPlus);
        int[] right = Arrays.copyOfRange(array, midPlus, lastPlus);
        int i = 0;
        int j = 0;
        int k = first;
        int count = 0;
        while (i < left.length && j < right.length) {
            if (left[i] < right[j]) {
                array[k] = left[i];
                ++i;
                ++k;
                continue;
            }
            count += left.length - i;
            array[k] = right[j];
            ++j;
            ++k;
        }
        System.arraycopy(left, i, array, k, left.length - i);
        System.arraycopy(right, j, array, k, right.length - j);
        return count;
    }
}

