/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations.distance;

import org.cicirello.permutations.Permutation;
import org.cicirello.permutations.distance.PermutationDistanceMeasurer;

public final class CyclicReversalIndependentDistance
implements PermutationDistanceMeasurer {
    private PermutationDistanceMeasurer d;

    public CyclicReversalIndependentDistance(PermutationDistanceMeasurer d) {
        this.d = d;
    }

    @Override
    public int distance(Permutation p1, Permutation p2) {
        int result = this.d.distance(p1, p2);
        if (result > 0) {
            Permutation reverse2 = new Permutation(p2);
            reverse2.reverse();
            result = Math.min(result, this.d.distance(p1, reverse2));
            if (result > 0) {
                int L = reverse2.length();
                for (int i = 0; i < L && result > 0; ++i) {
                    reverse2.rotate(1);
                    result = Math.min(result, this.d.distance(p1, reverse2));
                }
            }
            if (result > 0) {
                Permutation pCopy = new Permutation(p2);
                int L = pCopy.length();
                for (int i = 0; i < L && result > 0; ++i) {
                    pCopy.rotate(1);
                    result = Math.min(result, this.d.distance(p1, pCopy));
                }
            }
        }
        return result;
    }
}

