/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.sequences;

import java.util.concurrent.ThreadLocalRandom;
import java.util.random.RandomGenerator;
import org.cicirello.math.rand.RandomVariates;
import org.cicirello.sequences.SequenceCompositeSampler;

public interface SequenceSampler {
    public int[] nextSample(int[] var1, int var2, int[] var3);

    public short[] nextSample(short[] var1, int var2, short[] var3);

    public long[] nextSample(long[] var1, int var2, long[] var3);

    public byte[] nextSample(byte[] var1, int var2, byte[] var3);

    public char[] nextSample(char[] var1, int var2, char[] var3);

    public char[] nextSample(String var1, int var2, char[] var3);

    public double[] nextSample(double[] var1, int var2, double[] var3);

    public float[] nextSample(float[] var1, int var2, float[] var3);

    public <T> T[] nextSample(T[] var1, int var2, T[] var3);

    default public int[] nextSample(int[] source, double p) {
        return this.nextSample(source, RandomVariates.nextBinomial(source.length, p), (int[])null);
    }

    default public long[] nextSample(long[] source, double p) {
        return this.nextSample(source, RandomVariates.nextBinomial(source.length, p), (long[])null);
    }

    default public short[] nextSample(short[] source, double p) {
        return this.nextSample(source, RandomVariates.nextBinomial(source.length, p), (short[])null);
    }

    default public byte[] nextSample(byte[] source, double p) {
        return this.nextSample(source, RandomVariates.nextBinomial(source.length, p), (byte[])null);
    }

    default public double[] nextSample(double[] source, double p) {
        return this.nextSample(source, RandomVariates.nextBinomial(source.length, p), (double[])null);
    }

    default public float[] nextSample(float[] source, double p) {
        return this.nextSample(source, RandomVariates.nextBinomial(source.length, p), (float[])null);
    }

    default public char[] nextSample(char[] source, double p) {
        return this.nextSample(source, RandomVariates.nextBinomial(source.length, p), (char[])null);
    }

    default public char[] nextSample(String source, double p) {
        return this.nextSample(source, RandomVariates.nextBinomial(source.length(), p), null);
    }

    default public <T> T[] nextSample(T[] source, double p) {
        return this.nextSample(source, RandomVariates.nextBinomial(source.length, p), null);
    }

    public static byte[] sample(byte[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null);
    }

    public static char[] sample(char[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null);
    }

    public static double[] sample(double[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null);
    }

    public static float[] sample(float[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null);
    }

    public static int[] sample(int[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null);
    }

    public static long[] sample(long[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null);
    }

    public static short[] sample(short[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null);
    }

    public static char[] sample(String source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial(source.length(), p), null);
    }

    public static <T> T[] sample(T[] source, double p) {
        return SequenceSampler.sample(source, RandomVariates.nextBinomial(source.length, p), null);
    }

    public static int[] sample(int[] source, int k, int[] target) {
        return SequenceCompositeSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static long[] sample(long[] source, int k, long[] target) {
        return SequenceCompositeSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static short[] sample(short[] source, int k, short[] target) {
        return SequenceCompositeSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static byte[] sample(byte[] source, int k, byte[] target) {
        return SequenceCompositeSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static char[] sample(char[] source, int k, char[] target) {
        return SequenceCompositeSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static char[] sample(String source, int k, char[] target) {
        return SequenceCompositeSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static double[] sample(double[] source, int k, double[] target) {
        return SequenceCompositeSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static float[] sample(float[] source, int k, float[] target) {
        return SequenceCompositeSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }

    public static <T> T[] sample(T[] source, int k, T[] target) {
        return SequenceCompositeSampler.sample(source, k, target, (RandomGenerator)ThreadLocalRandom.current());
    }
}

