/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations.distance;

import org.cicirello.permutations.Permutation;
import org.cicirello.permutations.distance.NormalizedPermutationDistanceMeasurer;

public final class CyclicRTypeDistance
implements NormalizedPermutationDistanceMeasurer {
    @Override
    public int distance(Permutation p1, Permutation p2) {
        int i;
        if (p1.length() != p2.length()) {
            throw new IllegalArgumentException("Permutations must be the same length");
        }
        int countNonSharedEdges = 0;
        int[] successors2 = new int[p2.length()];
        for (i = 0; i < successors2.length; ++i) {
            successors2[p2.get((int)i)] = p2.get(this.indexCyclicAdjustment(i + 1, successors2.length));
        }
        for (i = 0; i < successors2.length; ++i) {
            if (p1.get(this.indexCyclicAdjustment(i + 1, successors2.length)) == successors2[p1.get(i)]) continue;
            ++countNonSharedEdges;
        }
        return countNonSharedEdges;
    }

    @Override
    public int max(int length) {
        if (length <= 2) {
            return 0;
        }
        return length;
    }

    private int indexCyclicAdjustment(int i, int length) {
        return i < length ? i : 0;
    }
}

