/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.ds;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.cicirello.ds.FibonacciHeapDoubleNode;
import org.cicirello.ds.MaxOrder;
import org.cicirello.ds.MergeablePriorityQueueDouble;
import org.cicirello.ds.MinOrder;
import org.cicirello.ds.Prioritizer;
import org.cicirello.ds.PriorityQueueNode;
import org.cicirello.util.Copyable;

public final class SimpleFibonacciHeapDouble<E>
implements MergeablePriorityQueueDouble<E, SimpleFibonacciHeapDouble<E>>,
Copyable<SimpleFibonacciHeapDouble<E>> {
    private final Prioritizer compare;
    private final double extreme;
    private int size;
    private FibonacciHeapDoubleNode<E> min;
    private final FibonacciHeapDoubleNode.Consolidator<E> consolidator;

    SimpleFibonacciHeapDouble(Prioritizer compare) {
        this.compare = compare;
        this.extreme = compare.comesBefore(0, 1) ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        this.consolidator = new FibonacciHeapDoubleNode.Consolidator(compare);
    }

    private SimpleFibonacciHeapDouble(Collection<PriorityQueueNode.Double<E>> initialElements, Prioritizer compare) {
        this(compare);
        for (PriorityQueueNode.Double<E> element : initialElements) {
            this.internalOffer((PriorityQueueNode.Double<E>)element.copy());
        }
    }

    SimpleFibonacciHeapDouble(SimpleFibonacciHeapDouble<E> other) {
        this(other.compare);
        this.size = other.size;
        this.min = other.min != null ? other.min.copy() : null;
    }

    @Override
    public SimpleFibonacciHeapDouble<E> copy() {
        return new SimpleFibonacciHeapDouble<E>(this);
    }

    public static <E> SimpleFibonacciHeapDouble<E> createMinHeap() {
        return new SimpleFibonacciHeapDouble<E>(new MinOrder());
    }

    public static <E> SimpleFibonacciHeapDouble<E> createMinHeap(Collection<PriorityQueueNode.Double<E>> initialElements) {
        return new SimpleFibonacciHeapDouble<E>(initialElements, new MinOrder());
    }

    public static <E> SimpleFibonacciHeapDouble<E> createMaxHeap() {
        return new SimpleFibonacciHeapDouble<E>(new MaxOrder());
    }

    public static <E> SimpleFibonacciHeapDouble<E> createMaxHeap(Collection<PriorityQueueNode.Double<E>> initialElements) {
        return new SimpleFibonacciHeapDouble<E>(initialElements, new MaxOrder());
    }

    @Override
    public boolean change(E element, double priority) {
        FibonacciHeapDoubleNode<E> node = FibonacciHeapDoubleNode.find(this.min, element);
        if (node != null) {
            if (this.compare.comesBefore(priority, node.e.value)) {
                this.internalPromote(node, priority);
                return true;
            }
            if (this.compare.comesBefore(node.e.value, priority)) {
                this.internalDemote(node, priority);
                return true;
            }
            return false;
        }
        return this.offer(element, priority);
    }

    @Override
    public void clear() {
        this.size = 0;
        this.min = null;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof PriorityQueueNode.Double) {
            PriorityQueueNode.Double pair = (PriorityQueueNode.Double)o;
            return FibonacciHeapDoubleNode.find(this.min, pair.element) != null;
        }
        return FibonacciHeapDoubleNode.find(this.min, o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        HashSet<Object> containsThese = new HashSet<Object>();
        for (PriorityQueueNode.Double<E> e : this) {
            containsThese.add(e.element);
        }
        for (PriorityQueueNode.Double<Object> o : c) {
            if (o instanceof PriorityQueueNode.Double) {
                PriorityQueueNode.Double<Object> pair = o;
                if (containsThese.contains(pair.element)) continue;
                return false;
            }
            if (containsThese.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean demote(E element, double priority) {
        FibonacciHeapDoubleNode<E> node = FibonacciHeapDoubleNode.find(this.min, element);
        if (node != null && this.compare.comesBefore(node.e.value, priority)) {
            this.internalDemote(node, priority);
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof SimpleFibonacciHeapDouble) {
            SimpleFibonacciHeapDouble casted = (SimpleFibonacciHeapDouble)other;
            if (this.size != casted.size) {
                return false;
            }
            if (this.compare.comesBefore(0, 1) != casted.compare.comesBefore(0, 1)) {
                return false;
            }
            Iterator<PriorityQueueNode.Double<E>> iter = this.iterator();
            Iterator<PriorityQueueNode.Double<E>> otherIter = casted.iterator();
            while (iter.hasNext()) {
                if (iter.next().equals(otherIter.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (PriorityQueueNode.Double<E> e : this) {
            h = 31 * h + Double.hashCode(e.value);
            h = 31 * h + e.element.hashCode();
        }
        return h;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<PriorityQueueNode.Double<E>> iterator() {
        return new FibonacciHeapDoubleNode.FibonacciHeapDoubleIterator<E>(this.min);
    }

    @Override
    public boolean merge(SimpleFibonacciHeapDouble<E> other) {
        if (this.compare.comesBefore(0, 1) != other.compare.comesBefore(0, 1)) {
            throw new IllegalArgumentException("this and other follow different priority-order");
        }
        if (other.size > 0) {
            other.min.insertListInto(this.min);
            if (this.compare.comesBefore(other.min.e.value, this.min.e.value)) {
                this.min = other.min;
            }
            this.size += other.size;
            other.clear();
            return true;
        }
        return false;
    }

    @Override
    public boolean offer(E element, double priority) {
        this.internalOffer(new PriorityQueueNode.Double<E>(element, priority));
        return true;
    }

    @Override
    public boolean offer(PriorityQueueNode.Double<E> pair) {
        this.internalOffer((PriorityQueueNode.Double<E>)pair.copy());
        return true;
    }

    @Override
    public E peekElement() {
        return (E)(this.min != null ? this.min.e.element : null);
    }

    @Override
    public PriorityQueueNode.Double<E> peek() {
        return this.min != null ? this.min.e : null;
    }

    @Override
    public double peekPriority() {
        return this.min != null ? this.min.e.value : this.extreme;
    }

    @Override
    public double peekPriority(E element) {
        FibonacciHeapDoubleNode<E> node = FibonacciHeapDoubleNode.find(this.min, element);
        return node != null ? node.e.value : this.extreme;
    }

    @Override
    public E pollElement() {
        Object min = this.poll();
        return (E)(min != null ? ((PriorityQueueNode.Double)min).element : null);
    }

    @Override
    public PriorityQueueNode.Double<E> poll() {
        if (this.size == 1) {
            PriorityQueueNode.Double pair = this.min.e;
            this.min = null;
            this.size = 0;
            return pair;
        }
        if (this.size > 1) {
            FibonacciHeapDoubleNode<E> z = this.min;
            this.min = this.min.removeSelf();
            this.min = this.consolidator.consolidate(this.min, this.size);
            --this.size;
            return z.e;
        }
        return null;
    }

    @Override
    public boolean promote(E element, double priority) {
        FibonacciHeapDoubleNode<E> node = FibonacciHeapDoubleNode.find(this.min, element);
        if (node != null && this.compare.comesBefore(priority, node.e.value)) {
            this.internalPromote(node, priority);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        FibonacciHeapDoubleNode<E> node = null;
        if (o instanceof PriorityQueueNode.Double) {
            PriorityQueueNode.Double pair = (PriorityQueueNode.Double)o;
            node = FibonacciHeapDoubleNode.find(this.min, pair.element);
        } else {
            node = FibonacciHeapDoubleNode.find(this.min, o);
        }
        if (node == null) {
            return false;
        }
        this.internalPromote(node, this.compare.comesBefore(this.min.e.value - 1.0, this.min.e.value) ? this.min.e.value - 1.0 : this.min.e.value + 1.0);
        this.poll();
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        HashSet<Object> discardThese = PriorityQueueNode.Double.toSet(c);
        ArrayList<PriorityQueueNode.Double<E>> keepList = new ArrayList<PriorityQueueNode.Double<E>>();
        for (PriorityQueueNode.Double<E> e : this) {
            if (discardThese.contains(e.element)) continue;
            keepList.add(e);
        }
        if (keepList.size() < this.size) {
            this.clear();
            for (PriorityQueueNode.Double<E> e : keepList) {
                this.internalOffer(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        HashSet<Object> keepThese = PriorityQueueNode.Double.toSet(c);
        ArrayList<PriorityQueueNode.Double<E>> keepList = new ArrayList<PriorityQueueNode.Double<E>>(keepThese.size());
        for (PriorityQueueNode.Double<E> e : this) {
            if (!keepThese.contains(e.element)) continue;
            keepList.add(e);
        }
        if (keepList.size() < this.size) {
            this.clear();
            for (PriorityQueueNode.Double<E> e : keepList) {
                this.internalOffer(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size];
        int i = 0;
        Iterator<PriorityQueueNode.Double<E>> iterator = this.iterator();
        while (iterator.hasNext()) {
            PriorityQueueNode.Double<E> e;
            array[i] = e = iterator.next();
            ++i;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        T[] result = array.length >= this.size ? array : (Object[])Array.newInstance(array.getClass().getComponentType(), this.size);
        int i = 0;
        Iterator<PriorityQueueNode.Double<E>> iterator = this.iterator();
        while (iterator.hasNext()) {
            PriorityQueueNode.Double<E> e;
            PriorityQueueNode.Double<E> nextElement = e = iterator.next();
            result[i] = nextElement;
            ++i;
        }
        if (result.length > this.size) {
            result[this.size] = null;
        }
        return result;
    }

    private void internalOffer(PriorityQueueNode.Double<E> pair) {
        if (this.min == null) {
            this.min = new FibonacciHeapDoubleNode<E>(pair);
            this.size = 1;
        } else {
            FibonacciHeapDoubleNode<E> added = new FibonacciHeapDoubleNode<E>(pair, this.min);
            if (this.compare.comesBefore(pair.value, this.min.e.value)) {
                this.min = added;
            }
            ++this.size;
        }
    }

    private void internalPromote(FibonacciHeapDoubleNode<E> x, double priority) {
        x.e.value = priority;
        FibonacciHeapDoubleNode<E> y = x.parent();
        if (y != null && this.compare.comesBefore(priority, y.e.value)) {
            x.cut(y, this.min);
            y.cascadingCut(this.min);
        }
        if (this.compare.comesBefore(priority, this.min.e.value)) {
            this.min = x;
        }
    }

    private void internalDemote(FibonacciHeapDoubleNode<E> x, double priority) {
        this.internalPromote(x, this.compare.comesBefore(this.min.e.value - 1.0, this.min.e.value) ? this.min.e.value - 1.0 : this.min.e.value + 1.0);
        this.poll();
        x.e.value = priority;
        this.internalOffer(x.e);
    }
}

