/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.permutations;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.random.RandomGenerator;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.permutations.IllegalPermutationStateException;
import org.cicirello.permutations.PermutationBinaryOperator;
import org.cicirello.permutations.PermutationFullBinaryOperator;
import org.cicirello.permutations.PermutationFullUnaryOperator;
import org.cicirello.permutations.PermutationIterator;
import org.cicirello.permutations.PermutationUnaryOperator;
import org.cicirello.util.ArrayFiller;
import org.cicirello.util.Copyable;

public final class Permutation
implements Serializable,
Iterable<Permutation>,
Copyable<Permutation> {
    private static final long serialVersionUID = 2L;
    private final int[] permutation;
    private transient int hashCode;
    private transient boolean hashCodeIsCached;

    public Permutation(int n) {
        this.permutation = new int[n];
        this.scramble();
    }

    public Permutation(int n, RandomGenerator r) {
        this.permutation = new int[n];
        this.scramble(r);
    }

    public Permutation(int n, int value) {
        this.permutation = ArrayFiller.create(n);
        for (int i = 0; i < n - 1; ++i) {
            int j = i + value % (n - i);
            int temp = this.permutation[j];
            System.arraycopy(this.permutation, i, this.permutation, i + 1, j - i);
            this.permutation[i] = temp;
            value /= n - i;
        }
    }

    public Permutation(int n, BigInteger value) {
        this.permutation = ArrayFiller.create(n);
        for (int i = 0; i < n - 1; ++i) {
            BigInteger[] divRem = value.divideAndRemainder(BigInteger.valueOf(n - i));
            int j = i + divRem[1].intValue();
            int temp = this.permutation[j];
            System.arraycopy(this.permutation, i, this.permutation, i + 1, j - i);
            this.permutation[i] = temp;
            value = divRem[0];
        }
    }

    public Permutation(int[] p) {
        this(p, true);
    }

    private Permutation(int[] p, boolean validate) {
        if (validate) {
            this.validate(p);
        }
        this.permutation = (int[])p.clone();
    }

    public Permutation(Permutation p) {
        this.permutation = (int[])p.permutation.clone();
        this.hashCodeIsCached = p.hashCodeIsCached;
        this.hashCode = p.hashCode;
    }

    public Permutation(Permutation p, int length) {
        if (length >= p.permutation.length) {
            this.permutation = (int[])p.permutation.clone();
        } else if (length <= 0) {
            this.permutation = new int[0];
        } else {
            this.permutation = new int[length];
            int k = 0;
            for (int i = 0; i < p.permutation.length && k < length; ++i) {
                if (p.permutation[i] >= length) continue;
                this.permutation[k] = p.permutation[i];
                ++k;
            }
        }
    }

    public void apply(PermutationUnaryOperator operator) {
        operator.apply(this.permutation);
        this.hashCodeIsCached = false;
    }

    public void apply(PermutationFullUnaryOperator operator) {
        operator.apply(this.permutation, this);
        this.hashCodeIsCached = false;
    }

    public void apply(PermutationBinaryOperator operator, Permutation other) {
        operator.apply(this.permutation, other.permutation);
        this.hashCodeIsCached = false;
        other.hashCodeIsCached = false;
    }

    public void apply(PermutationFullBinaryOperator operator, Permutation other) {
        operator.apply(this.permutation, other.permutation, this, other);
        this.hashCodeIsCached = false;
        other.hashCodeIsCached = false;
    }

    public void applyThenValidate(PermutationUnaryOperator operator) {
        try {
            operator.apply(this.permutation);
            this.hashCodeIsCached = false;
            this.validate(this.permutation);
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalPermutationStateException("Internal state of the Permutation is illegal.", exception);
        }
    }

    public void applyThenValidate(PermutationFullUnaryOperator operator) {
        try {
            operator.apply(this.permutation, this);
            this.hashCodeIsCached = false;
            this.validate(this.permutation);
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalPermutationStateException("Internal state of the Permutation is illegal.", exception);
        }
    }

    public void applyThenValidate(PermutationBinaryOperator operator, Permutation other) {
        try {
            operator.apply(this.permutation, other.permutation);
            this.hashCodeIsCached = false;
            other.hashCodeIsCached = false;
            this.validate(this.permutation);
            this.validate(other.permutation);
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalPermutationStateException("Internal state of the Permutation is illegal.", exception);
        }
    }

    public void applyThenValidate(PermutationFullBinaryOperator operator, Permutation other) {
        try {
            operator.apply(this.permutation, other.permutation, this, other);
            this.hashCodeIsCached = false;
            other.hashCodeIsCached = false;
            this.validate(this.permutation);
            this.validate(other.permutation);
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalPermutationStateException("Internal state of the Permutation is illegal.", exception);
        }
    }

    @Override
    public Permutation copy() {
        return new Permutation(this);
    }

    public int toInteger() {
        if (this.permutation.length > 12) {
            throw new UnsupportedOperationException("Unsupported for permutations of length greater than 12.");
        }
        int[] index = ArrayFiller.create(this.permutation.length);
        int result = 0;
        int multiplier = 1;
        int factor = this.permutation.length;
        for (int i = 0; i < index.length - 1; ++i) {
            result += multiplier * index[this.permutation[i]];
            int j = this.permutation[i];
            while (j < index.length) {
                int n = j++;
                index[n] = index[n] - 1;
            }
            multiplier *= factor;
            --factor;
        }
        return result;
    }

    public BigInteger toBigInteger() {
        if (this.permutation.length <= 12) {
            return BigInteger.valueOf(this.toInteger());
        }
        int[] index = ArrayFiller.create(this.permutation.length);
        BigInteger result = BigInteger.ZERO;
        BigInteger multiplier = BigInteger.ONE;
        int factor = this.permutation.length;
        for (int i = 0; i < index.length - 1; ++i) {
            result = result.add(multiplier.multiply(BigInteger.valueOf(index[this.permutation[i]])));
            int j = this.permutation[i];
            while (j < index.length) {
                int n = j++;
                index[n] = index[n] - 1;
            }
            multiplier = multiplier.multiply(BigInteger.valueOf(factor));
            --factor;
        }
        return result;
    }

    public int[] getInverse() {
        int[] inverse = new int[this.permutation.length];
        for (int i = 0; i < this.permutation.length; ++i) {
            inverse[this.permutation[i]] = i;
        }
        return inverse;
    }

    public Permutation getInversePermutation() {
        return new Permutation(this.getInverse(), false);
    }

    public void invert() {
        System.arraycopy(this.getInverse(), 0, this.permutation, 0, this.permutation.length);
        this.hashCodeIsCached = false;
    }

    public void scramble() {
        this.scramble(ThreadLocalRandom.current());
    }

    public void scramble(RandomGenerator r) {
        if (this.permutation.length > 0) {
            this.permutation[0] = 0;
            for (int i = 1; i < this.permutation.length; ++i) {
                int j = RandomIndexer.nextInt(i + 1, r);
                if (j == i) {
                    this.permutation[i] = i;
                    continue;
                }
                this.permutation[i] = this.permutation[j];
                this.permutation[j] = i;
            }
            this.hashCodeIsCached = false;
        }
    }

    public void scramble(boolean guaranteeDifferent) {
        this.scramble(ThreadLocalRandom.current(), guaranteeDifferent);
    }

    public void scramble(RandomGenerator r, boolean guaranteeDifferent) {
        if (guaranteeDifferent) {
            boolean changed = false;
            for (int i = this.permutation.length - 1; i > 1; --i) {
                int j = RandomIndexer.nextInt(i + 1, r);
                if (i == j) continue;
                this.internalSwap(i, j);
                changed = true;
            }
            if (this.permutation.length > 1 && (!changed || r.nextBoolean())) {
                this.internalSwap(0, 1);
            }
            this.hashCodeIsCached = false;
        } else {
            this.scramble(r);
        }
    }

    public void scramble(int i, int j) {
        this.scramble(i, j, ThreadLocalRandom.current());
    }

    public void scramble(int i, int j, RandomGenerator r) {
        int k;
        if (i == j) {
            return;
        }
        if (i > j) {
            k = i;
            i = j;
        } else {
            k = j;
        }
        boolean changed = false;
        while (k > i + 1) {
            int l = i + RandomIndexer.nextInt(k - i + 1, r);
            if (l != k) {
                this.internalSwap(l, k);
                changed = true;
            }
            --k;
        }
        if (!changed || r.nextBoolean()) {
            this.internalSwap(i, i + 1);
        }
        this.hashCodeIsCached = false;
    }

    public void scramble(int[] indexes, RandomGenerator r) {
        if (indexes.length > 1) {
            boolean changed = false;
            for (int j = indexes.length - 1; j > 1; --j) {
                int i = RandomIndexer.nextInt(j + 1, r);
                if (i == j) continue;
                this.internalSwap(indexes[i], indexes[j]);
                changed = true;
            }
            if (!changed || r.nextBoolean()) {
                this.internalSwap(indexes[0], indexes[1]);
            }
            this.hashCodeIsCached = false;
        }
    }

    public void scramble(int[] indexes) {
        this.scramble(indexes, ThreadLocalRandom.current());
    }

    public int get(int i) {
        return this.permutation[i];
    }

    public int[] get(int i, int j) {
        if (j < i) {
            throw new IllegalArgumentException("j must not be less than i");
        }
        return Arrays.copyOfRange(this.permutation, i, j + 1);
    }

    public int[] get(int i, int j, int[] array) {
        if (j < i) {
            throw new IllegalArgumentException("j must not be less than i");
        }
        int n = j - i + 1;
        if (array == null || array.length != n) {
            array = new int[n];
        }
        System.arraycopy(this.permutation, i, array, 0, array.length);
        return array;
    }

    public int[] toArray() {
        return (int[])this.permutation.clone();
    }

    public int[] toArray(int[] array) {
        if (array == null || array.length != this.permutation.length) {
            return (int[])this.permutation.clone();
        }
        System.arraycopy(this.permutation, 0, array, 0, array.length);
        return array;
    }

    public int length() {
        return this.permutation.length;
    }

    public void swap(int i, int j) {
        int temp = this.permutation[i];
        this.permutation[i] = this.permutation[j];
        this.permutation[j] = temp;
        this.hashCodeIsCached = false;
    }

    public void cycle(int[] indexes) {
        if (indexes.length > 1) {
            int temp = this.permutation[indexes[0]];
            for (int i = 1; i < indexes.length; ++i) {
                this.permutation[indexes[i - 1]] = this.permutation[indexes[i]];
            }
            this.permutation[indexes[indexes.length - 1]] = temp;
            this.hashCodeIsCached = false;
        }
    }

    public void swapBlocks(int a, int b, int i, int j) {
        if (a < 0 || b < a || i <= b || j < i || j >= this.permutation.length) {
            throw new IllegalArgumentException("Illegal block definition.");
        }
        if (a == b && i == j) {
            this.swap(a, i);
        } else if (b + 1 == i) {
            this.removeAndInsert(i, j - i + 1, a);
        } else {
            int[] temp = new int[j - b];
            int k = j - i + 1;
            System.arraycopy(this.permutation, i, temp, 0, k);
            int m = i - b - 1;
            System.arraycopy(this.permutation, b + 1, temp, k, m);
            System.arraycopy(this.permutation, a, this.permutation, a + temp.length, b - a + 1);
            System.arraycopy(temp, 0, this.permutation, a, temp.length);
            this.hashCodeIsCached = false;
        }
    }

    public void reverse() {
        this.internalReverse(0, this.permutation.length - 1);
        this.hashCodeIsCached = false;
    }

    public void reverse(int i, int j) {
        if (i > j) {
            this.internalReverse(j, i);
        } else {
            this.internalReverse(i, j);
        }
        this.hashCodeIsCached = false;
    }

    public void removeAndInsert(int i, int j) {
        if (i < j) {
            int n = this.permutation[i];
            System.arraycopy(this.permutation, i + 1, this.permutation, i, j - i);
            this.permutation[j] = n;
            this.hashCodeIsCached = false;
        } else if (i > j) {
            int n = this.permutation[i];
            System.arraycopy(this.permutation, j, this.permutation, j + 1, i - j);
            this.permutation[j] = n;
            this.hashCodeIsCached = false;
        }
    }

    public void rotate(int numPositions) {
        if (numPositions >= this.permutation.length || numPositions < 0) {
            numPositions = Math.floorMod(numPositions, this.permutation.length);
        }
        if (numPositions > 0) {
            int[] temp = new int[numPositions];
            System.arraycopy(this.permutation, 0, temp, 0, numPositions);
            System.arraycopy(this.permutation, numPositions, this.permutation, 0, this.permutation.length - numPositions);
            System.arraycopy(temp, 0, this.permutation, this.permutation.length - numPositions, numPositions);
            this.hashCodeIsCached = false;
        }
    }

    public void removeAndInsert(int i, int size, int j) {
        if (size <= 0 || i == j) {
            return;
        }
        if (size == 1) {
            this.removeAndInsert(i, j);
        } else if (i > j) {
            int[] temp = new int[i - j];
            System.arraycopy(this.permutation, j, temp, 0, i - j);
            System.arraycopy(this.permutation, i, this.permutation, j, size);
            System.arraycopy(temp, 0, this.permutation, j + size, i - j);
            this.hashCodeIsCached = false;
        } else {
            int[] temp = new int[size];
            System.arraycopy(this.permutation, i, temp, 0, size);
            System.arraycopy(this.permutation, i + size, this.permutation, i, j - i);
            System.arraycopy(temp, 0, this.permutation, j, size);
            this.hashCodeIsCached = false;
        }
    }

    public void set(int[] p) {
        if (p.length != this.permutation.length) {
            throw new IllegalArgumentException("Length of array must be same as that of permutation.");
        }
        this.validate(p);
        System.arraycopy(p, 0, this.permutation, 0, p.length);
        this.hashCodeIsCached = false;
    }

    @Override
    public Iterator<Permutation> iterator() {
        return new PermutationIterator(this);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.permutation.length > 0) {
            s.append(this.permutation[0]);
            for (int i = 1; i < this.permutation.length; ++i) {
                s.append(" ");
                s.append(this.permutation[i]);
            }
        }
        return s.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Permutation)) {
            return false;
        }
        Permutation o = (Permutation)other;
        if (this.permutation.length != o.permutation.length) {
            return false;
        }
        for (int i = 0; i < this.permutation.length; ++i) {
            if (this.permutation[i] == o.permutation[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCodeIsCached) {
            return this.hashCode;
        }
        this.hashCodeIsCached = true;
        this.hashCode = Arrays.hashCode(this.permutation);
        return this.hashCode;
    }

    private boolean validate(int[] p) {
        boolean[] inP = new boolean[p.length];
        for (int e : p) {
            if (e < 0 || e >= p.length) {
                throw new IllegalArgumentException("Elements of a Permutation must be in interval [0, length())");
            }
            if (inP[e]) {
                throw new IllegalArgumentException("Duplicate elements are not allowed in a Permutation.");
            }
            inP[e] = true;
        }
        return true;
    }

    private void internalReverse(int i, int j) {
        while (i < j) {
            this.internalSwap(i, j);
            ++i;
            --j;
        }
    }

    final void internalSwap(int i, int j) {
        int temp = this.permutation[i];
        this.permutation[i] = this.permutation[j];
        this.permutation[j] = temp;
    }
}

